(setq *specialops* '(hasPurpose hasPurposeForAgent increasesLikelihood decreasesLikelihood independentProbability ProbabilityFn conditionalProbability independentProbability ProbabilityAttribute ObjectiveNorm Unlikely ProbabilityAttribute ProbabilityRelation Likely immediateSubclass immediateInstance holdsDuring confers confersObligation holdsObligation holdsRight considers Knows believes desires))

(setq *nonproppredicates* '(documentation comment note time format termformat externalImage domain range domainsubclass rangesubclass answer))

(setq *globalname* (make-hash-table))
(setf (gethash 'KAPPAFN *globalname*) t)
(setq *globalargtps* (make-hash-table))
(setq *form* (make-hash-table :test #'equal))
(setq *cl* (make-hash-table :test #'equal))
(setq *oth* (make-hash-table :test #'equal))

(setq *vararity* (make-hash-table :test #'equal))
(setq *vararityclass* (make-hash-table :test #'equal))
(setq *tpinfo* (make-hash-table :test #'equal))
(setq *rtpinfo* (make-hash-table :test #'equal))
(setq *tpinfosub* (make-hash-table :test #'equal))
(setq *rtpinfosub* (make-hash-table :test #'equal))
(setq *vars-preconds-stack* nil)
(setq *vars* nil)
(setq *preconds* nil)
(setq *rowvars* nil)
(setq *rowvarpreconds* nil)

(defun pop-vars-preconds-stack (y)
  (if (sumo-row-var-p y)
      (let* ((rowvars1 (caddr (car *vars-preconds-stack*)))
	     (rowpreconds1 (cadddr (car *vars-preconds-stack*)))
	     (z (remove-if-not #'(lambda (x) (equal (car x) y)) *rowvarpreconds*))
	     (w (remove-if-not #'(lambda (x) (equal (car x) y)) rowpreconds1)))
	(pop *vars-preconds-stack*)
	(if (member y rowvars1)
	    *rowvars*
	  (setq *rowvars* (remove y *rowvars* :test #'equal)))
	(setq *rowvarpreconds* (append w (remove-if #'(lambda (x) (equal (car x) y)) *rowvarpreconds*)))
	z)
    (let* ((vars1 (caar *vars-preconds-stack*))
	   (preconds1 (cadar *vars-preconds-stack*))
	   (z (remove-if-not #'(lambda (x) (equal (cadr x) y)) *preconds*))
	   (w (remove-if-not #'(lambda (x) (equal (cadr x) y)) preconds1)))
      (pop *vars-preconds-stack*)
      (if (member y vars1)
	  *vars*
	(setq *vars* (remove y *vars* :test #'equal)))
      (setq *preconds* (append w (remove-if #'(lambda (x) (equal (cadr x) y)) *preconds*)))
      z)))

(defun sumo-var-p (m)
  (let ((x (format nil "~d" m)))
    (and (> (length x) 0) (eq (aref x 0) #\?))))

(defun sumo-row-var-p (m)
  (let ((x (format nil "~d" m)))
    (and (> (length x) 0) (eq (aref x 0) #\@))))

(defun precond-indep-p-2 (x p bvl)
  (if bvl
      (if (equal p (car bvl))
	  (not (member x bvl :test #'equal))
	(precond-indep-p-2 x p (cdr bvl)))
    t))
    
(defun precond-indep-p (x p bvl &optional bvl2)
  (if (or (sumo-var-p p) (sumo-row-var-p p))
      (if (member x bvl2 :test #'equal)
	  t
	(precond-indep-p-2 x p bvl))
    (if (consp p)
	(case (car p)
	      (KappaFn
	       (precond-indep-p x (caddr p) bvl (cons (cadr p) bvl2)))
	      (forall
	       (precond-indep-p x (caddr p) bvl (append (cadr p) bvl2)))
	      (exists
	       (precond-indep-p x (caddr p) bvl (append (cadr p) bvl2)))
	      (t
	       (precond-indep-p-spine x (cdr p) bvl bvl2)))
      t)))

(defun precond-indep-p-spine (x s bvl bvl2)
  (if s
      (and (precond-indep-p x (car s) bvl bvl2)
	   (precond-indep-p-spine x (cdr s) bvl bvl2))
    t))

(defun mgize-num (m)
  (let ((x (format nil "~d" m))
	(y "n_"))
    (dotimes (i (length x) y)
      (let ((c (char-code (aref x i))))
	(if (and (>= c 48) (< c 58))
	    (setq y (format nil "~d~d" y (aref x i)))
	  (setq y (format nil "~dx~2,'0X" y c)))))))

(defun mgize-name-2 (x)
  (let ((y ""))
    (dotimes (i (length x) y)
      (let ((c (char-code (aref x i))))
	(if (or (and (>= c 48) (< c 58))
		(and (>= c 65) (<= c 90))
		(and (>= c 97) (<= c 122)))
	    (setq y (format nil "~d~d" y (aref x i)))
	  (setq y (format nil "~d_x~2,'0X" y c)))))))
    
(defun mgize-name (m)
  (if (numberp m)
      (mgize-num m)
    (let ((x (format nil "~d" m)))
      (if (> (length x) 0)
	  (cond ((eq (aref x 0) #\?)
		 (format nil "v_~d" (mgize-name-2 (subseq x 1))))
		((eq (aref x 0) #\@)
		 (format nil "r_~d" (mgize-name-2 (subseq x 1))))
					;	      ((and (>= (char-code (aref x 0)) 48)
					;		    (< (char-code (aref x 0)) 58))
					;	       (format nil "n_~d" x))
		(t (format nil "s_~d" (mgize-name-2 x))))
	"null"))))

(defun declare-name (x f)
  (unless (gethash x *globalname*)
    (setf (gethash x *globalname*) t)
    (let ((xx (mgize-name x)))
      (format f "Variable ~d:set.~%" xx)
      (when (equal xx "s_CLASS")
	(format f "Hypothesis s_CLASS_Power_Univ1 : s_CLASS = Power Univ1.~%"))
      (let ((i 1) (a nil) (outtp nil))
	(dolist (tp (gethash x *rtpinfo*))
	  (if outtp
	      (setq outtp (format nil "(~d :/\: ~d)" outtp (sumo-decl-mg-set tp nil f)))
	    (setq outtp (sumo-decl-mg-set tp nil f))))
	(dolist (tp (gethash x *rtpinfosub*))
	  (if outtp
	      (setq outtp (format nil "(~d :/\: Power ~d)" outtp (sumo-decl-mg-set tp nil f)))
	    (setq outtp (format nil "(Power ~d)" (sumo-decl-mg-set tp nil f)))))
	(when outtp
	  (format f "Hypothesis ~d__ran: ran ~d = ~d.~%" xx xx outtp))
	(loop while (or (gethash (list x i) *tpinfo*) (gethash (list x i) *tpinfosub*)) do
	      (setq a nil)
	      (dolist (tp (gethash (list x i) *tpinfo*))
		(if a
		    (setq a (format nil "(~d :/\\: ~d)" a (sumo-decl-mg-set tp nil f)))
		  (setq a (sumo-decl-mg-set tp nil f))))
	      (dolist (tp (gethash (list x i) *tpinfosub*))
		(if a
		    (setq a (format nil "(~d :/\\: Power ~d)" a (sumo-decl-mg-set tp nil f)))
		  (setq a (format nil "(Power ~d)" (sumo-decl-mg-set tp nil f)))))
	      (when a
		(format f "Hypothesis ~d__domseq_~d: domseq ~d ~d = ~d.~%" xx (- i 1) xx (- i 1) a))
	      (incf i))
	(format f "Hypothesis ~d__arity: arity ~d = ~d.~%" xx xx (- i 1))
	(if (gethash x *vararity*)
	    (progn
	      (format f "Hypothesis ~d__vararity: vararity ~d.~%" xx xx)
	      (when a
		(format f "Hypothesis ~d__domseq_~d: domseq ~d ~d = ~d.~%" xx (- i 1) xx (- i 1) a)))
	  (format f "Hypothesis ~d__not_vararity: ~~ vararity ~d.~%" xx xx))
	(case x
	      (RealNumber (format f "Hypothesis ~d__sem: ~d = real.~%" xx xx))
	      (NegativeRealNumber (format f "Hypothesis ~d__sem: ~d = {x :e real|x < 0}.~%" xx xx))
	      (NonNegativeRealNumber (format f "Hypothesis ~d__sem: ~d = {x :e real|0 <= x}.~%" xx xx))
	      (Integer (format f "Hypothesis ~d__sem: ~d = int.~%" xx xx))
	      (lessThan (format f "Hypothesis ~d__sem: forall x y :e real, (bp (ap ~d (listset (cons x (cons y nil))))) = (x < y).~%" xx xx))
	      (greaterThan (format f "Hypothesis ~d__sem: forall x y :e real, (bp (ap ~d (listset (cons x (cons y nil))))) = (y < x).~%" xx xx))
	      (lessThanOrEqualTo (format f "Hypothesis ~d__sem: forall x y :e real, (bp (ap ~d (listset (cons x (cons y nil))))) = (x <= y).~%" xx xx))
	      (greaterThanOrEqualTo (format f "Hypothesis ~d__sem: forall x y :e real, (bp (ap ~d (listset (cons x (cons y nil))))) = (y <= x).~%" xx xx))
	      (AdditionFn (format f "Hypothesis ~d__sem: forall x y :e real, ap ~d (listset (cons x (cons y nil))) = x + y.~%" xx xx))
	      (SubtractionFn (format f "Hypothesis ~d__sem: forall x y :e real, ap ~d (listset (cons x (cons y nil))) = x + - y.~%" xx xx))
	      (MultiplicationFn (format f "Hypothesis ~d__sem: forall x y :e real, ap ~d (listset (cons x (cons y nil))) = x * y.~%" xx xx))
	      (DivisionFn (format f "Hypothesis ~d__sem: forall x y :e real, ap ~d (listset (cons x (cons y nil))) = x :/: y.~%" xx xx))
	      (t nil))))))

(defmacro setpush (a l)
  `(unless (member ,a ,l :test #'equal) (push ,a ,l)))

(defun sumo-entry-1 (p)
  (if (consp p)
      (case (car p)
	    (DOMAIN
	     (let ((c (cadr p)) (n (caddr p)) (tp (nth 3 p)))
	       (setpush tp (gethash (list c n) *tpinfo*))
	       nil))
	    (RANGE
	     (let ((c (cadr p)) (tp (caddr p)))
	       (setpush tp (gethash c *rtpinfo*))
	       nil))
	    (DOMAINSUBCLASS
	     (let ((c (cadr p)) (n (caddr p)) (tp (nth 3 p)))
	       (setpush tp (gethash (list c n) *tpinfosub*))))
	    (RANGESUBCLASS
	     (let ((c (cadr p)) (tp (caddr p)))
	       (setpush tp (gethash c *rtpinfosub*))
	       nil))
	    (subrelation
	     (let ((c (cadr p)) (d (caddr p)) (i 1))
	       (dolist (x (gethash d *rtpinfo*))
		 (setpush x (gethash c *rtpinfo*)))
	       (dolist (x (gethash d *rtpinfosub*))
		 (setpush x (gethash c *rtpinfosub*)))
	       (loop while (or (gethash (list d i) *tpinfo*) (gethash (list d i) *tpinfosub*)) do
		     (dolist (x (gethash (list d i) *tpinfo*))
		       (setpush x (gethash (list c i) *tpinfo*)))
		     (dolist (x (gethash (list d i) *tpinfosub*))
		       (setpush x (gethash (list c i) *tpinfosub*)))
		     (incf i))))
	    (t nil))
    nil))

(defun sumo-entry-2 (p)
  (if (consp p)
      (case (car p)
	    (instance
	     (let ((a (cadr p)) (c (caddr p)))
	       (when (or (eq c 'VariableArityRelation) (gethash c *vararityclass*))
		 (unless (gethash a *vararity*)
		   (setf (gethash a *vararity*) t)
		   t))))
	    (subclass
	     (let ((d (cadr p)) (c (caddr p)))
	       (when (or (eq c 'VariableArityRelation) (gethash c *vararityclass*))
		 (unless (gethash d *vararityclass*)
		   (setf (gethash d *vararityclass*) t)
		   t))))
	    (t nil))
    nil))

(defun globalize-prop (vl pl rvl rpl q)
  (if rpl
      (if (cadddr (car rpl)) ; it's used as a row var appended to some items
	  (let ((extra (cadddr (car rpl)))
		(r "exists")
		(rowvar (mgize-name (caar rpl)))
		(rowvarrepl (mgize-name (caar rpl))))
	    (dotimes (i extra) (setq r (format nil "~d EXTRA~d" r i)) (setq rowvarrepl (format nil "(replseq1 ~d (listlen ~d + ~d) EXTRA~d)" rowvarrepl rowvar i i)))
	    (globalize-prop vl pl rvl (cdr rpl)
			    (format nil "(~d, ~d) -> ~d"
				    r
				    (if (= (caddar rpl) 1) ; no offset
					(format nil "dom_of (vararity ~d) (arity ~d) (domseq ~d) ~d"
						(mgize-name (cadar rpl))
						(mgize-name (cadar rpl))
						(mgize-name (cadar rpl))
						rowvarrepl)
				      (format nil "dom_of (vararity ~d) (trunc_subtract (arity ~d) ~d) (popseq (arity ~d) ~d (domseq ~d)) ~d"
					      (mgize-name (cadar rpl))
					      (mgize-name (cadar rpl))
					      (- (caddar rpl) 1)
					      (mgize-name (cadar rpl))
					      (- (caddar rpl) 1)
					      (mgize-name (cadar rpl))
					      rowvarrepl))
				    q)))
	(if (= (caddar rpl) 1) ; no offset
	    (globalize-prop vl pl rvl (cdr rpl)
			    (format nil "dom_of (vararity ~d) (arity ~d) (domseq ~d) ~d -> ~d"
				    (mgize-name (cadar rpl))
				    (mgize-name (cadar rpl))
				    (mgize-name (cadar rpl))
				    (mgize-name (caar rpl)) q))
	  (globalize-prop vl pl rvl (cdr rpl)
			  (format nil "dom_of (vararity ~d) (trunc_subtract (arity ~d) ~d) (popseq (arity ~d) ~d (domseq ~d)) ~d -> ~d"
				  (mgize-name (cadar rpl))
				  (mgize-name (cadar rpl))
				  (- (caddar rpl) 1)
				  (mgize-name (cadar rpl))
				  (- (caddar rpl) 1)
				  (mgize-name (cadar rpl))
				  (mgize-name (caar rpl)) q))))
    (if pl
	(globalize-prop vl (cdr pl) rvl nil (format nil "~d -> ~d" (cadddr (car pl)) q))
      (if rvl
	  (globalize-prop vl nil (cdr rvl) nil (format nil "forall ~d:set -> set, ~d" (mgize-name (car rvl)) q))
	(if vl
	    (globalize-prop (cdr vl) nil nil nil (format nil "forall ~d, ~d" (mgize-name (car vl)) q))
	  q)))))

(defun globalize-query (vl pl rvl rpl q)
  (when (or rvl rpl) (throw 'fail "Please do not use free ROW variables in queries"))
  (if pl
      (globalize-query vl (cdr pl) rvl nil (format nil "~d /\\ ~d" (cadddr (car pl)) q))
    (if vl
	(globalize-query (cdr vl) nil nil nil (format nil "exists ~d, ~d" (mgize-name (car vl)) q))
      q)))

(defun conjoin-guards (pl q)
  (if pl
      (conjoin-guards (cdr pl) (format nil "~d /\\ ~d" (cadddr (car pl)) q))
    q))

(defun imp-guards (pl q)
  (if pl
      (imp-guards (cdr pl) (format nil "~d -> ~d" (cadddr (car pl)) q))
    q))

(defun conjoin-row-guards (pl q)
  (if pl
      (if (cadddr (car pl)) ; it's used as a row var appended to some items
	  (let ((extra (cadddr (car pl)))
		(r "exists")
		(rowvar (mgize-name (caar pl)))
		(rowvarrepl (mgize-name (caar pl))))
	    (dotimes (i extra) (setq r (format nil "~d EXTRA~d" r i)) (setq rowvarrepl (format nil "(replseq1 ~d (listlen ~d + ~d) EXTRA~d)" rowvarrepl rowvar i i)))
	    (conjoin-row-guards (cdr pl)
				(format nil "(~d, ~d) /\\ ~d"
					r
					(if (= (caddar pl) 1) ; no offset
					    (format nil "dom_of (vararity ~d) (arity ~d) (domseq ~d) ~d"
						    (mgize-name (cadar pl))
						    (mgize-name (cadar pl))
						    (mgize-name (cadar pl))
						    rowvarrepl)
					  (format nil "dom_of (vararity ~d) (trunc_subtract (arity ~d) ~d) (popseq (arity ~d) ~d (domseq ~d)) ~d"
						  (mgize-name (cadar pl))
						  (mgize-name (cadar pl))
						  (- (caddar pl) 1)
						  (mgize-name (cadar pl))
						  (- (caddar pl) 1)
						  (mgize-name (cadar pl))
						  rowvarrepl))
					q)))
	(conjoin-row-guards (cdr pl)
			    (format nil "~d /\\ ~d"
				    (if (= (caddar pl) 1) ; no offset
					(format nil "dom_of (vararity ~d) (arity ~d) (domseq ~d) ~d"
						(mgize-name (cadar pl))
						(mgize-name (cadar pl))
						(mgize-name (cadar pl))
						(mgize-name (caar pl)))
				      (format nil "dom_of (vararity ~d) (trunc_subtract (arity ~d) ~d) (popseq (arity ~d) ~d (domseq ~d)) ~d"
					      (mgize-name (cadar pl))
					      (mgize-name (cadar pl))
					      (- (caddar pl) 1)
					      (mgize-name (cadar pl))
					      (- (caddar pl) 1)
					      (mgize-name (cadar pl))
					      (mgize-name (caar pl))))
				    q)))
    q))

(defun imp-row-guards (pl q)
  (if pl
      (if (cadddr (car pl)) ; it's used as a row var appended to some items
	  (let ((extra (cadddr (car pl)))
		(r "exists")
		(rowvar (mgize-name (caar pl)))
		(rowvarrepl (mgize-name (caar pl))))
	    (dotimes (i extra) (setq r (format nil "~d EXTRA~d" r i)) (setq rowvarrepl (format nil "(replseq1 ~d (listlen ~d + ~d) EXTRA~d)" rowvarrepl rowvar i i)))
	    (imp-row-guards (cdr pl)
			    (format nil "(~d, ~d) -> ~d"
				    r
				    (if (= (caddar pl) 1) ; no offset
					(format nil "dom_of (vararity ~d) (arity ~d) (domseq ~d) ~d"
						(mgize-name (cadar pl))
						(mgize-name (cadar pl))
						(mgize-name (cadar pl))
						rowvarrepl)
				      (format nil "dom_of (vararity ~d) (trunc_subtract (arity ~d) ~d) (popseq (arity ~d) ~d (domseq ~d)) ~d"
					      (mgize-name (cadar pl))
					      (mgize-name (cadar pl))
					      (- (caddar pl) 1)
					      (mgize-name (cadar pl))
					      (- (caddar pl) 1)
					      (mgize-name (cadar pl))
					      rowvarrepl))
				    q)))
	(imp-row-guards (cdr pl)
			(format nil "~d -> ~d"
				(if (= (caddar pl) 1) ; no offset
				    (format nil "dom_of (vararity ~d) (arity ~d) (domseq ~d) ~d"
					    (mgize-name (cadar pl))
					    (mgize-name (cadar pl))
					    (mgize-name (cadar pl))
					    (mgize-name (caar pl)))
				  (format nil "dom_of (vararity ~d) (trunc_subtract (arity ~d) ~d) (popseq (arity ~d) ~d (domseq ~d)) ~d"
					  (mgize-name (cadar pl))
					  (mgize-name (cadar pl))
					  (- (caddar pl) 1)
					  (mgize-name (cadar pl))
					  (- (caddar pl) 1)
					  (mgize-name (cadar pl))
					  (mgize-name (caar pl))))
				q)))
    q))

(defun e (m n)
  (if (> n 0)
      1
    (* m (e m (- n 1)))))

(defun sumo-decl-mg-natural (m)
  (if (< m 11)
      (format nil "~d" m)
    (format nil "(~d * 10 + ~d)" (sumo-decl-mg-natural (/ (- m (mod m 10)) 10)) (mod m 10))))

(defun sumo-decl-mg-integer (m)
  (if (< m 0)
      (format nil "(- ~d)" (sumo-decl-mg-natural (- m)))
    (sumo-decl-mg-natural m)))

(defun sumo-decl-mg-number (m)
  (if (integerp m)
      (sumo-decl-mg-integer m)
    (let* ((ms (format nil "~f" m))
	   (p (position #\. ms)))
      (if p
	  (if (equal (subseq ms p) ".0")
	      (sumo-decl-mg-integer (read-from-string (subseq ms 0 p)))
	    (let* ((n (- (length ms) (1+ p)))
		   (x (sumo-decl-mg-integer (read-from-string (format nil "~d~d" (subseq ms 0 p) (subseq ms (1+ p)))))))
	      (format nil "(~d :/: 10 ^ ~d)" x n)))
	(throw 'fail (list 'nonintnotfloat m))))))
  
(defun sumo-decl-mg-set (m bvl f)
  (if (consp m)
      (cond ((eq (car m) 'KappaFn)
	     (let ((x (cadr m)))
	       (when (sumo-row-var-p x) (error "Please do not use KappaFn with row variables."))
	       (push (list *vars* *preconds* *rowvars* *rowvarpreconds*) *vars-preconds-stack*)
	       (let ((p (sumo-decl-mg-form (caddr m) (cons x bvl) f)))
		 (let ((pre (pop-vars-preconds-stack x)))
		   (format nil "{~d :e Univ1 | ~d}" (mgize-name x) (conjoin-guards pre p))))))
	    ((member (car m) '(instance subclass equal not => <=> and or forall exists modalAttribute))
	     (let ((p (sumo-decl-mg-form m bvl f)))
	       (format nil "(pb ~d)" p)))
	    (t
	     (when (member (car m) *specialops*) (throw 'fail (list 'special (car m))))
	     (unless (sumo-var-p (car m)) (declare-name (car m) f))
	     (when (sumo-var-p (car m)) (setpush (car m) *vars*))
	     (format nil "(ap ~d (listset ~d))" (mgize-name (car m)) (sumo-decl-mg-spine (car m) 1 (cdr m) bvl f))))
    (if (numberp m)
	(sumo-decl-mg-number m)
      (progn
	(when (member m *specialops*) (throw 'fail (list 'special m)))
	(when (member m '(instance subclass equal not => <=> and or forall exists modalAttribute))
	  (throw 'fail (list 'dont-use-these-special-things-as-constants m)))
	(unless (sumo-var-p m) (declare-name m f))
	(format nil "~d" (mgize-name m))))))

(defun sumo-decl-mg-spine (h i s bvl f)
  (if s
      (if (sumo-row-var-p (car s))
	  (if (null (cdr s))
	      (progn
		(setpush (car s) *rowvars*)
		(when (precond-indep-p (car s) h bvl)
		  (setpush (list (car s) h i) *rowvarpreconds*))
		(mgize-name (car s)))
	    (if (null (cddr s))
		(progn
		  (setpush (car s) *rowvars*)
		  (when (precond-indep-p (car s) h bvl)
		    (setpush (list (car s) h i 1) *rowvarpreconds*))
		  (let ((a (cadr s)))
		    (when (sumo-var-p a)
		      (setpush a *vars*)
		      (unless (find-if #'(lambda (x) (and (eq (car x) 'DOM) (eq (car x) a) (equal (caddr x) (list h i)))) *preconds*)
			(when (precond-indep-p a h bvl)
			  (let ((q (format nil "~d :e domseqm ~d (listlen ~d)" (mgize-name a) (mgize-name h) (mgize-name (car s)))))
			    (push (list 'DOM a (list h i) q) *preconds*)))))
		    (format nil "(replseq1 ~d (listlen ~d) ~d)" (mgize-name (car s)) (mgize-name (car s)) (sumo-decl-mg-set a bvl f))))
	      (let ((j 0)
		    (rowvar (mgize-name (car s)))
		    (r nil))
		(setpush (car s) *rowvars*)
		(when (precond-indep-p (car s) h bvl)
		  (setpush (list (car s) h i (length (cdr s))) *rowvarpreconds*))
		(dolist (a (cdr s))
		  (when (sumo-var-p a)
		    (setpush a *vars*)
		    (unless (find-if #'(lambda (x) (and (eq (car x) 'DOM) (eq (car x) a) (equal (caddr x) (list h j)))) *preconds*)
		      (when (precond-indep-p a h bvl)
			(let ((q (if (> j 0)
				     (format nil "~d :e domseqm ~d (listlen ~d + ~d)" (mgize-name a) (mgize-name h) rowvar j)
				   (format nil "~d :e domseqm ~d (listlen ~d)" (mgize-name a) (mgize-name h) rowvar))))
			  (push (list 'DOM a (list h j) q) *preconds*)))))
		  (incf j))
		(setq j 0)
		(setq r rowvar)
		(dolist (a (cdr s) r)
		  (if (> j 0)
		      (setq r (format nil "(replseq1 ~d (listlen ~d + ~d) ~d)" r rowvar j (sumo-decl-mg-set a bvl f)))
		    (setq r (format nil "(replseq1 ~d (listlen ~d) ~d)" r rowvar (sumo-decl-mg-set a bvl f))))
		  (incf j)))))
	(let ((a (car s)))
	  (when (sumo-var-p a)
	    (setpush a *vars*)
	    (unless (find-if #'(lambda (x) (and (eq (car x) 'DOM) (eq (cadr x) a) (equal (caddr x) (list h (- i 1))))) *preconds*)
	      (when (precond-indep-p a h bvl)
		(let ((q (format nil "~d :e domseqm ~d ~d" (mgize-name a) (mgize-name h) (- i 1))))
		  (push (list 'DOM a (list h (- i 1)) q) *preconds*)))))
	  (format nil "(cons ~d ~d)"
		  (sumo-decl-mg-set a bvl f)
		  (sumo-decl-mg-spine h (1+ i) (cdr s) bvl f))))
      "nil"))

(defun sumo-decl-mg-modal-spine (sk h i s bvl f)
  (if s
      (if (sumo-row-var-p (car s))
	  (throw 'skip (list "not willing to think about modal rows" s))
	(if (equal sk i)
	    (sumo-decl-mg-modal-spine sk h (1+ i) (cdr s) bvl f)
	  (let ((a (car s)))
	    (when (sumo-var-p (car s))
	      (setpush a *vars*)
	      (unless (find-if #'(lambda (x) (and (eq (car x) 'DOM) (eq (cadr x) a) (equal (caddr x) (list h (- i 1))))) *preconds*)
		(when (precond-indep-p a h bvl)
		  (let ((q (format nil "~d :e domseqm ~d ~d" (mgize-name a) (mgize-name h) (- i 1))))
		    (push (list 'DOM a (list h (- i 1)) q) *preconds*)))))
	    (format nil "(cons ~d ~d)"
		    (sumo-decl-mg-set a bvl f)
		    (sumo-decl-mg-modal-spine sk h (1+ i) (cdr s) bvl f)))))
    "nil"))

(defun sumo-decl-mg-form (m bvl f)
  (if (consp m)
      (case (car m)
	    (equal
	     (if (sumo-var-p (cadr m))
		 (progn
		   (setpush (cadr m) *vars*)
		   (if (sumo-var-p (caddr m))
		       (setpush (caddr m) *vars*)
		     (when (consp (caddr m))
		       (let ((a (cadr m)))
			 (dolist (tp (gethash (caaddr m) *rtpinfo*))
			   (unless (find-if #'(lambda (x) (and (eq (car x) 'IN) (equal (cadr x) a) (equal (caddr x) tp))) *preconds*)
			     (when (precond-indep-p a tp bvl)
			       (let ((q (format nil "~d :e ~d" (mgize-name a) (sumo-decl-mg-set tp bvl f))))
				 (push (list 'IN a tp q) *preconds*)))))
			 (dolist (tp (gethash (caaddr m) *rtpinfosub*))
			   (unless (find-if #'(lambda (x) (and (eq (car x) 'SUB) (equal (cadr x) a) (equal (caddr x) tp))) *preconds*)
			     (when (precond-indep-p a tp bvl)
			       (let ((q (format nil "~d c= ~d" (mgize-name a) (sumo-decl-mg-set tp bvl f))))
				 (push (list 'SUB a tp q) *preconds*)))))))))
	       (when (sumo-var-p (caddr m))
		 (setpush (caddr m) *vars*)
		 (when (consp (cadr m))
		   (let ((a (caddr m)))
		     (dolist (tp (gethash (caadr m) *rtpinfo*))
		       (unless (find-if #'(lambda (x) (and (eq (car x) 'IN) (equal (cadr x) a) (equal (caddr x) tp))) *preconds*)
			 (when (precond-indep-p a tp bvl)
			   (let ((q (format nil "~d :e ~d" (mgize-name a) (sumo-decl-mg-set tp bvl f))))
			     (push (list 'IN a tp q) *preconds*)))))
		     (dolist (tp (gethash (caadr m) *rtpinfosub*))
		       (unless (find-if #'(lambda (x) (and (eq (car x) 'SUB) (equal (cadr x) a) (equal (caddr x) tp))) *preconds*)
			 (when (precond-indep-p a tp bvl)
			   (let ((q (format nil "~d c= ~d" (mgize-name a) (sumo-decl-mg-set tp bvl f))))
			     (push (list 'SUB a tp q) *preconds*)))))))))
	     (format nil "(~d = ~d)" (sumo-decl-mg-set (cadr m) bvl f) (sumo-decl-mg-set (caddr m) bvl f)))
	    (not
	     (format nil "(~~ ~d)" (sumo-decl-mg-form (cadr m) bvl f)))
	    (=>
	     (format nil "(~d -> ~d)" (sumo-decl-mg-form (cadr m) bvl f) (sumo-decl-mg-form (caddr m) bvl f)))
	    ((<=> truth)
	     (format nil "(~d <-> ~d)" (sumo-decl-mg-form (cadr m) bvl f) (sumo-decl-mg-form (caddr m) bvl f)))
	    (and
	     (sumo-decl-mg-and (cdr m) bvl f))
	    (or
	     (sumo-decl-mg-or (cdr m) bvl f))
	    (forall
	     (sumo-decl-mg-forall (cadr m) (caddr m) bvl f))
	    (exists
	     (sumo-decl-mg-exists (cadr m) (caddr m) bvl f))
	    (instance
	     (when (sumo-var-p (cadr m))
	       (let ((a (cadr m))
		     (tp 'ENTITY))
		 (setpush a *vars*)
		 (unless (find-if #'(lambda (x) (and (eq (car x) 'IN) (equal (cadr x) a) (equal (caddr x) tp))) *preconds*)
		   (when (precond-indep-p a tp bvl)
		     (let ((q (format nil "~d :e ~d" (mgize-name a) (sumo-decl-mg-set tp bvl f))))
		       (push (list 'IN a tp q) *preconds*))))))
	     (when (sumo-var-p (caddr m))
	       (let ((a (caddr m))
		     (tp 'CLASS))
		 (setpush a *vars*)
		 (unless (find-if #'(lambda (x) (and (eq (car x) 'IN) (equal (cadr x) a) (equal (caddr x) tp))) *preconds*)
		   (when (precond-indep-p a tp bvl)
		     (let ((q (format nil "~d :e ~d" (mgize-name a) (sumo-decl-mg-set tp bvl f))))
		       (push (list 'IN a tp q) *preconds*))))))
	     (format nil "(~d :e ~d)" (sumo-decl-mg-set (cadr m) bvl f) (sumo-decl-mg-set (caddr m) bvl f)))
	    (subclass
	     (when (sumo-var-p (cadr m))
	       (let ((a (cadr m))
		     (tp 'CLASS))
		 (setpush a *vars*)
		 (unless (find-if #'(lambda (x) (and (eq (car x) 'IN) (equal (cadr x) a) (equal (caddr x) tp))) *preconds*)
		   (when (precond-indep-p a tp bvl)
		     (let ((q (format nil "~d :e ~d" (mgize-name a) (sumo-decl-mg-set tp bvl f))))
		       (push (list 'IN a tp q) *preconds*))))))
	     (when (sumo-var-p (caddr m))
	       (let ((a (caddr m))
		     (tp 'CLASS))
		 (setpush a *vars*)
		 (unless (find-if #'(lambda (x) (and (eq (car x) 'IN) (equal (cadr x) a) (equal (caddr x) tp))) *preconds*)
		   (when (precond-indep-p a tp bvl)
		     (let ((q (format nil "~d :e ~d" (mgize-name a) (sumo-decl-mg-set tp bvl f))))
		       (push (list 'IN a tp q) *preconds*))))))
	     (format nil "(~d c= ~d)" (sumo-decl-mg-set (cadr m) bvl f) (sumo-decl-mg-set (caddr m) bvl f)))
	    (modalAttribute
	     (throw 'fail (list 'modality m)))
	    (t
	     (when (member (car m) *specialops*)
	       (throw 'fail (list 'form-special (car m))))
	     (format nil "(bp ~d)" (sumo-decl-mg-set m bvl f))))
    (case m
	  (True "True")
	  (False "False")
	  (t
	   (when (member m *specialops*)
	     (throw 'fail (list 'form-special m)))
	   (when (sumo-var-p m) (setpush m *vars*))
	   (format nil "(bp ~d)" (sumo-decl-mg-set m bvl f))))))

(defun sumo-decl-mg-and (pl bvl f)
  (if pl
      (if (cdr pl)
	  (format nil "~d /\\ ~d"
		  (sumo-decl-mg-form (car pl) bvl f)
		  (sumo-decl-mg-and (cdr pl) bvl f))
	(sumo-decl-mg-form (car pl) bvl f))
    "$true"))

(defun sumo-decl-mg-or (pl bvl f)
  (if pl
      (if (cdr pl)
	  (format nil "~d \\/ ~d"
		  (sumo-decl-mg-form (car pl) bvl f)
		  (sumo-decl-mg-or (cdr pl) bvl f))
	(sumo-decl-mg-form (car pl) bvl f))
    "$false"))

(defun sumo-decl-mg-forall (xl p bvl f)
  (if xl
      (if (sumo-row-var-p (car xl))
	  (progn
	    (push (list *vars* *preconds* *rowvars* *rowvarpreconds*) *vars-preconds-stack*)
	    (let ((q (sumo-decl-mg-forall (cdr xl) p (cons (car xl) bvl) f)))
	      (let ((pre (pop-vars-preconds-stack (car xl))))
		(format nil "(forall ~d:set -> set, ~d)" (mgize-name (car xl)) (imp-row-guards pre q)))))
	(progn
	  (push (list *vars* *preconds* *rowvars* *rowvarpreconds*) *vars-preconds-stack*)
	  (let ((q (sumo-decl-mg-forall (cdr xl) p (cons (car xl) bvl) f)))
	    (let ((pre (pop-vars-preconds-stack (car xl))))
	      (format nil "(forall ~d, ~d)" (mgize-name (car xl)) (imp-guards pre q))))))
    (sumo-decl-mg-form p bvl f)))

(defun sumo-decl-mg-exists (xl p bvl f)
  (if xl
      (if (sumo-row-var-p (car xl))
	  (progn
	    (push (list *vars* *preconds* *rowvars* *rowvarpreconds*) *vars-preconds-stack*)
	    (let ((q (sumo-decl-mg-exists (cdr xl) p (cons (car xl) bvl) f)))
	      (let ((pre (pop-vars-preconds-stack (car xl))))
		(format nil "(exists ~d:set -> set, ~d)" (mgize-name (car xl)) (conjoin-row-guards pre q)))))
	(progn
	  (push (list *vars* *preconds* *rowvars* *rowvarpreconds*) *vars-preconds-stack*)
	  (let ((q (sumo-decl-mg-exists (cdr xl) p (cons (car xl) bvl) f)))
	    (let ((pre (pop-vars-preconds-stack (car xl))))
	      (format nil "(exists ~d, ~d)" (mgize-name (car xl)) (conjoin-guards pre q))))))
    (sumo-decl-mg-form p bvl f)))

(defun sumo-decl-mg (l nm f)
  (when (and (consp l)
	     (not (member (car l) *nonproppredicates*)))
    (case (car l)
	  (instance
	   (unless (eq (cadr l) 'KAPPAFN)
	     (setq *vars-preconds-stack* nil)
	     (setq *vars* nil)
	     (setq *preconds* nil)
	     (setq *rowvars* nil)
	     (setq *rowvarpreconds* nil)
	     (let ((p (sumo-decl-mg-set (caddr l) nil f))
		   (a (sumo-decl-mg-set (cadr l) nil f)))
	       (format f "Hypothesis ~d: ~d.~%" nm (globalize-prop *vars* *preconds* *rowvars* *rowvarpreconds* (format nil "(~d :e ~d)" a p))))))
	  (subclass
	   (unless (eq (cadr l) 'KAPPAFN)
	     (setq *vars-preconds-stack* nil)
	     (setq *vars* nil)
	     (setq *preconds* nil)
	     (setq *rowvars* nil)
	     (setq *rowvarpreconds* nil)
	     (let ((p (sumo-decl-mg-set (cadr l) nil f))
		   (q (sumo-decl-mg-set (caddr l) nil f)))
	       (format f "Hypothesis ~d_exp: ~d.~%" nm (globalize-prop *vars* *preconds* *rowvars* *preconds* (format nil "(forall x :e ~d, x :e ~d)" p q)))
	       (if (member (cadr l) '(CLASS SETORCLASS ABSTRACT ENTITY))
		   (format f "Hypothesis ~d_Power_Power_Univ1_1: ~d.~%" nm (globalize-prop *vars* *preconds* *rowvars* *rowvarpreconds* (format nil "(~d :e Power (Power Univ1))" p)))
		 (format f "Hypothesis ~d_Power_Univ1_1: ~d.~%" nm (globalize-prop *vars* *preconds* *rowvars* *rowvarpreconds* (format nil "(~d :e Power Univ1)" p))))
	       (if (member (caddr l) '(CLASS SETORCLASS ABSTRACT ENTITY))
		   (format f "Hypothesis ~d_Power_Power_Univ1_2: ~d.~%" nm (globalize-prop *vars* *preconds* *rowvars* *rowvarpreconds* (format nil "(~d :e Power (Power Univ1))" q)))
		 (format f "Hypothesis ~d_Power_Univ1_2: ~d.~%" nm (globalize-prop *vars* *preconds* *rowvars* *rowvarpreconds* (format nil "(~d :e Power Univ1)" q)))))))
	  (query
	   (setq *vars-preconds-stack* nil)
	   (setq *vars* nil)
	   (setq *preconds* nil)
	   (setq *rowvars* nil)
	   (setq *rowvarpreconds* nil)
	   (let ((pbody (sumo-decl-mg-form (cadr l) nil f)))
	     (format f "Theorem ~d: ~d.~%admit.~%Qed.~%~%" nm (globalize-query *vars* *preconds* *rowvars* *rowvarpreconds* pbody))))
	  (t
	   (setq *vars-preconds-stack* nil)
	   (setq *vars* nil)
	   (setq *preconds* nil)
	   (setq *rowvars* nil)
	   (setq *rowvarpreconds* nil)
	   (let ((pbody (sumo-decl-mg-form l nil f)))
	     (format f "Hypothesis ~d: ~d.~%" nm (globalize-prop *vars* *preconds* *rowvars* *rowvarpreconds* pbody)))))))

(defun main ()
  (if (not (cddr sb-ext:*posix-argv*))
      (format t "Usage: sumo2set-7.0 <sumofile1> .. <sumofilen> <mgoutfile>~%")
    (let ((fnl (reverse (cdr (reverse (cdr sb-ext:*posix-argv*)))))
	  (gn (car (last sb-ext:*posix-argv*))))
      (let ((fn (find-if-not #'(lambda (fn) (probe-file fn)) fnl)))
	(if fn
	    (format t "File ~d does not exist.~%" fn)
	  (progn
	    (dolist (fn fnl)
					; pass 1, getting domain, range info
	      (setq skip1l nil)
	      (setq f (open fn :direction :input))
	      (loop while (setq l (read f nil nil)) do
		    (let ((z (sumo-entry-1 l)))
		      (when z (push (cons z l) skip1l))))
	      (close f))
					; passes 2-n: find all variable arity classes and instances
	    ; try only doing 1 pass
	    (dolist (fn fnl)
	      (setq f (open fn :direction :input))
	      (loop while (setq l (read f nil nil)) do
		    (sumo-entry-2 l))
	      (close f))
	    (setq g (open gn :direction :output :if-exists :supersede :if-does-not-exist :create))
	    (format g "Let trunc_subtract : set -> set -> set := fun x y => if y < x then x + - y else 0.~%")
	    (format g "Let nil : set -> set := fun _ => 0.~%")
	    (format g "Let cons : set -> (set -> set) -> set -> set := fun a l i => nat_primrec (Inj1 a) (fun m _ => l m) i.~%")
	    (format g "Let listlen : (set -> set) -> set := fun l => {i :e omega|l i <> 0}.~%")
	    (format g "Let replseq1 : (set -> set) -> set -> set -> set -> set := fun l n a i => if i = n then Inj1 a else l i.~%")
            (format g "Let listset : (set -> set) -> set := fun l => fun i :e omega => l i.~%")
	    (format g "Variable Univ1:set.~%")
	    (format g "Variable vararity:set -> prop.~%")
	    (format g "Variable arity:set -> set.~%")
	    (format g "Variable domseq:set -> set -> set.~%")
	    (format g "Definition popseq:set -> set -> (set -> set) -> set -> set := fun ar n l i => l (if n + i < ar then n + i else ar).~%")
	    (format g "Definition domseqm:set -> set -> set := fun u i => if vararity u then domseq u (if i :e arity u then i else arity u) else domseq u i.~%")
	    (format g "Variable ran:set -> set.~%")
	    (format g "Definition dom_of_fixedar:set -> (set -> set) -> (set -> set) -> prop :=~%")
	    (format g "  fun ar dseq u =>~%")
	    (format g "        listlen u = ar~%")
	    (format g "    /\\ (forall i :e ar, Unj (u i) :e dseq i).~%")
	    (format g "Definition dom_of_varar:set -> (set -> set) -> (set -> set) -> prop :=~%")
	    (format g "  fun ar dseq u =>~%")
	    (format g "        ar c= listlen u~%")
	    (format g "    /\\ (forall i :e ar, Unj (u i) :e dseq i)~%")
	    (format g "    /\\ (forall i :e listlen u, ar c= i -> Unj (u i) :e dseq ar).~%")
	    (format g "Definition dom_of:prop -> set -> (set -> set) -> (set -> set) -> prop :=~%")
	    (format g "  fun varar ar dseq u => varar /\\ dom_of_varar ar dseq u \\/ ~~varar /\\ dom_of_fixedar ar dseq u.~%")
	    (format g "Hypothesis arity_omega : forall v, arity v :e omega.~%")
	    (format g "Hypothesis arity_domseq : forall v, forall i :e arity v, domseq v i :e Power Univ1 :\\/: Power (Power Univ1).~%")
	    (format g "Hypothesis vararity_domseq : forall v, vararity v -> domseq v (arity v) :e Power Univ1 :\\/: Power (Power Univ1).~%")
	    (format g "Hypothesis dom_ran : forall v, forall u:set -> set, dom_of (vararity v) (arity v) (domseq v) u -> ap v (fun i :e omega => u i) :e ran v.~%")
	    (format g "Let bp:set -> prop := fun X => 0 :e X.~%")
	    (format g "Let pb:prop -> set := fun p => if p then 1 else 0.~%")
	    (setq cnt 0)
	    (setq skip2l nil)
	    (dolist (fn fnl)
	      (setq f (open fn :direction :input))
	      (loop while (setq l (read f nil nil)) do
		    (let ((z (catch 'fail (sumo-decl-mg l (format nil "p~d" (incf cnt)) g))))
		      (when z (push z skip2l))))
	      (close f))
	    (close g)))))))
      
(sb-ext:save-lisp-and-die "sumo2set-0.9" :executable t :toplevel #'main)
