(* Example usage: ./align *)
open Toolbox
open Pattern
open Scoring

let iterative_flag = ref false

(* Parse command-line arguments, exiting with help if not valid.
   TODO: Read a conjecture itself, not its name. *)
let parse_commandline () =
  (* Saving results into two references and a array. *)
  let anon_counter = ref 0 in
  let anon_tab = Array.make 3 "" in
  let parse_anon anon = anon_tab.(!anon_counter) <- anon; incr anon_counter in
  let speclist =
    [
     ("-s", Arg.Set subterm_flag,  
      "\nConsider frequent higher-order ground subterms as concepts.");
     ("-t", Arg.Set constant_type_flag, 
      "\nType judgements are included in the patterns");
     ("-i", Arg.Set iterative_flag, 
      "\nIterate the scoring algorithm.");
     ("-d", Arg.Set disambiguate_flag, 
     "\nPenalize concepts with multiple counterparts (only use with -i).");
     ("-g", Arg.Set greedy_flag, 
     "\nForces concepts to match only one counterpart (only use with -i).");
     ("-c", Arg.Set type_coherence_flag, 
     "\nGuarantees that if two matched constants have their types matched" ^
      " (only use with -i).")
   ]
  in
  let usage_msg = "Conjecture-maker. Usage: " ^ Sys.argv.(0) ^ " <dir_in> <dir_out>" in
  Arg.parse speclist parse_anon usage_msg;
  (anon_tab.(0), anon_tab.(1), anon_tab.(2))


(* Main function. *)
let _ =
  no_type_flag := true;
  constant_type_flag := false;
  subterm_flag := false;
  let (dir1,dir2,dir_out) = parse_commandline () in
  if !iterative_flag 
     then advice_glob := first_advice 
     else advice_glob := break_advice
  ;
  if !constant_type_flag then no_type_flag := false else ();
  match_provers_dir dir_out (dir1,dir2)
;;
