open Toolbox 
open Init
open Pattern
open Matching_multiple

let multexp_dir = data_dir ^ "/matching/match_multiple"

(*--------------------------------------------------------------------------
  Stats for number of types, constants and theorems
  -------------------------------------------------------------------------- *)

let rec all_const vl tm = match tm with
    Hh_term.Id x -> if List.mem x vl then [] else [x]
  | Hh_term.Comb (x, y) -> all_const vl x @ all_const vl y
  | Hh_term.Abs (v,ty,tm) -> all_const vl ty @ all_const (v :: vl) tm

let all_constants tm = mk_fast_set compare (all_const [] tm)

let rec all_ty vl bty tm = match tm with
    Hh_term.Id x -> if (List.mem x vl || not bty) then [] else [x]
  | Hh_term.Comb (x, y) -> all_ty vl bty x @ all_ty vl bty y
  | Hh_term.Abs (v,ty,tm) -> all_ty vl true ty @ all_ty (v :: vl) bty tm

let all_types tm = mk_fast_set compare (all_ty [] false tm)

let objects_stats prover =
  let dir_in = lib_of prover in
  let dir_out = multexp_dir ^ "/objects_stats" in mkdir dir_out;
  let file_out = dir_out ^ "/" ^ prover in
  let ((tyl,cl,thml),(_,_,thmlo)) = init_dir dir_in
  in
  let append_aux = append file_out in
  erase_file file_out;
  append_aux ("Loading objects from " ^ dir_in ^ "\n");
  append_aux ("- types: " ^ string_of_int (List.length tyl) ^ "\n");
  append_aux ("- constants: " ^ string_of_int (List.length cl) ^ "\n");
  append_aux ("- theorems: " ^ string_of_int (List.length thml) ^ "\n");
  append_aux ("- theories: "^ string_of_int (List.length thmlo) ^ "\n\n");
  if prover = "miz" then
    begin
    let l0 = List.map (all_types ++ snd) thml in
    let l1 = mk_fast_set compare (List.concat l0) in
    let nty = List.length l1 in
    append_aux ("- types (type judgement): " ^ string_of_int nty ^ "\n");
    end
  else
  begin
    let l0 = List.map (all_constants ++ snd) (tyl @ cl) in
    let l1 = mk_fast_set compare (List.concat l0) in
    let nty = List.length l1 in
    let nc= List.length (tyl @ cl) - nty in
    append_aux ("- types (type judgement): " ^ string_of_int nty ^ "\n");
    append_aux ("- constants (not type judgement): " ^ string_of_int nc ^ "\n\n") 
  end
  
(*  rlwrap ./top -I ../hh1 -I ..
open Multiple_experiments;;
open Pattern;;
open Matching_multiple;;
Init.smaller_thm_flag := true;;
objects_stats "cakeml";;

List.iter objects_stats prover_list;;
*)

(*--------------------------------------------------------------------------
  Stats for normalization of one prover with long patterns.
  -------------------------------------------------------------------------- *)

let onelib_stats n expname prover =
  let thm_h = Hashtbl.create max_thms in
  mkdir_rec expname;
  let dir_in = lib_of prover in
  let dir_out = expname ^ "/" ^ prover in
  mkdir_rec dir_out;
  let file_out = dir_out ^ "/stats" in
  erase_file file_out;
  let append_aux = append file_out in
  let (objects,_) = time_file file_out "init" init_dir dir_in in
  clear_match (); (* important *)
  set_prover 1; 
  time_file file_out "norm" init_dicts_noclear objects;
  time_file file_out "prop" init_p_hash_onelib ();
  append_aux ("nb of constant: " ^ string_of_int !nb_of_constants1 ^ "\n");
  append_aux ("nb of subterms: " ^ string_of_int !nb_of_subterms ^ "\n");
  let p_list = alist_of_hash p_hash in
  append_aux ("nb_prop: " ^ string_of_int (List.length p_list) ^ "\n");
  let compare_aux (_,l) (_,l') = compare (List.length l') (List.length l) in
  let freq_propl = List.sort compare_aux p_list in
  let get_thm (_,a,cl) = (a,cl) in
    let new_freq_propl = 
    let f (_,thml) =  
      let (tm,_) = Hashtbl.find tlp_hash (fst (get_thm (List.hd thml))) in
      (tm,thml)
    in
    List.map f freq_propl
  in
  let to_string_thm (_,a,cl) = lisp_of [a ; lisp_of (List.map (name_of_cint inv_constant_hash1) cl)] in
  let to_string (abs_tm,l) = 
    let abs_string = 
      if !lisp_flag 
      then hhm_to_lisp abs_tm
      else hhm_to_string abs_tm
    in
    let nb_thm = List.length l in
    let save_thm thm = 
      Hashtbl.replace thm_h (to_string_thm thm) (string_of_int nb_thm ^ " : " ^ abs_string)
    in
    let thml_string = String.concat " " (List.map to_string_thm l) in
    List.iter save_thm l;
    string_of_int nb_thm ^ " : " ^ abs_string ^ "\n" ^ "  " ^ thml_string ^ "\n"
  in
  let freq_propl1 = 
    List.filter (fun (tm,_) -> total_of_constant tm = 1) new_freq_propl
  in
  let freq_propl2 = 
    List.filter (fun (tm,_) -> total_of_constant tm = 2) new_freq_propl 
  in
  let freq_propl_string1 = List.map to_string (first_n n freq_propl1) in
  let freq_propl_string2 = List.map to_string (first_n n freq_propl2) in
  let freq_propl_string = List.map to_string (first_n n new_freq_propl) in 
  writel (dir_out ^ "/Property_1") freq_propl_string1;
  writel (dir_out ^ "/Property_2") freq_propl_string2;
  writel (dir_out ^ "/Property") freq_propl_string;
  writel (dir_out ^ "/Theorem_first") (List.map (fun (a,b) -> (a ^ " : " ^ b)) (alist_of_hash thm_h))


let onelib_notype_stats n prover =
  let expname = multexp_dir ^ "/onelib_stats/no_type" in
  set_no_type ();
  subterm_flag := false;
  commute_flag := false;
  onelib_stats n expname prover

let onelib_type_stats n prover =
  let expname = multexp_dir ^ "/onelib_stats/type" in
  if prover = "miz" 
    then set_simple_type ()
    else set_constant_type ();
  subterm_flag := false;
  commute_flag := false;
  onelib_stats n expname prover

let onelib_typesubterm_stats n prover =
  let expname = multexp_dir ^ "/onelib_stats/typesubterm" in
  if prover = "miz" 
    then set_simple_type ()
    else set_constant_type ();
  subterm_flag := true;
  commute_flag := false;
  onelib_stats n expname prover

let onelib_subterm_stats n prover =
  let expname = multexp_dir ^ "/onelib_stats/subterm" in
  set_no_type ();
  subterm_flag := true;
  commute_flag := false;
  onelib_stats n expname prover

(*  rlwrap ./top -I ../hh1 -I ..
open Pattern;;
open Matching_multiple;;
open Multiple_experiments;;
Init.smaller_thm_flag := true;;
Init.lisp_flag := true;;
onelib_subterm_stats 300000 "chad";;


List.iter (onelib_notype_stats 10) prover_list;;
List.iter (onelib_type_stats 10) prover_list;;
List.iter (onelib_typesubterm_stats 10) prover_list;;
List.iter (onelib_subterm_stats 10) prover_list;;

*)

(*--------------------------------------------------------------------------
  Multiple library stats
  -------------------------------------------------------------------------- *)

(*--------------------------------------------------------------------------
  Slow motion
  -------------------------------------------------------------------------- *)

let simple_settings () =
  advice_glob := break_advice;
  commute_flag := false;
  subterm_flag := true;
  if (prover1 = "miz" || prover2 = "miz") 
    then set_simple_type ()
    else set_constant_type ()

let slow_motion indicel (prover1,prover2) = 
  simple_settings (prover1,prover2);
  slow_mo_flag := true;
  slow_mo_max := 100;
  slow_mo_mem := [];
  let nb_const = 100 in
  let expname = multexp_dir ^ "/multlib_stats/slow_motion/" ^ 
                 prover1 ^ "-" ^ prover2
  in
  mkdir_rec expname;
  match_provers expname (prover1,prover2);
  let ccscorel = List.hd !slow_mo_mem in
  let l = first_n nb_const (List.sort compare_score ccscorel) in
  let ccl = List.map fst l in
  let f ccscorel' =
    List.map (fun x -> List.assoc x ccscorel') ccl
  in
  let resultl = List.rev (List.map f !slow_mo_mem) in
  let i = ref (-1) in
  let resultl = List.map (fun x -> incr i; (!i,x)) resultl in 
  let resl = List.filter 
    (fun (a,b) -> List.mem a indicel || a = List.length resultl - 1) resultl
  in
  let f i = 
    let sl = stringl_of_scorel (List.assoc i resl) in
    writel (expname ^ "/graph" ^ string_of_int i) sl
  in
  List.iter f (List.map fst resl)

(*  rlwrap ./top -I ../hh1 -I ..
open Matching_multiple;;
open Pattern;;
slow_motion [1;2;4;8;16] ("coq","h4");;
slow_motion [1;2;4;8;16] ("h4","miz");;
*)

(*--------------------------------------------------------------------------
  Simple experiments
  -------------------------------------------------------------------------- *)

let init_simple_exp (prover1,prover2) = 
  let expname = multexp_dir ^ "/multlib_stats/simple_exp/" ^ 
                 prover1 ^ "-" ^ prover2
  in
  simple_settings (prover1,prover2);
  expname

let simple_exp (prover1,prover2) =
  let expname = init_simple_exp (prover1,prover2) in
  match_provers expname (prover1,prover2)








(*  rlwrap ./top -I ../hh1 -I ..
open Matching_multiple;;
open Pattern;;
open Multiple_experiments;;


List.iter simple_exp proverpairs_list;;
List.iter simple_exp [("miz","coq");("miz","coq");("miz","coq");("miz","coq");("miz","coq")];;


*)

(* Finding the theorems that make the two constant similar 

open Matching_multiple;;
open Pattern;;
open Multiple_experiments;;
simple_exp ("coq","h4");;
open Toolbox;;
let l = alist_of_hash ccscore_hash;;
let l = List.sort compare_score (List.filter is_undec_ccscore l);;
let l' = List.rev (first_n 200 l);;
let l'' = List.filter (fun (x,s) -> name_of_cc x = ("Coq_Lists_List_rev_append", "'const/list/REV'")) l';;
let cc = (206, 94) ;;
let tpl = Hashtbl.find cc_hash cc;;
let tpls = List.map (fun x -> (x, Hashtbl.find ttscore_hash x)) tpl ;;
let tplr = List.sort compare_score tpls;;  

  [("Coq_Lists_List_rev_append_rev", "'thm/list/REV_REVERSE_LEM_'");
  1.25061541361159612

   ("Coq_Lists_List_rev_alt", "'thm/list/REVERSE_REV_'")]
  1.33016564716429753


*)

(*--------------------------------------------------------------------------
  Greedy experiments
  -------------------------------------------------------------------------- *)

let first_settings (prover1,prover2) =
  advice_glob := first_advice;
  commute_flag := false;
  subterm_flag := true;
  if (prover1 = "miz" || prover2 = "miz") 
    then set_simple_type ()
    else set_constant_type ()

let init_greedy_exp (prover1,prover2) = 
  let expname = multexp_dir ^ "/multlib_stats/strategy/greedy_exp/" ^ 
                 prover1 ^ "-" ^ prover2
  in
  first_settings (prover1,prover2);
  expname

let init_greedy_tyco_exp (prover1,prover2) = 
  let expname = multexp_dir ^ "/multlib_stats/strategy/greedy_tyco_exp/" ^ 
                 prover1 ^ "-" ^ prover2
  in
  first_settings (prover1,prover2);
  expname

let greedy_exp (prover1,prover2) =
  greedy_flag := true;
  let expname = init_greedy_exp (prover1,prover2) in
  match_provers expname (prover1,prover2);
  greedy_flag := false (* back to default value *)

let greedy_tyco_exp (prover1,prover2) =
  greedy_flag := true;
  type_coherence_flag := true;
  let expname = init_greedy_tyco_exp (prover1,prover2) in
  match_provers expname (prover1,prover2);
  greedy_flag := false;
  type_coherence_flag := false

let init_first_exp (prover1,prover2) = 
  let expname = multexp_dir ^ "/multlib_stats/strategy/first_exp/" ^ 
                 prover1 ^ "-" ^ prover2
  in
  first_settings (prover1,prover2);
  expname

let first_exp (prover1,prover2) =
  let expname = init_first_exp (prover1,prover2) in
  match_provers expname (prover1,prover2)

let init_greedy_dis_tyco_exp (prover1,prover2) = 
  let expname = multexp_dir ^ "/multlib_stats/strategy/greedy_dis_tyco_exp/" ^ 
                 prover1 ^ "-" ^ prover2
  in
  first_settings (prover1,prover2);
  expname

let greedy_dis_tyco_exp (prover1,prover2) =
  greedy_flag := true;
  disambiguate_flag := true;
  type_coherence_flag := true;
  let expname = init_greedy_dis_tyco_exp (prover1,prover2) in
  match_provers expname (prover1,prover2);
  greedy_flag := false;
  disambiguate_flag := false;
  type_coherence_flag := false
  
let init_dis_tyco_exp (prover1,prover2) = 
  let expname = multexp_dir ^ "/multlib_stats/strategy/dis_tyco_exp/" ^ 
                 prover1 ^ "-" ^ prover2
  in
  first_settings (prover1,prover2);
  expname

let dis_tyco_exp (prover1,prover2) =
  greedy_flag := false;
  disambiguate_flag := true;
  type_coherence_flag := true;
  let expname = init_dis_tyco_exp (prover1,prover2) in
  match_provers expname (prover1,prover2);
  greedy_flag := false;
  disambiguate_flag := false;
  type_coherence_flag := false


(*  rlwrap ./top -I ../hh1 -I ..
open Matching_multiple;;
open Pattern;;
open Multiple_experiments;;

let testl =
[("h4","hl");("h4","isa");("hl","isa");("coq","mat");
 ("coq","h4");("isa","miz");("coq","miz")]
;;

List.iter dis_tyco_exp testl;;


List.iter greedy_dis_tyco_exp testl;;


open Matching_multiple;;
open Pattern;;
open Multiple_experiments;;
auto_max := 500;;
greedy_dis_tyco_exp ("isa","miz");;


List.iter greedy_exp proverpairs_list;;
List.iter greedy_tyco_exp proverpairs_list;;
List.iter first_exp proverpairs_list;;
*)

(* 
open Pattern;;
open Matching_multiple;;
open Multiple_experiments;;
open Toolbox;;
first_settings ("coq","h4");;
disambiguate_flag := true;;
greedy_flag := true;;
type_coherence_flag := true;
time_here (match_provers "test/disambiguation/coq-h4/dis_greed_tyco10_mult1+") ("coq","h4");;
disambiguate_flag := false;;
greedy_flag := false;;

greedy_flag := true;;
match_provers "test/disambiguation/coq-h4/greed" ("coq","h4");;
disambiguate_flag := true;;
greedy_flag := false;;
match_provers "test/disambiguation/coq-h4/dis" ("coq","h4");;
disambiguate_flag := false;;
greedy_flag := false;;
match_provers "test/disambiguation/coq-h4/none" ("coq","h4");;

open Pattern;;
open Matching_multiple;;
open Multiple_experiments;;
first_settings ("coq","h4");;
type_coherence_flag := true;
disambiguate_flag := true;;
greedy_flag := true;;
match_provers "test/disambiguation/coq-h4/dis100_greed_tyco" ("coq","h4");;


open Pattern;;
open Matching_multiple;;
open Multiple_experiments;;
first_settings ("isa","miz");;
disambiguate_flag := true;;
greedy_flag := true;;
match_provers "test/disambiguation/isa-miz/disll_greed" ("isa","miz");;


open Pattern;;
open Matching_multiple;;
open Multiple_experiments;;

disambiguate_flag := false;;
greedy_flag := true;;
match_provers "test/disambiguation/isa-miz/greed" ("isa","miz");;

open Pattern;;
open Matching_multiple;;
open Multiple_experiments;;
first_settings ("isa","miz");;
disambiguate_flag := true;;
greedy_flag := false;;
match_provers "test/disambiguation/isa-miz/disll" ("isa","miz");;

open Pattern;;
open Matching_multiple;;
open Multiple_experiments;;
first_settings ("isa","miz");;
disambiguate_flag := false;;
greedy_flag := false;;
auto_max := 200;;
match_provers "test/disambiguation/isa-miz/none" ("isa","miz");;
*)

(*--------------------------------------------------------------------------
  Option experiments
  -------------------------------------------------------------------------- *)

let option_exp (expname,type_level,subterm_bool,commute_bool) (prover1,prover2) =
  advice_glob := break_advice;
  subterm_flag := subterm_bool;
  commute_flag := commute_bool;
  begin
  match type_level with
    "none"     -> set_no_type ()
  | "simple"   -> set_simple_type ()
  | "variable" -> set_var_type ()
  | "constant" -> set_constant_type ()
  | _          -> failwith "type_level"
  end;
  match_provers expname (prover1,prover2) 
   
let all_option_exp (prover1,prover2) =
  let dir = multexp_dir ^ "/multlib_stats/option_exp/" ^
            prover1 ^ "-" ^ prover2
  in
  let optionl = 
     [
      (dir ^ "/no_type","none",false,false);
      (dir ^ "/simple_type","simple",false,false);
      (dir ^ "/const_type","constant",false,false);
      (dir ^ "/const_type_com","constant",false,true);
      (dir ^ "/const_type_subterm","constant",true,false);
      (dir ^ "/const_type_subterm_com","constant",true,true)
    ]
  in
  let optionl_miz = 
     [
      (dir ^ "/no_type","none",false,false);
      (dir ^ "/simple_type","simple",false,false);
      (dir ^ "/simple_type_com","simple",false,true);
      (dir ^ "/simple_type_subterm","simple",true,false);
      (dir ^ "/simple_type_subterm_com","simple",true,true)
     ]
  in
  if prover1 = "miz" || prover2 = "miz" 
  then List.iter (fun x -> option_exp x (prover1,prover2)) optionl_miz
  else List.iter (fun x -> option_exp x (prover1,prover2)) optionl

(*  rlwrap ./top -I ../hh1 -I ..
open Matching_multiple;;
open Pattern;;
List.iter all_option_exp proverpairs_list;;
*)

let none_exp (p1,p2) =
  let expname = 
     multexp_dir ^ "/multlib_stats/option_exp/" ^ p1 ^ "-" ^ p2 ^ "/none"
  in
  cnfcom_flag := false; 
  option_exp (expname,"none",false,false) (p1,p2);
  cnfcom_flag := true

(*
open Matching_multiple;;
open Pattern;;
List.iter none_exp proverpairs_list;;
*)  

(*--------------------------------------------------------------------------
  Transitive matches
  -------------------------------------------------------------------------- *)

(* Lists are same data sorted differently *)
let write_transitive expname (l1,l2,l3,optl) = 
  let to_string ((c1,c2),(news,olds,b)) =
    c1 ^ " || " ^ c2 ^ " || " ^ string_of_float news ^ " || " ^ 
    string_of_float olds ^ " || " ^ b
  in
  let score_of (_,(a,_,_)) = a in
  writel (expname ^ "/trans_score") (List.map to_string l1);
  writel (expname ^ "/trans_sum") (List.map to_string l2);
  writel (expname ^ "/trans_diff") (List.map to_string l3);
  writel (expname ^ "/trans_opt") (List.map to_string optl);
  let graph_score = List.map score_of (first_n 1000 l1) in  
  writel (expname ^ "/trans_score_graph") (stringl_of_scorel graph_score) 

let transitive_match prover1 prover2 prover3 =
  advice_glob := break_advice;
  subterm_flag := true;
  commute_flag := false;
  if (prover1 = "miz" || prover2 = "miz" || prover3 = "miz")
    then set_simple_type ()
    else set_constant_type ()
  ;
  let expname = multexp_dir ^ "/multlib_stats/transitive/" ^ 
                 prover1 ^ "-" ^ prover2 ^ "-" ^ prover3 in
  mkdir_rec expname;
  let best_matches n = 
    let sortedl = List.sort compare_score (alist_of_hash ccscore_hash) in  
    first_n n (List.map ccscore_to_name sortedl)
  in
  let expname12 = expname ^ "/" ^ prover1 ^ "-" ^ prover2 in
  let expname23 = expname ^ "/" ^ prover2 ^ "-" ^ prover3 in
  let expname13 = expname ^ "/" ^ prover1 ^ "-" ^ prover3 in
  match_provers expname12 (prover1,prover2);
  let l12 = best_matches 500 in
  match_provers expname23 (prover2,prover3);
  let l23 = best_matches 500 in
  match_provers expname13 (prover1,prover3);
  let l13 = best_matches 500 in
  let transpose ((a,b),c) = ((b,a),c) in
  let l21 = List.map transpose l12 in
  let l32 = List.map transpose l23 in
  write_transitive expname13 (find_transitive l12 l23 l13);
  write_transitive expname23 (find_transitive l21 l13 l23);
  write_transitive expname12 (find_transitive l13 l32 l12)

(* rlwrap ./top -I ../hh1 -I ..
open Matching_multiple;;
open Pattern;;
transitive_match "isa" "coq" "miz";;
transitive_match "isa" "h4" "miz";;
transitive_match "isa" "hl" "miz";;
transitive_match "isa" "mat" "miz";;
*)

let transitive_match_greedy prover1 prover2 prover3 =
  advice_glob := first_advice;
  greedy_flag := true;
  subterm_flag := true;
  commute_flag := false;
  if (prover1 = "miz" || prover2 = "miz" || prover3 = "miz")
    then set_simple_type ()
    else set_constant_type ()
  ;
  let expname = multexp_dir ^ "/multlib_stats/transitive/greedy/" ^ 
                 prover1 ^ "-" ^ prover2 ^ "-" ^ prover3 in
  mkdir_rec expname;
  let best_matches n = 
    let sortedl = List.rev !resultl_glob in  
    first_n n (List.map ccscore_to_name sortedl)
  in
  let expname12 = expname ^ "/" ^ prover1 ^ "-" ^ prover2 in
  let expname23 = expname ^ "/" ^ prover2 ^ "-" ^ prover3 in
  let expname13 = expname ^ "/" ^ prover1 ^ "-" ^ prover3 in
  match_provers expname12 (prover1,prover2);
  let l12 = best_matches 500 in
  match_provers expname23 (prover2,prover3);
  let l23 = best_matches 500 in
  match_provers expname13 (prover1,prover3);
  let l13 = best_matches 500 in
  let transpose ((a,b),c) = ((b,a),c) in
  let l21 = List.map transpose l12 in
  let l32 = List.map transpose l23 in
  write_transitive expname13 (find_transitive l12 l23 l13);
  write_transitive expname23 (find_transitive l21 l13 l23);
  write_transitive expname12 (find_transitive l13 l32 l12)

let transitive_match_not_greedy prover1 prover2 prover3 =
  advice_glob := first_advice;
  greedy_flag := false;
  subterm_flag := true;
  commute_flag := false;
  if (prover1 = "miz" || prover2 = "miz" || prover3 = "miz")
    then set_simple_type ()
    else set_constant_type ()
  ;
  let expname = multexp_dir ^ "/multlib_stats/transitive/not_greedy/" ^ 
                 prover1 ^ "-" ^ prover2 ^ "-" ^ prover3 in
  mkdir_rec expname;
  let best_matches n = 
    let sortedl = List.rev !resultl_glob in  
    first_n n (List.map ccscore_to_name sortedl)
  in
  let expname12 = expname ^ "/" ^ prover1 ^ "-" ^ prover2 in
  let expname23 = expname ^ "/" ^ prover2 ^ "-" ^ prover3 in
  let expname13 = expname ^ "/" ^ prover1 ^ "-" ^ prover3 in
  match_provers expname12 (prover1,prover2);
  let l12 = best_matches 500 in
  match_provers expname23 (prover2,prover3);
  let l23 = best_matches 500 in
  match_provers expname13 (prover1,prover3);
  let l13 = best_matches 500 in
  let transpose ((a,b),c) = ((b,a),c) in
  let l21 = List.map transpose l12 in
  let l32 = List.map transpose l23 in
  write_transitive expname13 (find_transitive l12 l23 l13);
  write_transitive expname23 (find_transitive l21 l13 l23);
  write_transitive expname12 (find_transitive l13 l32 l12)

(* rlwrap ./top -I ../hh1 -I ..
open Matching_multiple;;
open Pattern;;
open Multiple_experiments;;


transitive_match_not_greedy "isa" "coq" "miz";;
transitive_match_not_greedy "isa" "h4" "miz";;
transitive_match_not_greedy "isa" "hl" "miz";;
transitive_match_not_greedy "isa" "mat" "miz";;


transitive_match_greedy "isa" "coq" "miz";;
transitive_match_greedy "isa" "h4" "miz";;
transitive_match_greedy "isa" "hl" "miz";;
transitive_match_greedy "isa" "mat" "miz";;
*)

(*--------------------------------------------------------------------------
  Interactive experiments
  -------------------------------------------------------------------------- *)

let interactive_exp (p1,p2) =
  let expname = 
     multexp_dir ^ "/multlib_stats/interactive_exp/" ^ p1 ^ "-" ^ p2 ^ "/full"
  in
  advice_glob := human_advice;
  subterm_flag := true;
  commute_flag := false;
  if (p1 = "miz" || p2 = "miz") 
    then set_simple_type ()
    else set_constant_type ()
  ;
  match_provers expname (p1,p2)

(* rlwrap ./top -I ../hh1 -I ..
open Matching_multiple;;
open Pattern;;
open Multiple_experiments;;
interactive_exp ("isa","miz");;
*)

(*--------------------------------------------------------------------------
  Write dependency coeff hash
  -------------------------------------------------------------------------- *)

let write_dependency_coeff_hash expname (p1,p2) =
  simple_exp (p1,p2);
  mkdir_rec expname;
  let file = expname ^ "/" ^ p1 ^ "-" ^ p2 in
  erase_file file;
  init_dependency_coeff_hash ();
  let iter cc h = 
    let f cc' coeff = 
      let coeff_string = string_of_float coeff in
      append file ("  " ^ (pretty_cc cc') ^ " || " ^ coeff_string ^ "\n")
    in
    append file ((pretty_cc cc) ^ ": " ^ "\n");
    Hashtbl.iter f h
  in
  Hashtbl.iter iter dependency_coeff_hash

let pretty_dep_hash h =
  let new_h = Hashtbl.create (Hashtbl.length h) in
  let iter k h' = 
    let new_h' = Hashtbl.create (Hashtbl.length h') in
    let iter' k' score =
      Hashtbl.add new_h' (pretty_cc k') score
    in
    Hashtbl.iter iter' h';
    Hashtbl.add new_h (pretty_cc k) new_h'
  in
  Hashtbl.iter iter h;
  new_h
  
(*--------------------------------------------------------------------------
  Self match
  -------------------------------------------------------------------------- *)

let self_settings () =
  advice_glob := break_advice;
  commute_flag := false;
  set_constant_type ();
  self_flag := true

let self_default_settings () =
  self_flag := false

let init_self_exp prover = 
  let expname = data_dir ^ "/conjecturing/self_match/" ^ prover in
  self_settings ();
  expname

let self_exp prover =
  let expname = init_self_exp prover in
  match_provers expname (prover,prover);
  self_default_settings ()

let self_exp_dir dir_in dir_out =
  self_settings ();
  let expname = dir_out ^ "/self_match" in
  match_provers_dir expname (dir_in,dir_in);
  self_default_settings ()


(*  rlwrap ./top -I ../hh1 -I ..
#
open Pattern;;
open Matching_multiple;;
open Multiple_experiments;;
open Toolbox;;
subterm_flag := false;;
self_exp "h4";;
*)



(* rlwrap ./top -I ../hh1 -I ..
open Matching_multiple;;
open Pattern;;
open Multiple_experiments;;
open Toolbox;;

let l = ["(zero_zero nat) || (0. F_Complex) (0. Z_2) NAT 0c";
"(zero_zero nat) || op0 {}";
"(ord_less_eq nat) || <=";
"(ord_less_eq nat) || c=";
"$ nat || $ natural";
"$ nat || $true"];;
simple_exp ("isa","miz");;
init_dependency_coeff_hash ();;
let h = pretty_dep_hash dependency_coeff_hash;;
let l1 = cartesian_product l l;;
let l' = List.map (fun x -> read_dep_coeff x h) l1;;
let l'' = List.fiter (fun (_,score) -> score > 0.) l';;

write_dependency_coeff_hash (multexp_dir ^ "/multlib_stats/dependency_coefficient/") ("isa","miz");;
*)






