(*-------------------------------------------------------------------------- *)
(* Experiments with CakeML.                                                  *)
(*-------------------------------------------------------------------------- *)

(* 
Version of HOL4
  git log
  commit 7cbca4ef8c657ae45008d4f9078f29d3da03f86a
  Author: Michael Norrish <Michael.Norrish@nicta.com.au>
  Date:   Fri Apr 1 09:30:22 2016 +1100

Version of CakeML 
  git log
  commit b12ed72e5ad783d3e206a09e10763151a4f3be48
  Author: Magnus Myreen <magnus.myreen@cl.cam.ac.uk>
  Date:   Fri Apr 1 08:49:47 2016 +0300




*)

(* Building CakeML 
Need to build HOL4 and examples in HOL/examples/fun-op-sem.
Change holmakefile in cakeml/semantics
$(HOLDIR)/examples/fun-op-sem/lprefix_lub/lprefix_lubTheory

git clean -xdf
grep -v '^#' developers/build-sequence > developers/my-build-sequence 
(* remove the tests in my build sequence manually *)

DIRL=`cat developers/my-build-sequence`
echo $DIRL
for d in $DIRL
do
  (cd $d && Holmake cleanAll && Holmake && cd ~/cakeml)
done
*)

(* Finding all theories
THYL=$(find . -name "*Theory.sml") 
THYL1=$(for f in $THYL 
do
  (g="${f%.*}"; echo $g)
done)

THYL3=$(for f in $THYL1
do
  (g="${f%Theory}"; echo $g)
done)
echo $THYL3

THYL2=$(for f in $THYL3
do
  (g=$(basename $f); echo $g)
done)
echo $THYL2
*)

(* Exporting all theories: rlwrap hol *)
(* This list should be produced again if the theories have changed *)

val load_thyl = 
String.tokens Char.isSpace
("./lib ./lem_lib_stub/lem_show_extra ./lem_lib_stub/lem_list_extra ./lem_lib_stub/lem_pervasives ./lem_lib_stub/lem_string_extra ./lem_lib_stub/lem_pervasives_extra ./lem_lib_stub/lem_string ./lem_lib_stub/lem_map_extra ./misc ./mlstring ./compiler/inference/unify ./compiler/inference/infer_t ./compiler/inference/infer ./compiler/inference/proofs/inferProps ./compiler/inference/proofs/type_eDeterm ./compiler/inference/proofs/inferComplete ./compiler/inference/proofs/infer_eComplete ./compiler/inference/proofs/infer_eSound ./compiler/inference/proofs/inferSound ./compiler/backend/wordLang ./compiler/backend/closLang ./compiler/backend/clos_call ./compiler/backend/bvp_to_word ./compiler/backend/bvp_live ./compiler/backend/decLang ./compiler/backend/clos_annotate ./compiler/backend/word_alloc ./compiler/backend/stack_remove ./compiler/backend/reg_alloc/parmove ./compiler/backend/reg_alloc/reg_alloc ./compiler/backend/reg_alloc/proofs/reg_allocProof ./compiler/backend/backend ./compiler/backend/dec_to_exh ./compiler/backend/bvl_inline ./compiler/backend/word_to_word ./compiler/backend/exh_to_pat ./compiler/backend/bvl_const ./compiler/backend/clos_to_bvl ./compiler/backend/db_vars ./compiler/backend/word_to_stack ./compiler/backend/stackLang ./compiler/backend/clos_free ./compiler/backend/clos_remove ./compiler/backend/clos_known ./compiler/backend/lab_to_target ./compiler/backend/modLang ./compiler/backend/bvl_to_bvi ./compiler/backend/semantics/bviProps ./compiler/backend/semantics/exhProps ./compiler/backend/semantics/clos_relationProps ./compiler/backend/semantics/modProps ./compiler/backend/semantics/labProps ./compiler/backend/semantics/clos_relation ./compiler/backend/semantics/wordSem " ^ 
"./compiler/backend/semantics/closSem ./compiler/backend/semantics/decSem ./compiler/backend/semantics/patProps ./compiler/backend/semantics/stackProps ./compiler/backend/semantics/exhSem ./compiler/backend/semantics/bvlProps ./compiler/backend/semantics/bvpProps ./compiler/backend/semantics/bviSem ./compiler/backend/semantics/bvlSem ./compiler/backend/semantics/modSem ./compiler/backend/semantics/wordProps ./compiler/backend/semantics/conSem ./compiler/backend/semantics/decProps ./compiler/backend/semantics/patSem ./compiler/backend/semantics/stackSem ./compiler/backend/semantics/closProps ./compiler/backend/semantics/conProps ./compiler/backend/semantics/labSem ./compiler/backend/semantics/bvpSem ./compiler/backend/patLang ./compiler/backend/source_to_mod ./compiler/backend/clos_mti ./compiler/backend/bvl_jump ./compiler/backend/lab_filter ./compiler/backend/bvl ./compiler/backend/mod_to_con ./compiler/backend/stack_to_lab ./compiler/backend/bvp ./compiler/backend/stack_names ./compiler/backend/gc/copying_gc ./compiler/backend/word_remove ./compiler/backend/pat_to_clos ./compiler/backend/bvp_simp ./compiler/backend/bvl_handle ./compiler/backend/stack_alloc ./compiler/backend/con_to_dec ./compiler/backend/word_inst ./compiler/backend/labLang ./compiler/backend/clos_number ./compiler/backend/bvi_to_bvp ./compiler/backend/conLang ./compiler/backend/proofs/bvp_spaceProof ./compiler/backend/proofs/clos_knownProof ./compiler/backend/proofs/clos_mtiProof ./compiler/backend/proofs/clos_annotateProof ./compiler/backend/proofs/bvl_handleProof ./compiler/backend/proofs/clos_callProof ./compiler/backend/proofs/bvl_to_bviProof " ^ 
"./compiler/backend/proofs/bvl_jumpProof ./compiler/backend/proofs/lab_filterProof ./compiler/backend/proofs/bvl_constProof ./compiler/backend/proofs/stack_namesProof ./compiler/backend/proofs/word_instProof ./compiler/backend/proofs/bvp_to_wordProps ./compiler/backend/proofs/clos_freeProof ./compiler/backend/proofs/bvi_to_bvpProof ./compiler/backend/proofs/exh_to_patProof ./compiler/backend/proofs/pat_to_closProof ./compiler/backend/proofs/bvp_simpProof ./compiler/backend/proofs/word_removeProof ./compiler/backend/proofs/source_to_modProof ./compiler/backend/proofs/mod_to_conProof ./compiler/backend/proofs/stack_removeProof ./compiler/backend/proofs/bvp_liveProof ./compiler/backend/proofs/clos_removeProof ./compiler/backend/proofs/dec_to_exhProof ./compiler/backend/proofs/bvl_inlineProof ./compiler/backend/proofs/clos_numberProof ./compiler/backend/proofs/con_to_decProof ./compiler/backend/bvp_space ./compiler/backend/bvi ./compiler/backend/exhLang ./compiler/compiler ./compiler/targets/x64/x64_target ./compiler/targets/x64/x64_eval_encode ./compiler/targets/x64/proof/x64_target_correct ./compiler/targets/asm/asmSem ./compiler/targets/asm/asmProps ./compiler/targets/asm/asm ./compiler/targets/arm6/arm6_target ./compiler/targets/arm6/proof/arm6_target_correct ./compiler/targets/arm6/arm6_eval_encode ./compiler/targets/targetSem ./compiler/targets/mips/proof/mips_target_correct ./compiler/targets/mips/mips_target ./compiler/targets/riscv/riscv_target ./compiler/targets/riscv/proof/riscv_target_correct ./compiler/targets/arm8/proof/arm8_target_correct ./compiler/targets/arm8/arm8_target ./compiler/targets/targetProps ./compiler/parsing/cmlPEG ./compiler/parsing/testing/cmlTests ./compiler/parsing/testing/lexerTests ./compiler/parsing/lexer_impl ./compiler/parsing/cmlParse ./compiler/parsing/proofs/pegSound ./compiler/parsing/proofs/pegComplete ./compiler/parsing/fromSexp ./semantics/gram " ^ 
"./semantics/funBigStep ./semantics/semanticPrimitives ./semantics/initialProgram ./semantics/print ./semantics/tokenUtils ./semantics/lexer_fun ./semantics/ast ./semantics/termination ./semantics/bigStep ./semantics/cmlPtreeConversion ./semantics/ffi/ffi ./semantics/ffi/simpleIO ./semantics/typeSystem ./semantics/semantics ./semantics/proofs/typeSysProps ./semantics/proofs/semanticsProps ./semantics/proofs/typeSoundInvariants ./semantics/proofs/initSemEnv ./semantics/proofs/bigSmallEquiv ./semantics/proofs/interp ./semantics/proofs/determ ./semantics/proofs/typeSound ./semantics/proofs/funBigStepProps ./semantics/proofs/gramProps ./semantics/proofs/untypedSafety ./semantics/proofs/bigClock ./semantics/proofs/astProps ./semantics/proofs/bigSmallInvariants ./semantics/proofs/weakening ./semantics/proofs/evalProps ./semantics/proofs/cmlPtreeConversionProps ./semantics/proofs/funBigStepEquiv ./semantics/tokens ./semantics/smallStep ./translator/other-examples/auxiliary/slr_parser_gen ./translator/other-examples/auxiliary/copying_gc ./translator/other-examples/auxiliary/regexpMatch ./translator/other-examples/auxiliary/ninetyOne ./translator/other-examples/example_qsort ./translator/other-examples/example_primality_test ./translator/other-examples/example_91 ./translator/ml_optimise ./translator/okasaki-examples/PairingHeap ./translator/okasaki-examples/okasaki_misc ./translator/okasaki-examples/BinomialHeap ./translator/okasaki-examples/LeftistHeap ./translator/okasaki-examples/UnbalancedSet ./translator/okasaki-examples/SplayHeap ./translator/okasaki-examples/RealTimeQueue ./translator/okasaki-examples/benchmark ./translator/okasaki-examples/LazyPairingHeap ./translator/okasaki-examples/BottomUpMergeSort ./translator/okasaki-examples/BankersQueue ./translator/okasaki-examples/PhysicistsQueue " ^ 
"./translator/okasaki-examples/RedBlackSet ./translator/okasaki-examples/BatchedQueue ./translator/okasaki-examples/HoodMelvilleQueue ./translator/okasaki-examples/ImplicitQueue ./translator/okasaki-examples/BinaryRandomAccessLists ./translator/mini_prelude ./translator/ml_pmatch_demo ./translator/ml_translator_demo ./translator/ml_module_demo ./translator/std_prelude ./translator/ml_translator ./translator/ml_pmatch ./translator/ml_translator_test ./candle/set-theory/setSpec ./candle/set-theory/setModel ./candle/set-theory/jrhSet ./candle/standard/opentheory/reader ./candle/standard/ml_kernel/ml_hol_kernel ./candle/standard/ml_kernel/ml_monad ./candle/standard/ml_kernel/ml_hol_init ./candle/standard/ml_kernel/ppKernel ./candle/standard/monadic/holKernel ./candle/standard/monadic/holKernelProof ./candle/standard/monadic/holKernelPmatch ./candle/standard/syntax/holSyntaxExtra ./candle/standard/syntax/holBoolSyntax ./candle/standard/syntax/holSyntax ./candle/standard/syntax/holAxiomsSyntax ./candle/standard/syntax/holConservative ./candle/standard/semantics/holBool ./candle/standard/semantics/holSemantics ./candle/standard/semantics/holAxioms ./candle/standard/semantics/holConsistency ./candle/standard/semantics/holSemanticsExtra ./candle/standard/semantics/holExtension ./candle/standard/semantics/holSoundness ./candle/syntax-lib/holSyntaxLib");


val thyl0 = String.tokens Char.isSpace
("lib lem_show_extra lem_list_extra lem_pervasives lem_string_extra lem_pervasives_extra lem_string lem_map_extra misc mlstring unify infer_t infer inferProps type_eDeterm inferComplete infer_eComplete infer_eSound inferSound wordLang closLang clos_call bvp_to_word bvp_live decLang clos_annotate word_alloc stack_remove parmove reg_alloc reg_allocProof backend dec_to_exh bvl_inline word_to_word exh_to_pat bvl_const clos_to_bvl db_vars word_to_stack stackLang clos_free clos_remove lab_to_target modLang bvl_to_bvi bviProps exhProps clos_relationProps modProps labProps clos_relation wordSem closSem decSem patProps stackProps exhSem bvlProps bvpProps bviSem bvlSem modSem wordProps conSem decProps patSem stackSem closProps conProps labSem bvpSem patLang source_to_mod clos_mti bvl_jump lab_filter bvl mod_to_con stack_to_lab bvp stack_names copying_gc word_remove pat_to_clos bvp_simp bvl_handle stack_alloc con_to_dec word_inst labLang clos_number bvi_to_bvp conLang bvp_spaceProof stack_allocProof clos_mtiProof clos_annotateProof bvl_handleProof clos_callProof bvl_to_bviProof backendProof bvl_jumpProof lab_filterProof lab_to_targetProof bvl_constProof stack_namesProof word_instProof bvp_to_wordProps clos_freeProof bvi_to_bvpProof exh_to_patProof pat_to_closProof bvp_simpProof " ^ "word_allocProof word_removeProof word_to_stackProof stack_to_labProof source_to_modProof mod_to_conProof stack_removeProof bvp_liveProof clos_to_bvlProof clos_removeProof dec_to_exhProof word_to_wordProof bvl_inlineProof clos_numberProof bvp_to_wordProof con_to_decProof bvp_space bvi exhLang compiler compilerProof x64_target x64_eval_encode x64_target_correct asmSem asmProps asm arm6_target arm6_target_correct arm6_eval_encode targetSem mips_target_correct mips_target riscv_target riscv_target_correct arm8_target_correct arm8_target targetProps cmlPEG lexer_impl cmlParse pegSound pegComplete fromSexp gram funBigStep semanticPrimitives initialProgram print tokenUtils lexer_fun ast termination bigStep cmlPtreeConversion ffi simpleIO typeSystem semantics typeSysProps semanticsProps typeSoundInvariants initSemEnv bigSmallEquiv interp determ typeSound funBigStepProps gramProps untypedSafety bigClock astProps bigSmallInvariants weakening evalProps cmlPtreeConversionProps funBigStepEquiv tokens smallStep ml_optimise mini_prelude ml_pmatch_demo ml_translator_demo ml_module_demo std_prelude ml_translator ml_pmatch ml_translator_test setSpec setModel jrhSet reader ml_hol_kernel ml_monad ml_hol_init ppKernel holKernel holKernelProof holKernelPmatch holSyntaxExtra holBoolSyntax holSyntax holAxiomsSyntax holConservative holBool holSemantics holAxioms holConsistency holSemanticsExtra holExtension holSoundness holSyntaxLib");

val thyl = String.tokens Char.isSpace
"lib lem_show_extra lem_list_extra lem_pervasives lem_string_extra lem_pervasives_extra lem_string lem_map_extra misc mlstring unify infer_t infer inferProps type_eDeterm inferComplete infer_eComplete infer_eSound inferSound wordLang closLang clos_call bvp_to_word bvp_live decLang clos_annotate word_alloc stack_remove parmove reg_alloc reg_allocProof backend dec_to_exh bvl_inline word_to_word exh_to_pat bvl_const clos_to_bvl db_vars word_to_stack stackLang clos_free clos_remove clos_known lab_to_target modLang bvl_to_bvi bviProps exhProps clos_relationProps modProps labProps clos_relation wordSem closSem decSem patProps stackProps exhSem bvlProps bvpProps bviSem bvlSem modSem wordProps conSem decProps patSem stackSem closProps conProps labSem bvpSem patLang source_to_mod clos_mti bvl_jump lab_filter bvl mod_to_con stack_to_lab bvp stack_names copying_gc word_remove pat_to_clos bvp_simp bvl_handle stack_alloc con_to_dec word_inst labLang clos_number bvi_to_bvp conLang bvp_spaceProof clos_knownProof clos_mtiProof clos_annotateProof bvl_handleProof clos_callProof bvl_to_bviProof bvl_jumpProof lab_filterProof bvl_constProof stack_namesProof word_instProof bvp_to_wordProps clos_freeProof bvi_to_bvpProof exh_to_patProof pat_to_closProof bvp_simpProof word_removeProof source_to_modProof mod_to_conProof stack_removeProof bvp_liveProof clos_removeProof dec_to_exhProof bvl_inlineProof clos_numberProof con_to_decProof bvp_space bvi exhLang compiler x64_target x64_eval_encode x64_target_correct asmSem asmProps asm arm6_target arm6_target_correct arm6_eval_encode targetSem mips_target_correct mips_target riscv_target riscv_target_correct arm8_target_correct arm8_target targetProps cmlPEG cmlTests lexerTests lexer_impl cmlParse pegSound pegComplete fromSexp gram funBigStep semanticPrimitives initialProgram print tokenUtils lexer_fun ast termination bigStep cmlPtreeConversion ffi simpleIO typeSystem semantics typeSysProps semanticsProps typeSoundInvariants initSemEnv bigSmallEquiv interp determ typeSound funBigStepProps gramProps untypedSafety bigClock astProps bigSmallInvariants weakening evalProps cmlPtreeConversionProps funBigStepEquiv tokens smallStep slr_parser_gen copying_gc regexpMatch ninetyOne example_qsort example_91 ml_optimise PairingHeap okasaki_misc BinomialHeap LeftistHeap UnbalancedSet SplayHeap RealTimeQueue benchmark LazyPairingHeap BottomUpMergeSort BankersQueue PhysicistsQueue RedBlackSet BatchedQueue HoodMelvilleQueue ImplicitQueue BinaryRandomAccessLists mini_prelude ml_pmatch_demo ml_translator_demo ml_module_demo std_prelude ml_translator ml_pmatch ml_translator_test setSpec setModel jrhSet reader ml_hol_kernel ml_monad ml_hol_init ppKernel holKernel holKernelProof holKernelPmatch holSyntaxExtra holBoolSyntax holSyntax holAxiomsSyntax holConservative holBool holSemantics holAxioms holConsistency holSemanticsExtra holExtension holSoundness holSyntaxLib";

List.length thyl0;;
List.length thyl;;

(* theories to be loaded *)
val load_thyl2 = map (fn x => x ^ "Theory") load_thyl;

fun load_with_error thyl errorl = case thyl of
    []       => errorl
  | thy :: m => let val mem = ref [] in 
                  load thy handle _ => mem := [thy];
                  load_with_error m ((!mem) @ errorl)
                end;
val l = load_with_error load_thyl2 [];

(* error primality_test_theory *)

(* writing *)
val all_thyl = mk_set ((List.concat (map ancestry thyl)) @ thyl);
val folder = "../hh2-data/palibs/cakeml_2016_06_10"; 
load "hhWriter";
open hhWriter;
write_hh_thyl folder all_thyl;
write_thydep (folder ^ "/info/theory_dep") all_thyl;
