load "hhWriter";
open hhWriter;

(* To be run in HOL directory otherwise change export directories *)

(* main functions *)
fun export dir thyl =
  let 
    val load_thyl = map (fn x => x ^ "Theory") thyl 
    val _         = app load load_thyl
    val completed_thyl = mk_set ((List.concat (map ancestry thyl)) @ thyl)
  in
    write_hh_thyl dir completed_thyl;
    write_thydep (dir ^ "/info/theory_dep") completed_thyl
  end

(*
THYL=$(find . -name "*Theory.sml") 
THYL1=$(for f in $THYL 
do
  (g="${f%.*}"; echo $g)
done)

THYL3=$(for f in $THYL1
do
  (g="${f%Theory}"; echo $g)
done)
echo $THYL3

THYL2=$(for f in $THYL3
do
  (g=$(basename $f); echo $g)
done)
echo $THYL2
*)

(* standard library 
cd HOL
*)

(* should use full path instead doesn't work like that *)
val thyl = String.tokens Char.isSpace 
("quantHeuristics fixedPoint gcdset set_relation pred_set Decode EncodeVar Coder Encode operator numposrep listRange indexedLists list rich_list patricia sptree patricia_casts integer DeepSyntax integerRing int_bitwise int_arith integer_word Omega complex ieee float words sum_num fcp alignment bitstring blast option res_quan path dirGraph state_transformer errorStateMonad bool marker relation one ASCIInumbers string string_num normalForms update rat ratRing frac intExtension container bag primeFactor defCNF sat ConseqConv hreal topology intreal powser seq nets integral poly lim real real_sigma transc hrat realax sum mergesort sorting HolSmt Omega_Automata Past_Temporal_Logic Temporal_Logic logroot numpair numeral_bit divides bit gcd prim_rec arithmetic basicSize numeral num while util_prob lebesgue extreal probability measure lbtree llist patternMatches inftree ind_type quotient_pred_set quotient_option quotient_list quotient_sum quotient quotient_pair machine_ieee binary_ieee basis_emit pair poset numRing quote semi_ring canonical prelim ringNorm ring tc comparison wot fmapal intto toto enumeral combin alist finite_map fmaptree");

(* error IL bft dft *)

export ("/home/gauthier/hh2-data/palibs/hol4-kananaskis10-2016_08_05") thyl;

(* core *)
val thyl = ancestry (current_theory ());;
export (palibs_dir ^ "/core_library_ns") thyl;

(* experiments *)
val exp_thyl = String.tokens Char.isSpace 
("num realax real realax pair transc prim_rec list poly lim integral" ^
"seq topology arithmetic pred_set");
export (palibs_dir ^ "/exp_library") thyl;

(* ltb *)
val thyl = String.tokens Char.isSpace ("lebesgue measure probability complex integral ratRing");
export ("../hh2-data/palibs/h4-kananaskis10/ltb_2016_06_10") thyl;
