(* First iteration:
     For each statement save its alpha-normalized and all versions in h_thms
     associated with the first file it appeared in *)
module Tltm = Map.Make(struct type t = (term list * term) let compare = compare end);;
module Tmm = Map.Make(struct type t = term let compare = compare end);;
module Sm = Map.Make(struct type t = string let compare = compare end);;

(* Cause of bugs
let rec rename_bnds map min tm prfun =
  try let l, r = dest_abs tm in
    let _, ty = dest_var l in
    let nl = mk_var (prfun min ty, ty) in
    mk_abs (nl, rename_bnds (Tmm.add l nl (Tmm.remove l map)) (min + 1) r prfun)
  with _ -> try let l, r = dest_comb tm in
    mk_comb (rename_bnds map min l prfun, rename_bnds map min r prfun)
  with _ -> try Tmm.find tm map with _ -> tm
;;

let rename_all tm prfun =
  let fs = frees tm in
  let tys = map (snd o dest_var) fs in
  let s = Array.to_list (Array.init (List.length fs) (fun i -> prfun i (List.nth tys i))) in
  let nfs = map mk_var (zip s tys) in
  rename_bnds Tmm.empty (List.length fs) (vsubst (zip nfs fs) tm) prfun
;;

let prfun min ty = "A" ^ string_of_int min;;

let retyvar tm =
  let tvs = type_vars_in_term tm in
  let tyvno = ref (Char.code 'A' - 1) in
  let ins = List.map (fun x -> incr tyvno; (mk_vartype (String.make 1 (Char.chr !tyvno)),x)) tvs in
  inst ins tm
;;
*)

let normalize_concl th = (concl o GEN_ALL o DISCH_ALL) th;;

let noholname s =
  let len = String.length !hol_dir and slen = String.length s in
  if slen > len then
    let sub = String.sub s 0 len in
    if sub = !hol_dir then String.sub s (len + 1) (slen - len - 1)
    else s
  else s
;;

let theorems = ref([]:(string*thm)list);;
loads "update_database.ml";; 

(* Checks which are the new theorems *)
let historian_thms = ref Tltm.empty;;
(* Checks which are same theorems *)
let historian_norm_thms = ref Tmm.empty;;


(* Number the theorems in the order they are proved. 
   This doesn't have to be consistent over various build *)
(*
let count =
  let no = ref (-1) in
  fun name -> (incr no; name ^ "_" ^ string_of_int (!no))
;;
*)



let chk_store_thm ((name : string), th) =
  let dt = dest_thm th in
  if not (Tltm.mem dt !historian_thms) then begin
    let concl = normalize_concl th in
    try
      let (file, name) = Tmm.find concl !historian_norm_thms in
      historian_thms := Tltm.add dt (file, name) !historian_thms
    with Not_found ->
      let file = if !file_stack <> [] then noholname (hd !file_stack) else "" in
      historian_thms := Tltm.add dt (file, name) !historian_thms;
      historian_norm_thms := Tmm.add concl (file, name) !historian_norm_thms;
  end;;

let chk_store_thm_invent invent th =
  let dt = dest_thm th in
  if not (Tltm.mem dt !historian_thms) then begin
    let concl = normalize_concl th in
    try
      let (file, name) = Tmm.find concl !historian_norm_thms in
      historian_thms := Tltm.add dt (file, name) !historian_thms
    with Not_found ->
      let file = if !file_stack <> [] then noholname (hd !file_stack) else "" in
      let name = invent th in
      historian_thms := Tltm.add dt (file, name) !historian_thms;
      historian_norm_thms := Tmm.add concl (file, name) !historian_norm_thms;
  end;;

let name2pairsconjs acc (name, th) =
  if is_conj (concl th) then
    let fold_fun (no, acc) th = (no + 1, (name ^ "_" ^ (string_of_int no), th) :: acc) in
    (name, th) :: snd (List.fold_left fold_fun (0, acc) (CONJUNCTS th))
  else (name, th) :: acc;;

let get_def_name th = "hidden_DEF_" ^ ((fst o dest_const o fst o dest_eq o concl) th);;
let get_tydef1_name th = "hidden_TYDEF1_" ^ ((fst o dest_type o type_of o snd o dest_eq o concl) th);;
let get_tydef2_name th = "hidden_TYDEF2_" ^
  ((fst o dest_type o type_of o rand o fst o dest_eq o snd o dest_eq o concl) th);;
let get_axiom_name =
  let no = ref (-1) in
  fun th -> (incr no; "hidden_AXIOM_" ^ string_of_int (!no))
;;

let historian_update () =
  update_database ();
  let (con, nocon) = List.partition (fun (_, th) -> is_conj (concl th)) !theorems in
  List.iter chk_store_thm (List.map (fun (n,th) -> (n ^ "_",th)) nocon);
  List.iter chk_store_thm (List.fold_left name2pairsconjs [] con);
  List.iter (chk_store_thm_invent get_axiom_name) (axioms ());
  List.iter (chk_store_thm_invent get_def_name) (definitions ());
  List.iter (chk_store_thm_invent get_tydef1_name) (map fst (type_definitions ()));
  List.iter (chk_store_thm_invent get_tydef2_name) (map snd (type_definitions ()));
;;

let new_start_hook s =
  Printf.printf "!!!<FILE %s>\n@!" s;
  historian_update ()
;;

let new_end_hook s =
  Printf.printf "!!!</FILE> (%s)\n@!" s;
  historian_update ()
;;

use_file_start_hook := new_start_hook;;
use_file_end_hook := new_end_hook;;

let hist_get () =
  let hist = ref Sm.empty in
  let iter_fun tlt (file,name) =
    try
      let ths = Sm.find file !hist in
      hist := Sm.add file ((tlt, name) :: ths) !hist
    with Not_found -> hist := Sm.add file [(tlt, name)] !hist in
  Tltm.iter iter_fun !historian_thms;
  let ord = List.map noholname !file_order in
  List.fold_left (fun sf file -> try (file, Sm.find file !hist) :: sf with Not_found -> sf) [] ord
;;


#load "str.cma";;
#load "unix.cma";;
let rxpslash = Str.regexp "/";;
let mkdir_p fname =
  let path = rev (Str.split rxpslash fname) in
  let mkfolder n sf =
    (try Unix.mkdir sf 0o755 with _ -> ());
    sf ^ "/" ^ n
  in
  ignore (end_itlist mkfolder path)
;;

let write_order l =
	let oc = open_out "file_order" in
    output_string oc (String.concat "\n" l);
    close_out oc
;;
let hist_save () =
  let ord = rev (List.map noholname !file_order) in
  let file_save (ofile, ths) =
    let file = if ofile = "../export/hollight/historian1.ml" then "bool.ml" else ofile in
    let fname = "data/" ^ file ^ ".statements" in
    mkdir_p fname;
    try
      let ic = open_in fname in
      let (oldno, oldl) = input_value ic in
      close_in ic;
      let newno, newl = min oldno (index ofile ord), union oldl (setify ths) in
      if newno < oldno or length newl > length oldl then begin
        let oc = open_out fname in
        output_value oc (newno, newl);
        close_out oc
      end
    with Sys_error _ ->
      let oc = open_out fname in
      output_value oc (index ofile ord, setify ths);
      close_out oc
  in
	write_order (List.map noholname !file_order);
	List.iter file_save (hist_get ())
;;

(* Causes bugs 
let retyvar_funny tm =
  let tvs = type_vars_in_term tm in
  let (tvsgood, tvsbad) = List.partition (fun ty -> try (dest_vartype ty).[0] <> '?' with _ -> false) tvs in
  let tyvno = ref (-1) in
  let rec nexttv () =
    incr tyvno;
    let ret = mk_vartype ("?" ^ string_of_int !tyvno) in
    if List.mem ret tvsgood then nexttv () else ret
  in
  let ins = List.map (fun x -> (nexttv (),x)) tvsbad in
  inst ins tm
;;

let parse_term s =
  let tm = parse_term s in
  if type_of tm = bool_ty then retyvar_funny tm else tm
;;
*)
