let noholname s =
  let len = String.length !hol_dir and slen = String.length s in
  if slen > len then
    let sub = String.sub s 0 len in
    if sub = !hol_dir then String.sub s (len + 1) (slen - len - 1)
    else s
  else s
;;

(* Escaping "/" now because a theorem may contain a "/" *)
let escape_slash s =
  let s1 = Str.global_replace (Str.regexp "|") "|ve|" s in
  let s2 = Str.global_replace (Str.regexp "/") "|sl|" s1 in
  let s3 = Str.global_replace (Str.regexp "\"") "|qu|" s2 in
  s3

let add_thm_names s =
  let ofile = noholname s in
  let fname = "data/" ^ ofile ^ ".statements" in
  try
    let ic = open_in fname in
    let (no, l) = input_value ic in
    (* escaping now because a theorem may contain a "/" *)
    add_thm_names (map (fun (a,b) -> (a, ofile ^ "/" ^ escape_slash b)) l);
  with Sys_error _ -> ()
;;


let new_start_hook s =
  Printf.printf "!!!<FILE %s>\n@!" s;
  add_thm_names s
;;

let new_end_hook s back =
  Printf.printf "!!!</FILE> (%s)\n@!" s;
  let ofile = noholname s in
  let fname = "data/" ^ ofile ^ ".statements" in
  (try
    let ic = open_in fname in
    let (no, l) = input_value ic in
    (* escaping now because a theorem may contain a "/" *)
    let l = map (fun (a,b) -> (a, ofile ^ "/" ^ escape_slash b)) l in
    Printf.printf "%i %i\n@!" no (length !file_order);
    if no < length !file_order - 1 or ofile = "bool.ml" then begin
      let ofilesl = ofile ^ "/" and ofilesll = String.length ofile + 1 in
      let strok s = String.length s > ofilesll && String.sub s 0 ofilesll = ofilesl in
      let heok = function
          Histhm (a, _) -> strok a
        | Hisdef (_, a) -> strok a
        | Histyd (_, _, _, a, b, _) -> strok a && strok b
        | Hisax a -> strok a
        | _ -> true
      in
      let (ok, nok) = List.partition heok !fusion_hist in
      do_write om_syntax l ofile (rev ok);
      do_write thf_syntax l ofile (rev ok);
      fusion_hist := nok
    end
  with Sys_error _ -> ()
  );
  add_thm_names back
;;

use_file_start_hook := new_start_hook;;
use_file_end_hook := new_end_hook;;

(* Causes bugs
let retyvar_funny tm =
  let tvs = type_vars_in_term tm in
  let (tvsgood, tvsbad) = List.parErrortition (fun ty -> try (dest_vartype ty).[0] <> '?' with _ -> false) tvs in
  let tyvno = ref (-1) in
  let rec nexttv () =
    incr tyvno;
    let ret = mk_vartype ("?" ^ string_of_int !tyvno) in
    if List.mem ret tvsgood then nexttv () else ret
  in
  let ins = List.map (fun x -> (nexttv (),x)) tvsbad in
  inst ins tm
;;

let parse_term s =
  let tm = parse_term s in
  if type_of tm = bool_ty then retyvar_funny tm else tm
;;
*)
