# Remove previously exported files
rm -f data/*.ml.statements 

# Move to the hollight directory
cd ../../../hollight

# Do not remove: is used internally by flyspeck
export HOLLIGHT_DIR=$(pwd)
export FLYSPECK_DIR=$HOLLIGHT_DIR/flyspeck/text_formalization

WRITE_DIR=../export/hollight
HOL1=$WRITE_DIR/hol1.ml
HOL2=$WRITE_DIR/hol2.ml
FUSION=fusion.ml
FUSION1=$WRITE_DIR/fusion1.ml
FUSION2=$WRITE_DIR/fusion2.ml
DIR1=flyspeck/jHOLLight
DIR2=flyspeck/text_formalization
DIR3=flyspeck/formal_ineqs
BUILD=flyspeck/text_formalization/strictbuild.hl
MODIFIED_BUILD=$WRITE_DIR/scripts/strictbuild.hl

# Patch: make flyspeck export correctly
cp $MODIFIED_BUILD $BUILD

# First pass
rm $FUSION
ln -s $FUSION1 $FUSION
(echo "#use \"$HOL1\";;" ;
 echo "load_path := \"$DIR1\" :: "'!'"load_path;;" ;
 echo "load_path := \"$DIR2\" :: "'!'"load_path;;" ;
 echo "load_path := \"$DIR3\" :: "'!'"load_path;;" ;
 echo "loadt \"$BUILD\";;" ;
 echo 'build_silent ();;' ; 
 echo 'hist_save();;') | ocaml 2> $BUILD.err1 1> $BUILD.out1

if grep "Error in included file " $BUILD.out1
then echo "Error (first pass) in: " $BUILD
else

# Second pass
rm $FUSION
ln -s $FUSION2 $FUSION
(echo "#use \"$HOL2\";;" ;
 echo "load_path := \"$DIR1\" :: "'!'"load_path;;" ;
 echo "load_path := \"$DIR2\" :: "'!'"load_path;;" ;
 echo "load_path := \"$DIR3\" :: "'!'"load_path;;" ;
 echo "loadt \"$BUILD\";;" ;
 echo 'build_silent ();;' ) | ocaml 2> $BUILD.err2 1> $BUILD.out2
fi

if grep "Error in included file " $BUILD.out2
then echo "Error (second pass) in: " $BUILD
fi
