#!/bin/bash
set -e

# To use this script: download hollight in hh2/hollight
# This script needs an argument which is the path of the file you want to load 
# assuming the hollight directory is the current directory

# Move to the hollight directory
cd ../../../hollight
export HOLLIGHT_DIR=$(pwd)

WRITE_DIR=../export/hollight
HOL1=$WRITE_DIR/hol1.ml
HOL2=$WRITE_DIR/hol2.ml
FUSION=fusion.ml
FUSION1=$WRITE_DIR/fusion1.ml
FUSION2=$WRITE_DIR/fusion2.ml

# Remove previously exported files (needed if the export directory is updated)
rm -f data/*.ml.statements

# First pass 
rm $FUSION
ln -s $FUSION1 $FUSION
(echo "#use \"$HOL1\";;" ; echo 'hist_save();;') | ocaml 2> kernel.err1 1> kernel.out1

# Second pass
rm $FUSION
ln -s $FUSION2 $FUSION
echo "#use \"$HOL2\";;" | ocaml 2> kernel.err2 1> kernel.out2
