theory zf imports AC ArithSimp Arith Bin Bool Cardinal_AC CardinalArith Cardinal Datatype_ZF Epsilon equalities EquivClass Finite Fixedpt func Inductive_ZF InfDatatype 
  IntDiv_ZF Int_ZF List_ZF Main Main_ZFC Main_ZF Nat_ZF OrderArith Order OrderType Ordinal OrdQuant pair Perm QPair QUniv Sum Trancl Univ upair WF ZF Zorn begin
(*axiomatization where
bla: "{x : A . (P(x) | Q(x)) } = {x : A . (Q(x) | P(x)) }"*)

ML {*
  val escape_caret = translate_string (fn
    "^" => "__caret__"
   |"," => "__comma__"
   |"@" => "__at__"
   |"[" => "__openbracket__"
   |"]" => "__closebracket__"
   |"." => "_"
   |"'" => "__apostrophe__"
   | x => x);
  fun ose oc s = TextIO.output (oc, escape_caret s)
  fun os oc s = TextIO.output (oc, s)
*}
ML {*
fun output_term oc bnds (Const ("IFOL.Trueprop", _) $ t) = output_term oc bnds t
  | output_term oc bnds ((Const ("IFOL.conj", _) $ t1) $ t2) =
      (os oc "("; output_term oc bnds t1; os oc " & "; output_term oc bnds t2; os oc ")")
  | output_term oc bnds ((Const ("FOL.induct_conj", _) $ t1) $ t2) =
      (os oc "("; output_term oc bnds t1; os oc " & "; output_term oc bnds t2; os oc ")")
  | output_term oc bnds ((Const ("Pure.conjunction", _) $ t1) $ t2) =
      (os oc "("; output_term oc bnds t1; os oc " & "; output_term oc bnds t2; os oc ")")
  | output_term oc bnds ((Const ("IFOL.disj", _) $ t1) $ t2) =
      (os oc "("; output_term oc bnds t1; os oc " | "; output_term oc bnds t2; os oc ")")
  | output_term oc bnds ((Const ("IFOL.imp", _) $ t1) $ t2) =
      (os oc "("; output_term oc bnds t1; os oc " => "; output_term oc bnds t2; os oc ")")
  | output_term oc bnds ((Const ("Pure.imp", _) $ t1) $ t2) =
      (os oc "("; output_term oc bnds t1; os oc " => "; output_term oc bnds t2; os oc ")")
  | output_term oc bnds ((Const ("FOL.induct_implies", _) $ t1) $ t2) =
      (os oc "("; output_term oc bnds t1; os oc " => "; output_term oc bnds t2; os oc ")")
  | output_term oc bnds ((Const ("IFOL.iff", _) $ t1) $ t2) =
      (os oc "("; output_term oc bnds t1; os oc " <=> "; output_term oc bnds t2; os oc ")")
  | output_term oc bnds ((Const ("IFOL.eq", _) $ t1) $ t2) =
      let val ty = fastype_of1 (bnds, t1) in
      (os oc "("; output_term oc bnds t1; os oc (if ty = @{typ o} orelse ty = @{typ prop} then " <=> " else " = "); output_term oc bnds t2; os oc ")")
      end
  | output_term oc bnds ((Const ("FOL.induct_equal", _) $ t1) $ t2) =
      let val ty = fastype_of1 (bnds, t1) in
      (os oc "("; output_term oc bnds t1; os oc (if ty = @{typ o} orelse ty = @{typ prop} then " <=> " else " = "); output_term oc bnds t2; os oc ")")
      end
  | output_term oc bnds ((Const ("Pure.eq", _) $ t1) $ t2) =
      let val ty = fastype_of1 (bnds, t1) in
      (os oc "("; output_term oc bnds t1; os oc (if ty = @{typ o} orelse ty = @{typ prop} then " <=> " else " = "); output_term oc bnds t2; os oc ")")
      end
  | output_term oc bnds (Const ("IFOL.Not", _) $ t) =
      (os oc "(~ "; output_term oc bnds t; os oc ")")
  | output_term oc _ (Const ("IFOL.False", _)) = os oc "$false"
  | output_term oc _ (Const ("IFOL.True", _)) = os oc "$true"
  | output_term oc bnds (Const ("Pure.all", _) $ Abs (_, ty, r)) =
      (os oc "![V"; os oc (Int.toString (length bnds)); os oc "]: (";
      output_term oc (ty :: bnds) r; os oc ")")
  | output_term oc bnds (Const ("IFOL.All", _) $ Abs (_, ty, r)) =
      (os oc "![V"; os oc (Int.toString (length bnds)); os oc "]: (";
      output_term oc (ty :: bnds) r; os oc ")")
  | output_term oc bnds (Const ("FOL.induct_forall", _) $ Abs (_, ty, r)) =
      (os oc "![V"; os oc (Int.toString (length bnds)); os oc "]: (";
      output_term oc (ty :: bnds) r; os oc ")")
  | output_term oc bnds (Const ("IFOL.Ex", _) $ Abs (_, ty, r)) =
      (os oc "?[V"; os oc (Int.toString (length bnds)); os oc "]: (";
      output_term oc (ty :: bnds) r; os oc ")")
  | output_term oc _ (Const (n, _)) =
      (os oc "c"; ose oc n)
  | output_term oc bnds (tm as (_ $ _)) =
      let val (l, args as (argh :: argt)) = strip_comb tm in
      (case l of
         Const _ => (output_term oc bnds l; os oc "("; output_term oc bnds argh;
           List.app (fn x => (os oc ","; output_term oc bnds x)) argt; os oc ")")
       | _ =>
         let
           val ty = fastype_of1 (bnds, tm);
           val s1 = (if ty = @{typ o} orelse ty = @{typ prop} then "p(" else "i(")
         in
           (os oc s1; List.app (fn _ => os oc "i(") argt; output_term oc bnds l;
           List.app (fn a => (os oc ","; output_term oc bnds a; os oc ")")) args)
         end
      )
      end
(*  | output_term oc bnds (Abs (_, ty, r)) =
      (os oc "(^[V"; os oc (Int.toString (length bnds));
      os oc "]: "; output_term oc (ty :: bnds) r; os oc ")")*)
  | output_term oc bnds (Bound n) =
      (os oc "V"; os oc (Int.toString (length bnds - n - 1)))
;

fun output_thm oc (name, tm) =
  (os oc "fof(t"; ose oc name; os oc ",axiom,"; output_term oc [] tm; os oc ").\n")
*}

ML {*
 val th = Drule.forall_intr_vars (Thm.legacy_freezeT @{thm exI});
 val oc = TextIO.openOut "bla";
 output_thm oc ("exI", Thm.prop_of th);
 TextIO.closeOut oc
*}

ML {*
fun mk_def Ts T lhs rhs =
  let fun mk_all T t = FOLogic.all_const T $ Abs (Name.uu, T, t)
  in fold mk_all Ts (FOLogic.eq_const T $ lhs $ rhs) end

fun mk_abs Ts = fold (fn T => fn t => Abs (Name.uu, T, t)) Ts

fun dest_abs Ts (Abs (_, T, t)) = dest_abs (T :: Ts) t
  | dest_abs Ts t = (Ts, t)

fun replace_lambda basename Us Ts t (cx as (defs, ctxt)) =
  let
    val t1 = mk_abs Us t
    val bs = sort int_ord (Term.add_loose_bnos (t1, 0, []))
    fun rep i k = if member (op =) bs i then (Bound k, k+1) else (Bound i, k)
    val (rs, _) = fold_map rep (0 upto length Ts - 1) 0
    val t2 = Term.subst_bounds (rs, t1)
    val Ts' = map (nth Ts) bs
    val (_, t3) = dest_abs [] t2
    val t4 = mk_abs Ts' t2

    val T = Term.fastype_of1 (Us @ Ts, t)
    fun app f = Term.list_comb (f, map Bound (rev bs))
  in
    (case Termtab.lookup defs t4 of
      SOME (f, _) => (app f, cx)
    | NONE =>
        let
          val (n, ctxt') = yield_singleton Variable.variant_fixes basename ctxt
          val (is, UTs) = split_list (map_index I (Us @ Ts'))
          val f = Free (n, rev UTs ---> T)
          val lhs = Term.list_comb (f, map Bound (rev is))
          val def = mk_def UTs (Term.fastype_of1 (Us @ Ts, t)) lhs t3
        in (app f, (Termtab.update (t4, (f, def)) defs, ctxt')) end)
  end


fun lift_lambdas1 is_binder basename =
  let
    val basename' = the_default Name.uu basename

    fun traverse Ts (t $ (u as Abs (n, T, body))) =
          if is_binder t then
            traverse Ts t ##>> traverse (T :: Ts) body #>> (fn (t', body') =>
            t' $ Abs (n, T, body'))
          else traverse Ts t ##>> traverse Ts u #>> (op $)
      | traverse Ts (t as Abs _) =
          let val (Us, u) = dest_abs [] t
          in traverse (Us @ Ts) u #-> replace_lambda basename' Us Ts end
      | traverse Ts (t $ u) = traverse Ts t ##>> traverse Ts u #>> (op $)
      | traverse _ t = pair t
  in traverse [] end;

fun finish (defs, ctxt) = (Termtab.fold (cons o snd o snd) defs [], ctxt)

fun init ctxt = (Termtab.empty, ctxt)

fun lift_lambdas basename is_binder ts ctxt =
  init ctxt
  |> fold_map (lift_lambdas1 is_binder basename) ts
  |-> (fn ts' => finish #>> pair ts');

fun is_quantifier (Const (@{const_name All}, _)) = true
  | is_quantifier (Const (@{const_name Ex}, _)) = true
  | is_quantifier (Const (@{const_name Pure.all}, _)) = true
  | is_quantifier _ = false;
*}
ML {*
fun lift1 prop =
  let
    val (([p2], l2), _) = lift_lambdas NONE is_quantifier [prop] @{context}
  in
    fold (fn p => fn sf => Logic.mk_implies (FOLogic.mk_Trueprop p, sf)) l2 p2
  end;
(*cterm_of @{theory} (lift1 (prop_of @{thm lam_eqE}))*)
*}

ML {*
  val allthms = rev (Global_Theory.all_thms_of @{theory} true);
  val (names, thms) = split_list allthms;
  val nofree = map Drule.export_without_context thms;
  val tythms = map Thm.legacy_freezeT nofree;
  val genthms = map Drule.forall_intr_vars tythms;
  val lifted = map (lift1 o Thm.prop_of) genthms;
*}

ML {*
fun quantfrees t =
  let
    val l = Term.add_frees t [];
  in
    fold (fn (s, T) => fn prop => Logic.all_const T $ Abs (s, T, abstract_over (Free (s, T), prop))) l t
  end
*}

(*ML {* cterm_of @{theory} (quantfrees (lift1 (prop_of(Drule.forall_intr_vars (Drule.export_without_context (Thm.legacy_freezeT @{thm wfI})))))) *}*)


ML {*
val pairs = names ~~ lifted;
(*val oc = TextIO.openOut "bla";
List.app (output_thm oc) pairs handle _ => TextIO.closeOut oc*)
*}
ML {*
fun write_statements fname =
  let
    val allthms = rev (Global_Theory.all_thms_of @{theory} true);
    val (names, thms) = split_list allthms;
    val nofree = map Drule.export_without_context thms;
    val tythms = map Thm.legacy_freezeT nofree;
    val genthms = map Drule.forall_intr_vars tythms;
    val lifted = map (quantfrees o lift1 o Thm.prop_of) genthms;
    val pairs = names ~~ lifted;
    val oc = TextIO.openOut fname;
  in
    (List.app (output_thm oc) pairs; TextIO.closeOut oc)
  end;

write_statements "fof.p";
*}

ML {*
fun output_type oc tvs (TVar v) = (os oc "A"; os oc (Int.toString (find_index (fn x => x = v) tvs)))
  | output_type oc _ (Type (n, [])) = (os oc "t"; ose oc n)
  | output_type oc tvs (Type ("fun", [l, r])) = (os oc "("; output_type oc tvs l; os oc " > "; output_type oc tvs r; os oc ")")
  | output_type oc tvs (Type (n, l)) = (os oc "(t"; ose oc n; ignore (map (fn e => (os oc " @ "; output_type oc tvs e)) l); os oc ")");

fun output_ty oc (name, (ty, _)) =
  (os oc "(c"; ose oc name; TextIO.output (oc, ",");
  output_type oc (Term.add_tvarsT ty []) ty; os oc ")\n")
*}

ML {*
fun write_consts fname =
  let
    val alltys = (#constants (Consts.dest (Sign.consts_of @{theory})))
    val oc = TextIO.openOut fname
  in
    (List.app (output_ty oc) alltys; TextIO.closeOut oc)
  end;

write_consts "cnsts"
*}

ML {* fun pairself f (x, y) = (f x, f y); *}

ML {*

val local_prefix = "local" ^ Long_Name.separator
val thy_name_of_thm = Context.theory_name o Thm.theory_of_thm

fun nickname_of_thm th =
  if Thm.has_name_hint th then
    let val hint = Thm.get_name_hint th in
      (* There must be a better way to detect local facts. *)
      case try (unprefix local_prefix) hint of
        SOME suf =>
        thy_name_of_thm th ^ Long_Name.separator ^ suf ^
        Long_Name.separator ^ PolyML.makestring th
      | NONE => hint
    end
  else
    PolyML.makestring th

fun un_class_ify s = 
  case first_field "_class" s of
    SOME (pref, suf) => [s, pref ^ suf]
  | NONE => [s]

fun if_thm_before th th' =
  if Theory.subthy (pairself Thm.theory_of_thm (th, th')) then th else th'

fun build_name_tables name_of facts =
  let
    fun cons_thm (_, th) =
      Termtab.cons_list ( (Thm.prop_of th), th)
    fun add_plain canon alias =
      Symtab.update (Thm.get_name_hint alias,
                     name_of (if_thm_before canon alias))
    fun add_plains (_, aliases as canon :: _) = fold (add_plain canon) aliases
    fun add_inclass (name, target) =
      fold (fn s => Symtab.update (s, target)) (un_class_ify name)
    val prop_tab = fold cons_thm facts Termtab.empty
    val plain_name_tab = Termtab.fold add_plains prop_tab Symtab.empty
    val inclass_name_tab = Symtab.fold add_inclass plain_name_tab Symtab.empty
  in (plain_name_tab, inclass_name_tab) end;

val name_tabs = SOME (build_name_tables nickname_of_thm (Global_Theory.all_thms_of @{theory} true))
*}

ML {*
fun fold_body_thms outer_name (map_plain_name, map_inclass_name) =
  let
    fun app map_name n (PBody {thms, ...}) =
      thms |> fold (fn (_, (name, _, body)) => fn accum =>
          let
            val collect = union (op =) o the_list o map_name
            (* The "name = outer_name" case caters for the uncommon case where
               the proved theorem occurs in its own proof (e.g.,
               "Transitive_Closure.trancl_into_trancl"). *)
            val (anonymous, enter_class) =
              if name = "" orelse (n = 1 andalso name = outer_name) then
                (true, false)
              else if n = 1 andalso map_inclass_name name = SOME outer_name then
                (true, true)
              else
                (false, false)
            val accum =
              accum |> (if n = 1 andalso not anonymous then collect name else I)
            val n = n + (if anonymous then 0 else 1)
          in
            accum
            |> (if n <= 1 then
                  app (if enter_class then map_inclass_name else map_name) n
                      (Future.join body)
                else
                  I)
          end)
  in fold (app map_plain_name 0) end;
val map_names =
      case name_tabs of
        SOME p => pairself Symtab.lookup p
      | NONE => `I SOME;
fun deps th = fold_body_thms (Thm.get_name_hint th) (map_names) [Thm.proof_body_of th] [];
*}

ML {*
fun write_deps fname =
 let
  val allthms = (Global_Theory.all_thms_of @{theory} true);
  val oc = TextIO.openOut fname;
  fun outp (name, th) = (ose oc name; List.app (fn s => (os oc " "; ose oc s)) (deps th); os oc "\n")
 in (List.app outp allthms; TextIO.closeOut oc) end;

write_deps "deps";
*}


end
