{
 open Lexing;;
 open Hh_parse;;
}

let white = [' ' '\t']
let newline = ['\r' '\n']
let letter = ['a'-'z' 'A'-'Z' '0'-'9' '_']
let coqletter = ['a'-'z' 'A'-'Z' '0'-'9' '_' '\'']

rule hh2lex = parse
| '%' [^'\n' '\r']*  {hh2lex lexbuf}
| white+             {hh2lex lexbuf}
| newline            {let pos = lexbuf.Lexing.lex_curr_p in
                      lexbuf.Lexing.lex_curr_p <- { pos with
                        Lexing.pos_lnum = pos.Lexing.pos_lnum + 1;
                        Lexing.pos_bol = pos.Lexing.pos_cnum;
                      };
                      hh2lex lexbuf} (*...*)
| eof                {TokEof}
| '('                {TokParO}
| ')'                {TokParC}
| '.'                {TokDot}
| ','                {TokComma}
| '!' white* '['     {TokQUni}
| '!' '>' white* '[' {TokQUni}
| '?' white* '['     {TokQExi}
| '^' white* '['     {TokLam}
| ']' white* ':'     {TokSqrC}
| "!="               {TokNEq}
| '~'                {TokTilde}
| "<=>"              {TokEqvt}
| "<~>"              {TokNEqvt}
| "=>"               {TokImpl}
| "<="               {TokRevImpl}
| '='                {TokEq}
| '&'                {TokAnd}
| '|'                {TokOr}
| ':'                {TokColon}
| '>'                {TokFun}
| '@'                {TokAt}
| '\''               {TokWord ("'" ^ lex_squot lexbuf ^ "'")}
| '"'                {TokWord ("\"" ^ lex_dquot lexbuf ^ "\"")}
| letter+             {TokWord (Lexing.lexeme lexbuf)}
| '$' letter+         {TokWord (Lexing.lexeme lexbuf)}
(*| [^'\n' '\r']+     {TokUnknown (Lexing.lexeme lexbuf)}*)

and coqlex = parse
| '%' [^'\n' '\r']*  {coqlex lexbuf}
| white+             {coqlex lexbuf}
| newline            {let pos = lexbuf.Lexing.lex_curr_p in
                      lexbuf.Lexing.lex_curr_p <- { pos with
                        Lexing.pos_lnum = pos.Lexing.pos_lnum + 1;
                        Lexing.pos_bol = pos.Lexing.pos_cnum;
                      };
                      coqlex lexbuf} (*...*)
| eof                {TokEof}
| '('                {TokParO}
| ')'                {TokParC}
| '.'                {TokDot}
| ','                {TokComma}
| '!' white* '['     {TokQUni}
| '!' '>' white* '[' {TokQUni}
| '?' white* '['     {TokQExi}
| '^' white* '['     {TokLam}
| ']' white* ':'     {TokSqrC}
| "!="               {TokNEq}
| '~'                {TokTilde}
| "<=>"              {TokEqvt}
| "<~>"              {TokNEqvt}
| "=>"               {TokImpl}
| '='                {TokEq}
| '&'                {TokAnd}
| '|'                {TokOr}
| ':'                {TokColon}
| '>'                {TokFun}
| '@'                {TokAt}
| coqletter+ ('.' coqletter+)*  {TokWord (Lexing.lexeme lexbuf)}
| '$' coqletter+     {TokWord (Lexing.lexeme lexbuf)}

and lex_squot = parse
| '\''               {""}
| '\\' '\''          {"\\'" ^ lex_squot lexbuf}
| '\\' '\\'          {"\\\\" ^ lex_squot lexbuf}
| [^ '\'' '\\']+     {let s = Lexing.lexeme lexbuf in s ^ lex_squot lexbuf}

and lex_dquot = parse
| '"'                {""}
| '\\' '\\'          {"\\" ^ lex_dquot lexbuf}
| '\\' '"'           {"\"" ^ lex_dquot lexbuf}
| [^ '"' '\\']+      {let s = Lexing.lexeme lexbuf in s ^ lex_dquot lexbuf}
| _                  {failwith "lex_dquot: invalid escaped sequence"}

and lex_cblock = parse
| '*' '/'            {hh2lex lexbuf}
| '*'                {lex_cblock lexbuf}
| [^ '*']+           {lex_cblock lexbuf}

{
}
