## Install PolyML
  sudo apt install polyml
  sudo apt install libpolyml-dev
  https://www.polyml.org/download.html

## Download HOL in the same directory as this README:
  cd h4pfg
  git clone https://github.com/HOL-Theorem-Prover/HOL.git HOL-pfg

## Install HOL core library with modified recording kernel:
  cd HOL-pfg
  git checkout b7716bd92d1115f6a85cbf82d4dd47e1bb88828a
  poly < tools/smart-configure.sml
  cd ..
  sh overwrite_kernel.sh
  cd HOL-pfg
  cat tools/sequences/kernel tools/sequences/core-theories > tools/sequences/core
  bin/build --seq="tools/sequences/core"

## Install h4pfg:
  cd ../src
  ../HOL-pfg/bin/Holmake cleanAll
  ../HOL-pfg/bin/Holmake

## Running h4pfg (rlwrap is recommended: sudo apt install rlwrap):
  rlwrap ../HOL-pfg/bin/hol
  
## Then copy-paste proofscripts in the following files (src directory):

- hfHH.sml: 
    - shows how to read bounties into HOL4
    - test if a list of bounties can be automatically proven

- proofgold_demo.sml:
    - includes a derivation of HOL4 reflexivity rule from Proofgold kernel rules
    - manually or automatically proves a HOL4 formula and export a proof term 
    
    
