(* interactive call 
ocaml -I bin -I +threads unix.cma threads.cma /usr/lib/ocaml/zarith/zarith.cma zarithint.cmo json.cmo config.cmo version.cmo utils.cmo ser.cmo hashaux.cmo sha256.cmo ripemd160.cmo hash.cmo htree.cmo db.cmo net.cmo secp256k1.cmo cryptocurr.cmo signat.cmo ltcrpc.cmo script.cmo logic.cmo mathdata.cmo checking.cmo
*)

open Logic;;
open Checking;;

let sexp sl = "(" ^ String.concat " " sl ^ ")";;

let writel file sl = 
  let oc = open_out file in
  let rec f l = match l with 
    | [] -> () 
    | [s] -> output_string oc s
    | s :: m -> (output_string oc (s ^ "\n") ; f m)
  in
    (f sl; close_out oc)
  ;;

let rec string_of_term tm = match tm with 
  | DB i -> sexp ["DB";string_of_int i]
  | TmH _ -> raise (Failure "not supported")
  | Prim i -> sexp ["Prim";string_of_int i]
  | Ap (t1,t2) -> sexp ["Ap"; string_of_term t1; string_of_term t2]
  | Lam (ty,t) -> sexp ["Lam"; string_of_type ty; string_of_term t]
  | Imp (t1,t2) -> sexp ["Imp"; string_of_term t1; string_of_term t2]
  | All (ty,t) -> sexp ["All"; string_of_type ty; string_of_term t]
  | Ex (ty,t) -> sexp ["Ex"; string_of_type ty; string_of_term t]
  | Eq (ty,t1,t2) -> sexp ["Eq";string_of_type ty; 
                           string_of_term t1; string_of_term t2]
and string_of_type ty = match ty with
  | Base i -> sexp ["Base";string_of_int i]
  | TpArr (ty1,ty2) -> sexp ["TpArr"; string_of_type ty1; string_of_type ty2]
  | Prop -> sexp ["Prop"]
;;

let namel = Array.to_list hfprimnamesa;;
let typel = List.map string_of_type hfprimtps;;
writel "primname" namel;;
writel "primtype" typel;;

let hfaxsprenorm = [All(TpArr(Base(0),Prop),All(Base(0),Imp(Ap(DB(1),DB(0)),Ap(DB(1),Ap(Prim(0),DB(1))))));
All(Prop,Imp(Ap(Prim(3),Ap(Prim(3),DB(0))),DB(0)));
All(Prop,All(Prop,Imp(Ap(Ap(Prim(6),DB(1)),DB(0)),Eq(Prop,DB(1),DB(0)))));
All(Base(0),All(Base(0),Imp(Ap(Ap(Prim(8),DB(1)),DB(0)),Imp(Ap(Ap(Prim(8),DB(0)),DB(1)),Eq(Base(0),DB(1),DB(0))))));
Ap(Prim(3),Ex(Base(0),Ap(Ap(Prim(7),DB(0)),Prim(9))));
All(Base(0),All(Base(0),Ap(Ap(Prim(6),Ap(Ap(Prim(7),DB(0)),Ap(Prim(10),DB(1)))),Ex(Base(0),Ap(Ap(Prim(4),Ap(Ap(Prim(7),DB(1)),DB(0))),Ap(Ap(Prim(7),DB(0)),DB(2)))))));
All(Base(0),All(Base(0),Ap(Ap(Prim(6),Ap(Ap(Prim(7),DB(0)),Ap(Prim(11),DB(1)))),Ap(Ap(Prim(8),DB(0)),DB(1)))));
All(Base(0),All(TpArr(Base(0),Base(0)),All(Base(0),Ap(Ap(Prim(6),Ap(Ap(Prim(7),DB(0)),Ap(Ap(Prim(12),DB(2)),Lam(Base(0),Ap(DB(2),DB(0)))))),Ex(Base(0),Ap(Ap(Prim(4),Ap(Ap(Prim(7),DB(0)),DB(3))),Eq(Base(0),DB(1),Ap(DB(2),DB(0)))))))));
All(TpArr(Base(0),Prop),Imp(All(Base(0),Imp(Ap(DB(1),DB(0)),All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(1)),Ap(DB(2),DB(0)))))),Imp(Ap(DB(0),Prim(9)),Imp(All(Base(0),Imp(Ap(DB(1),DB(0)),Ap(DB(1),Ap(Prim(10),DB(0))))),Imp(All(Base(0),Imp(Ap(DB(1),DB(0)),Ap(DB(1),Ap(Prim(11),DB(0))))),Imp(All(Base(0),Imp(Ap(DB(1),DB(0)),All(TpArr(Base(0),Base(0)),Imp(All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(2)),Ap(DB(3),Ap(DB(1),DB(0))))),Ap(DB(2),Ap(Ap(Prim(12),DB(1)),Lam(Base(0),Ap(DB(1),DB(0))))))))),All(Base(0),Ap(DB(1),DB(0)))))))));
All(TpArr(Base(0),Prop),Imp(All(Base(0),Imp(All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(1)),Ap(DB(2),DB(0)))),Ap(DB(1),DB(0)))),All(Base(0),Ap(DB(1),DB(0)))));
Eq(Prop,Prim(1),All(Prop,DB(0)));
Eq(Prop,Prim(2),All(Prop,Imp(DB(0),DB(0))));
Eq(TpArr(Prop,Prop),Prim(3),Lam(Prop,Imp(DB(0),Prim(1))));
Eq(TpArr(Prop,TpArr(Prop,Prop)),Prim(4),Lam(Prop,Lam(Prop,All(Prop,Imp(Imp(DB(2),Imp(DB(1),DB(0))),DB(0))))));
Eq(TpArr(Prop,TpArr(Prop,Prop)),Prim(5),Lam(Prop,Lam(Prop,All(Prop,Imp(Imp(DB(2),DB(0)),Imp(Imp(DB(1),DB(0)),DB(0)))))));
Eq(TpArr(Prop,TpArr(Prop,Prop)),Prim(6),Lam(Prop,Lam(Prop,Ap(Ap(Prim(4),Imp(DB(1),DB(0))),Imp(DB(0),DB(1))))));
Eq(TpArr(Base(0),TpArr(Base(0),Prop)),Prim(8),Lam(Base(0),Lam(Base(0),All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(2)),Ap(Ap(Prim(7),DB(0)),DB(1)))))));
Eq(TpArr(Base(0),Prop),Prim(13),Lam(Base(0),All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(1)),Ap(Ap(Prim(8),DB(0)),DB(1))))));
Eq(TpArr(Base(0),Prop),Prim(14),Lam(Base(0),Ex(Base(0),Ap(Ap(Prim(4),Ap(Ap(Prim(7),DB(0)),DB(1))),Ap(Prim(3),Ap(Ap(Prim(8),DB(1)),Ap(Prim(11),DB(0))))))));
Eq(TpArr(Base(0),Prop),Prim(15),Lam(Base(0),Ex(Base(0),Ap(Ap(Prim(4),Ap(Ap(Prim(8),DB(0)),DB(1))),Ap(Ap(Prim(4),Ap(Prim(3),Ap(Ap(Prim(8),DB(1)),DB(0)))),Ap(Prim(14),DB(0)))))));
Eq(TpArr(Base(0),Prop),Prim(16),Lam(Base(0),Ex(Base(0),Ap(Ap(Prim(4),Ap(Ap(Prim(8),DB(0)),DB(1))),Ap(Ap(Prim(4),Ap(Prim(3),Ap(Ap(Prim(8),DB(1)),DB(0)))),Ap(Prim(15),DB(0)))))));
Eq(TpArr(Base(0),Prop),Prim(17),Lam(Base(0),Ex(Base(0),Ap(Ap(Prim(4),Ap(Ap(Prim(8),DB(0)),DB(1))),Ap(Ap(Prim(4),Ap(Prim(3),Ap(Ap(Prim(8),DB(1)),DB(0)))),Ap(Prim(16),DB(0)))))));
Eq(TpArr(Base(0),Prop),Prim(18),Lam(Base(0),Ex(Base(0),Ap(Ap(Prim(4),Ap(Ap(Prim(8),DB(0)),DB(1))),Ap(Ap(Prim(4),Ap(Prim(3),Ap(Ap(Prim(8),DB(1)),DB(0)))),Ap(Prim(17),DB(0)))))));
Eq(TpArr(Base(0),Prop),Prim(19),Lam(Base(0),Ap(Ap(Prim(4),Ap(Prim(14),DB(0))),Ap(Prim(3),Ap(Prim(15),DB(0))))));
Eq(TpArr(Base(0),Prop),Prim(20),Lam(Base(0),Ap(Ap(Prim(4),Ap(Prim(15),DB(0))),Ap(Prim(3),Ap(Prim(16),DB(0))))));
Eq(TpArr(Base(0),Prop),Prim(21),Lam(Base(0),Ap(Ap(Prim(4),Ap(Prim(16),DB(0))),Ap(Prim(3),Ap(Prim(17),DB(0))))));
Eq(TpArr(Base(0),Prop),Prim(22),Lam(Base(0),Ap(Ap(Prim(4),Ap(Prim(17),DB(0))),Ap(Prim(3),Ap(Prim(18),DB(0))))));
Eq(TpArr(TpArr(Base(0),Prop),Prop),Prim(23),Lam(TpArr(Base(0),Prop),Ap(Ap(Prim(4),Ex(Base(0),Ap(DB(1),DB(0)))),All(Base(0),All(Base(0),Imp(Ap(DB(2),DB(1)),Imp(Ap(DB(2),DB(0)),Eq(Base(0),DB(1),DB(0)))))))));
Eq(TpArr(TpArr(Base(0),TpArr(Base(0),Prop)),Prop),Prim(24),Lam(TpArr(Base(0),TpArr(Base(0),Prop)),All(Base(0),Ap(Ap(DB(1),DB(0)),DB(0)))));
Eq(TpArr(TpArr(Base(0),TpArr(Base(0),Prop)),Prop),Prim(25),Lam(TpArr(Base(0),TpArr(Base(0),Prop)),All(Base(0),Ap(Prim(3),Ap(Ap(DB(1),DB(0)),DB(0))))));
Eq(TpArr(TpArr(Base(0),TpArr(Base(0),Prop)),Prop),Prim(26),Lam(TpArr(Base(0),TpArr(Base(0),Prop)),All(Base(0),All(Base(0),Imp(Ap(Ap(DB(2),DB(1)),DB(0)),Ap(Ap(DB(2),DB(0)),DB(1)))))));
Eq(TpArr(TpArr(Base(0),TpArr(Base(0),Prop)),Prop),Prim(27),Lam(TpArr(Base(0),TpArr(Base(0),Prop)),All(Base(0),All(Base(0),Imp(Ap(Ap(DB(2),DB(1)),DB(0)),Imp(Ap(Ap(DB(2),DB(0)),DB(1)),Eq(Base(0),DB(1),DB(0))))))));
Eq(TpArr(TpArr(Base(0),TpArr(Base(0),Prop)),Prop),Prim(28),Lam(TpArr(Base(0),TpArr(Base(0),Prop)),All(Base(0),All(Base(0),All(Base(0),Imp(Ap(Ap(DB(3),DB(2)),DB(1)),Imp(Ap(Ap(DB(3),DB(1)),DB(0)),Ap(Ap(DB(3),DB(2)),DB(0)))))))));
Eq(TpArr(TpArr(Base(0),TpArr(Base(0),Prop)),Prop),Prim(29),Lam(TpArr(Base(0),TpArr(Base(0),Prop)),Ap(Ap(Prim(4),Ap(Ap(Prim(4),Ap(Prim(24),DB(0))),Ap(Prim(26),DB(0)))),Ap(Prim(28),DB(0)))));
Eq(TpArr(TpArr(Base(0),TpArr(Base(0),Prop)),Prop),Prim(30),Lam(TpArr(Base(0),TpArr(Base(0),Prop)),Ap(Ap(Prim(4),Ap(Prim(26),DB(0))),Ap(Prim(28),DB(0)))));
Eq(TpArr(TpArr(Base(0),TpArr(Base(0),Prop)),Prop),Prim(31),Lam(TpArr(Base(0),TpArr(Base(0),Prop)),All(Base(0),All(Base(0),Ap(Ap(Prim(5),Ap(Ap(DB(2),DB(1)),DB(0))),Ap(Ap(DB(2),DB(0)),DB(1)))))));
Eq(TpArr(TpArr(Base(0),TpArr(Base(0),Prop)),Prop),Prim(32),Lam(TpArr(Base(0),TpArr(Base(0),Prop)),All(Base(0),All(Base(0),Ap(Ap(Prim(5),Ap(Ap(Prim(5),Ap(Ap(DB(2),DB(1)),DB(0))),Eq(Base(0),DB(1),DB(0)))),Ap(Ap(DB(2),DB(0)),DB(1)))))));
Eq(TpArr(TpArr(Base(0),TpArr(Base(0),Prop)),Prop),Prim(33),Lam(TpArr(Base(0),TpArr(Base(0),Prop)),Ap(Ap(Prim(4),Ap(Ap(Prim(4),Ap(Prim(24),DB(0))),Ap(Prim(27),DB(0)))),Ap(Prim(28),DB(0)))));
Eq(TpArr(TpArr(Base(0),TpArr(Base(0),Prop)),Prop),Prim(34),Lam(TpArr(Base(0),TpArr(Base(0),Prop)),Ap(Ap(Prim(4),Ap(Prim(33),DB(0))),Ap(Prim(31),DB(0)))));
Eq(TpArr(TpArr(Base(0),TpArr(Base(0),Prop)),Prop),Prim(35),Lam(TpArr(Base(0),TpArr(Base(0),Prop)),Ap(Ap(Prim(4),Ap(Prim(25),DB(0))),Ap(Prim(28),DB(0)))));
Eq(TpArr(TpArr(Base(0),TpArr(Base(0),Prop)),Prop),Prim(36),Lam(TpArr(Base(0),TpArr(Base(0),Prop)),Ap(Ap(Prim(4),Ap(Prim(35),DB(0))),Ap(Prim(32),DB(0)))));
Eq(TpArr(Prop,TpArr(Base(0),TpArr(Base(0),Base(0)))),Prim(37),Lam(Prop,Lam(Base(0),Lam(Base(0),Ap(Prim(0),Lam(Base(0),Ap(Ap(Prim(5),Ap(Ap(Prim(4),DB(3)),Eq(Base(0),DB(0),DB(2)))),Ap(Ap(Prim(4),Ap(Prim(3),DB(3))),Eq(Base(0),DB(0),DB(1))))))))));
Eq(TpArr(Prop,TpArr(Prop,Prop)),Prim(38),Lam(Prop,Lam(Prop,Ap(Ap(Prim(5),Ap(Ap(Prim(4),DB(1)),Ap(Prim(3),DB(0)))),Ap(Ap(Prim(4),Ap(Prim(3),DB(1))),DB(0))))));
Eq(TpArr(Prop,TpArr(Prop,TpArr(Prop,Prop))),Prim(39),Lam(Prop,Lam(Prop,Lam(Prop,Ap(Ap(Prim(5),Ap(Ap(Prim(4),Ap(Ap(Prim(38),DB(2)),DB(1))),Ap(Prim(3),DB(0)))),Ap(Ap(Prim(4),Ap(Ap(Prim(4),Ap(Prim(3),DB(2))),Ap(Prim(3),DB(1)))),DB(0)))))));
Eq(TpArr(Base(0),TpArr(Base(0),Prop)),Prim(40),Lam(Base(0),Lam(Base(0),Ap(Prim(3),Ap(Ap(Prim(7),DB(1)),DB(0))))));
Eq(TpArr(Base(0),TpArr(Base(0),Prop)),Prim(41),Lam(Base(0),Lam(Base(0),Ap(Prim(3),Ap(Ap(Prim(8),DB(1)),DB(0))))));
Eq(TpArr(Base(0),TpArr(Base(0),Base(0))),Prim(42),Lam(Base(0),Lam(Base(0),Ap(Ap(Prim(12),Ap(Prim(11),Ap(Prim(11),Prim(9)))),Lam(Base(0),Ap(Ap(Ap(Prim(37),Ap(Ap(Prim(7),Prim(9)),DB(0))),DB(2)),DB(1)))))));
Eq(TpArr(Base(0),Base(0)),Prim(43),Lam(Base(0),Ap(Ap(Prim(42),DB(0)),DB(0))));
Eq(TpArr(Base(0),TpArr(Base(0),Base(0))),Prim(44),Lam(Base(0),Lam(Base(0),Ap(Prim(10),Ap(Ap(Prim(42),DB(1)),DB(0))))));
Eq(TpArr(Base(0),TpArr(Base(0),Base(0))),Prim(45),Lam(Base(0),Lam(Base(0),Ap(Ap(Prim(44),DB(1)),Ap(Prim(43),DB(0))))));
Eq(TpArr(Base(0),TpArr(TpArr(Base(0),Base(0)),Base(0))),Prim(46),Lam(Base(0),Lam(TpArr(Base(0),Base(0)),Ap(Prim(10),Ap(Ap(Prim(12),DB(1)),Lam(Base(0),Ap(DB(1),DB(0))))))));
Eq(TpArr(Base(0),TpArr(TpArr(Base(0),Prop),Base(0))),Prim(47),Lam(Base(0),Lam(TpArr(Base(0),Prop),Ap(Ap(Ap(Prim(37),Ex(Base(0),Ap(Ap(Prim(4),Ap(Ap(Prim(7),DB(0)),DB(2))),Ap(DB(1),DB(0))))),Ap(Ap(Prim(12),DB(1)),Lam(Base(0),Ap(Lam(Base(0),Ap(Ap(Ap(Prim(37),Ap(DB(2),DB(0))),DB(0)),Ap(Prim(0),Lam(Base(0),Ap(Ap(Prim(4),Ap(Ap(Prim(7),DB(0)),DB(4))),Ap(DB(3),DB(0))))))),DB(0))))),Prim(9)))));
Eq(TpArr(Base(0),TpArr(TpArr(Base(0),Prop),TpArr(TpArr(Base(0),Base(0)),Base(0)))),Prim(48),Lam(Base(0),Lam(TpArr(Base(0),Prop),Lam(TpArr(Base(0),Base(0)),Ap(Ap(Prim(12),Ap(Ap(Prim(47),DB(2)),Lam(Base(0),Ap(DB(2),DB(0))))),Lam(Base(0),Ap(DB(1),DB(0))))))));
Eq(TpArr(Base(0),TpArr(Base(0),Base(0))),Prim(49),Lam(Base(0),Lam(Base(0),Ap(Ap(Prim(47),DB(1)),Lam(Base(0),Ap(Ap(Prim(7),DB(0)),DB(1)))))));
Eq(TpArr(Base(0),TpArr(Base(0),Base(0))),Prim(50),Lam(Base(0),Lam(Base(0),Ap(Ap(Prim(47),DB(1)),Lam(Base(0),Ap(Ap(Prim(40),DB(0)),DB(1)))))));
Eq(TpArr(Base(0),TpArr(Base(0),TpArr(TpArr(Base(0),Base(0)),Prop))),Prim(51),Lam(Base(0),Lam(Base(0),Lam(TpArr(Base(0),Base(0)),Ap(Ap(Prim(4),All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(3)),Ap(Ap(Prim(7),Ap(DB(1),DB(0))),DB(2))))),All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(3)),All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(4)),Imp(Eq(Base(0),Ap(DB(2),DB(1)),Ap(DB(2),DB(0))),Eq(Base(0),DB(1),DB(0))))))))))));
Eq(TpArr(Base(0),TpArr(Base(0),TpArr(TpArr(Base(0),Base(0)),Prop))),Prim(52),Lam(Base(0),Lam(Base(0),Lam(TpArr(Base(0),Base(0)),Ap(Ap(Prim(4),Ap(Ap(Ap(Prim(51),DB(2)),DB(1)),DB(0))),All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(2)),Ex(Base(0),Ap(Ap(Prim(4),Ap(Ap(Prim(7),DB(0)),DB(4))),Eq(Base(0),Ap(DB(2),DB(0)),DB(1)))))))))));
Eq(TpArr(Base(0),TpArr(Base(0),Prop)),Prim(53),Lam(Base(0),Lam(Base(0),Ex(TpArr(Base(0),Base(0)),Ap(Ap(Ap(Prim(51),DB(2)),DB(1)),DB(0))))));
Eq(TpArr(Base(0),TpArr(Base(0),Prop)),Prim(54),Lam(Base(0),Lam(Base(0),Ex(TpArr(Base(0),Base(0)),Ap(Ap(Ap(Prim(52),DB(2)),DB(1)),DB(0))))));
Eq(TpArr(TpArr(Base(0),TpArr(TpArr(Base(0),Base(0)),Base(0))),TpArr(Base(0),TpArr(Base(0),Prop))),Prim(55),Lam(TpArr(Base(0),TpArr(TpArr(Base(0),Base(0)),Base(0))),Lam(Base(0),Lam(Base(0),All(TpArr(Base(0),TpArr(Base(0),Prop)),Imp(All(Base(0),All(TpArr(Base(0),Base(0)),Imp(All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(2)),Ap(Ap(DB(3),DB(0)),Ap(DB(1),DB(0))))),Ap(Ap(DB(2),DB(1)),Ap(Ap(DB(5),DB(1)),DB(0)))))),Ap(Ap(DB(0),DB(2)),DB(1))))))));
Eq(TpArr(TpArr(Base(0),TpArr(TpArr(Base(0),Base(0)),Base(0))),TpArr(Base(0),Base(0))),Prim(56),Lam(TpArr(Base(0),TpArr(TpArr(Base(0),Base(0)),Base(0))),Lam(Base(0),Ap(Prim(0),Lam(Base(0),Ap(Ap(Ap(Prim(55),DB(2)),DB(1)),DB(0)))))));
Eq(TpArr(Base(0),Base(0)),Prim(57),Lam(Base(0),Ap(Ap(Prim(44),DB(0)),Ap(Prim(43),DB(0)))));
Eq(TpArr(Base(0),Prop),Prim(58),Lam(Base(0),All(TpArr(Base(0),Prop),Imp(Ap(DB(0),Prim(9)),Imp(All(Base(0),Imp(Ap(DB(1),DB(0)),Ap(DB(1),Ap(Prim(57),DB(0))))),Ap(DB(0),DB(1)))))));
Eq(TpArr(Base(0),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),TpArr(Base(0),Base(0)))),Prim(59),Lam(Base(0),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Ap(Prim(56),Lam(Base(0),Lam(TpArr(Base(0),Base(0)),Ap(Ap(Ap(Prim(37),Ap(Ap(Prim(7),Ap(Prim(10),DB(1))),DB(1))),Ap(Ap(DB(2),Ap(Prim(10),DB(1))),Ap(DB(0),Ap(Prim(10),DB(1))))),DB(3))))))));
Eq(TpArr(Base(0),TpArr(Base(0),Base(0))),Prim(60),Lam(Base(0),Lam(Base(0),Ap(Ap(Ap(Prim(59),DB(1)),Lam(Base(0),Lam(Base(0),Ap(Prim(57),DB(0))))),DB(0)))));
Eq(TpArr(Base(0),TpArr(Base(0),Base(0))),Prim(61),Lam(Base(0),Lam(Base(0),Ap(Ap(Ap(Prim(59),Prim(9)),Lam(Base(0),Lam(Base(0),Ap(Ap(Prim(60),DB(3)),DB(0))))),DB(0)))));
Eq(TpArr(Base(0),Prop),Prim(62),Lam(Base(0),Ap(Ap(Prim(4),Ap(Prim(13),DB(0))),All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(1)),Ap(Prim(13),DB(0)))))));
Eq(TpArr(Base(0),Base(0)),Prim(63),Ap(Prim(56),Lam(Base(0),Lam(TpArr(Base(0),Base(0)),Ap(Ap(Prim(46),DB(1)),Lam(Base(0),Ap(Prim(11),Ap(DB(1),DB(0)))))))));
Eq(TpArr(Base(0),Base(0)),Prim(64),Ap(Prim(56),Lam(Base(0),Lam(TpArr(Base(0),Base(0)),Ap(Ap(Prim(44),Ap(Prim(43),Prim(9))),Ap(Ap(Prim(12),DB(1)),Lam(Base(0),Ap(DB(1),DB(0)))))))));
Eq(TpArr(Base(0),Base(0)),Prim(65),Lam(Base(0),Ap(Ap(Prim(12),DB(0)),Lam(Base(0),Ap(Prim(64),DB(0))))));
Eq(TpArr(Base(0),Base(0)),Prim(66),Ap(Prim(56),Lam(Base(0),Lam(TpArr(Base(0),Base(0)),Ap(Ap(Prim(12),Ap(Ap(Prim(50),DB(1)),Ap(Prim(43),Prim(9)))),Lam(Base(0),Ap(DB(1),DB(0))))))));
Eq(TpArr(Base(0),TpArr(Base(0),TpArr(TpArr(Base(0),Base(0)),TpArr(TpArr(Base(0),Base(0)),TpArr(Base(0),Base(0)))))),Prim(67),Lam(Base(0),Lam(Base(0),Lam(TpArr(Base(0),Base(0)),Lam(TpArr(Base(0),Base(0)),Lam(Base(0),Ap(Ap(Ap(Prim(37),Eq(Base(0),DB(0),Ap(Prim(65),Ap(Prim(66),DB(0))))),Ap(DB(2),Ap(Prim(66),DB(0)))),Ap(DB(1),Ap(Prim(66),DB(0))))))))));
Eq(TpArr(Base(0),TpArr(Base(0),Base(0))),Prim(68),Lam(Base(0),Lam(Base(0),Ap(Ap(Prim(44),Ap(Ap(Prim(12),DB(1)),Lam(Base(0),Ap(Prim(65),DB(0))))),Ap(Ap(Prim(12),DB(0)),Lam(Base(0),Ap(Prim(64),DB(0))))))));
Eq(TpArr(Base(0),Base(0)),Prim(69),Lam(Base(0),Ap(Ap(Ap(Prim(48),DB(0)),Lam(Base(0),Ex(Base(0),Eq(Base(0),Ap(Prim(65),DB(0)),DB(1))))),Lam(Base(0),Ap(Prim(66),DB(0))))));
Eq(TpArr(Base(0),Base(0)),Prim(70),Lam(Base(0),Ap(Ap(Ap(Prim(48),DB(0)),Lam(Base(0),Ex(Base(0),Eq(Base(0),Ap(Prim(64),DB(0)),DB(1))))),Lam(Base(0),Ap(Prim(66),DB(0))))));
Eq(TpArr(Base(0),TpArr(Base(0),Base(0))),Prim(71),Lam(Base(0),Lam(Base(0),Ap(Ap(Prim(68),DB(1)),Ap(Prim(11),DB(0))))));
Eq(TpArr(Base(0),TpArr(TpArr(Base(0),Base(0)),Base(0))),Prim(72),Lam(Base(0),Lam(TpArr(Base(0),Base(0)),Ap(Ap(Prim(46),DB(1)),Lam(Base(0),Ap(Ap(Prim(12),Ap(DB(1),DB(0))),Lam(Base(0),Ap(Ap(Prim(68),DB(1)),DB(0)))))))));
Eq(TpArr(Base(0),TpArr(Base(0),Base(0))),Prim(73),Lam(Base(0),Lam(Base(0),Ap(Ap(Prim(72),DB(1)),Lam(Base(0),DB(1))))));
Eq(TpArr(Base(0),TpArr(Base(0),Base(0))),Prim(74),Lam(Base(0),Lam(Base(0),Ap(Ap(Ap(Prim(48),DB(1)),Lam(Base(0),Ex(Base(0),Eq(Base(0),DB(1),Ap(Ap(Prim(68),DB(2)),DB(0)))))),Lam(Base(0),Ap(Prim(70),DB(0)))))));
Eq(TpArr(Base(0),Prop),Prim(75),Lam(Base(0),Eq(Base(0),Ap(Ap(Prim(68),Ap(Ap(Prim(74),DB(0)),Prim(9))),Ap(Ap(Prim(74),DB(0)),Ap(Prim(57),Prim(9)))),DB(0))));
Eq(TpArr(Base(0),TpArr(Base(0),Prop)),Prim(76),Lam(Base(0),Lam(Base(0),All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(1)),Ex(Base(0),Ap(Ap(Prim(4),Ap(Ap(Prim(7),DB(0)),DB(3))),Ex(Base(0),Eq(Base(0),DB(2),Ap(Ap(Prim(68),DB(1)),DB(0)))))))))));
Eq(TpArr(Base(0),TpArr(TpArr(Base(0),Base(0)),Base(0))),Prim(77),Lam(Base(0),Lam(TpArr(Base(0),Base(0)),Ap(Ap(Prim(47),Ap(Prim(11),Ap(Ap(Prim(72),DB(1)),Lam(Base(0),Ap(Prim(10),Ap(DB(1),DB(0))))))),Lam(Base(0),All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(3)),Ap(Ap(Prim(7),Ap(Ap(Prim(74),DB(1)),DB(0))),Ap(DB(2),DB(0))))))))));
Eq(TpArr(Base(0),TpArr(Base(0),Base(0))),Prim(78),Lam(Base(0),Lam(Base(0),Ap(Ap(Prim(77),DB(0)),Lam(Base(0),DB(2))))));
Eq(TpArr(Base(0),TpArr(TpArr(Base(0),Base(0)),TpArr(TpArr(Base(0),TpArr(Base(0),Prop)),Base(0)))),Prim(79),Lam(Base(0),Lam(TpArr(Base(0),Base(0)),Lam(TpArr(Base(0),TpArr(Base(0),Prop)),Ap(Ap(Prim(47),Ap(Ap(Prim(72),DB(2)),Lam(Base(0),Ap(DB(2),DB(0))))),Lam(Base(0),Ap(Ap(DB(1),Ap(Ap(Prim(74),DB(0)),Prim(9))),Ap(Ap(Prim(74),DB(0)),Ap(Prim(57),Prim(9))))))))));
Eq(TpArr(Base(0),Prop),Prim(80),Lam(Base(0),All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(1)),Ex(Base(0),Ex(Base(0),Eq(Base(0),DB(2),Ap(Ap(Prim(72),Ap(Prim(57),Ap(Prim(57),Prim(9)))),Lam(Base(0),Ap(Ap(Ap(Prim(37),Eq(Base(0),DB(0),Prim(9))),DB(2)),DB(1)))))))))));
Eq(TpArr(Base(0),TpArr(TpArr(Base(0),Base(0)),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),Base(0)))),Prim(81),Lam(Base(0),Lam(TpArr(Base(0),Base(0)),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Ap(Ap(Prim(72),DB(2)),Lam(Base(0),Ap(Ap(Prim(72),Ap(DB(2),DB(0))),Lam(Base(0),Ap(Ap(DB(2),DB(1)),DB(0))))))))));
Eq(TpArr(Base(0),TpArr(TpArr(Base(0),Prop),TpArr(TpArr(Base(0),Prop),Prop))),Prim(82),Lam(Base(0),Lam(TpArr(Base(0),Prop),Lam(TpArr(Base(0),Prop),All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(3)),Ap(Ap(Prim(6),Ap(DB(2),DB(0))),Ap(DB(1),DB(0)))))))));
Eq(TpArr(Base(0),TpArr(TpArr(Base(0),Prop),TpArr(TpArr(Base(0),Prop),Prop))),Prim(83),Lam(Base(0),Lam(TpArr(Base(0),Prop),Lam(TpArr(Base(0),Prop),Ex(Base(0),Ap(Ap(Prim(4),Ap(Ap(Prim(7),DB(0)),DB(3))),Ap(Ap(Prim(4),Ap(Ap(Prim(4),Ap(Ap(Ap(Prim(82),DB(0)),DB(2)),DB(1))),Ap(Prim(3),Ap(DB(2),DB(0))))),Ap(DB(1),DB(0)))))))));
Eq(TpArr(Base(0),TpArr(TpArr(Base(0),Prop),TpArr(Base(0),TpArr(TpArr(Base(0),Prop),Prop)))),Prim(84),Lam(Base(0),Lam(TpArr(Base(0),Prop),Lam(Base(0),Lam(TpArr(Base(0),Prop),Ap(Ap(Prim(5),Ap(Ap(Prim(5),Ap(Ap(Ap(Prim(83),Ap(Ap(Prim(49),DB(3)),DB(1))),DB(2)),DB(0))),Ap(Ap(Prim(4),Ap(Ap(Prim(4),Ap(Ap(Prim(7),DB(3)),DB(1))),Ap(Ap(Ap(Prim(82),DB(3)),DB(2)),DB(0)))),Ap(DB(0),DB(3))))),Ap(Ap(Prim(4),Ap(Ap(Prim(4),Ap(Ap(Prim(7),DB(1)),DB(3))),Ap(Ap(Ap(Prim(82),DB(1)),DB(2)),DB(0)))),Ap(Prim(3),Ap(DB(2),DB(1))))))))));
Eq(TpArr(Base(0),TpArr(TpArr(Base(0),Prop),TpArr(Base(0),TpArr(TpArr(Base(0),Prop),Prop)))),Prim(85),Lam(Base(0),Lam(TpArr(Base(0),Prop),Lam(Base(0),Lam(TpArr(Base(0),Prop),Ap(Ap(Prim(5),Ap(Ap(Ap(Ap(Prim(84),DB(3)),DB(2)),DB(1)),DB(0))),Ap(Ap(Prim(4),Eq(Base(0),DB(3),DB(1))),Ap(Ap(Ap(Prim(82),DB(3)),DB(2)),DB(0)))))))));
Eq(TpArr(TpArr(Base(0),TpArr(TpArr(Base(0),Prop),Prop)),TpArr(Base(0),TpArr(TpArr(Base(0),Prop),Prop))),Prim(86),Lam(TpArr(Base(0),TpArr(TpArr(Base(0),Prop),Prop)),Lam(Base(0),Lam(TpArr(Base(0),Prop),Ex(Base(0),Ap(Ap(Prim(4),Ap(Prim(62),DB(0))),Ex(TpArr(Base(0),Prop),Ap(Ap(Prim(4),Ap(Ap(DB(4),DB(1)),DB(0))),Ap(Ap(Ap(Ap(Prim(85),DB(3)),DB(2)),DB(1)),DB(0))))))))));
Eq(TpArr(TpArr(Base(0),TpArr(TpArr(Base(0),Prop),Prop)),TpArr(Base(0),TpArr(TpArr(Base(0),Prop),Prop))),Prim(87),Lam(TpArr(Base(0),TpArr(TpArr(Base(0),Prop),Prop)),Lam(Base(0),Lam(TpArr(Base(0),Prop),Ex(Base(0),Ap(Ap(Prim(4),Ap(Prim(62),DB(0))),Ex(TpArr(Base(0),Prop),Ap(Ap(Prim(4),Ap(Ap(DB(4),DB(1)),DB(0))),Ap(Ap(Ap(Ap(Prim(85),DB(1)),DB(0)),DB(3)),DB(2))))))))));
Eq(TpArr(Base(0),Base(0)),Prim(88),Lam(Base(0),Ap(Ap(Prim(44),DB(0)),Ap(Ap(Prim(12),DB(0)),Lam(Base(0),Ap(Lam(Base(0),Ap(Ap(Prim(45),DB(0)),Ap(Prim(43),Ap(Prim(57),Prim(9))))),DB(0)))))));
Eq(TpArr(Base(0),TpArr(Base(0),Prop)),Prim(89),Lam(Base(0),Lam(Base(0),Ap(Ap(Prim(4),Ap(Ap(Prim(8),DB(0)),Ap(Prim(88),DB(1)))),All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(2)),Ap(Ap(Prim(38),Ap(Ap(Prim(7),Ap(Lam(Base(0),Ap(Ap(Prim(45),DB(0)),Ap(Prim(43),Ap(Prim(57),Prim(9))))),DB(0))),DB(1))),Ap(Ap(Prim(7),DB(0)),DB(1)))))))));
Eq(TpArr(Base(0),TpArr(TpArr(Base(0),Prop),Base(0))),Prim(90),Lam(Base(0),Lam(TpArr(Base(0),Prop),Ap(Ap(Prim(44),Ap(Ap(Prim(47),DB(1)),Lam(Base(0),Ap(DB(1),DB(0))))),Ap(Ap(Ap(Prim(48),DB(1)),Lam(Base(0),Ap(Prim(3),Ap(DB(1),DB(0))))),Lam(Base(0),Ap(Lam(Base(0),Ap(Ap(Prim(45),DB(0)),Ap(Prim(43),Ap(Prim(57),Prim(9))))),DB(0))))))));
Eq(TpArr(Base(0),Prop),Prim(91),Lam(Base(0),Ex(Base(0),Ap(Ap(Prim(4),Ap(Prim(62),DB(0))),Ap(Ap(Prim(89),DB(0)),DB(1))))));
Eq(TpArr(Base(0),Base(0)),Prim(92),Lam(Base(0),Ap(Prim(0),Lam(Base(0),Ap(Ap(Prim(4),Ap(Prim(62),DB(0))),Ap(Ap(Prim(89),DB(0)),DB(1)))))));
Eq(TpArr(Base(0),TpArr(Base(0),TpArr(Base(0),Prop))),Prim(93),Lam(Base(0),Lam(Base(0),Lam(Base(0),Ap(Ap(Ap(Prim(82),DB(2)),Lam(Base(0),Ap(Ap(Prim(7),DB(0)),DB(2)))),Lam(Base(0),Ap(Ap(Prim(7),DB(0)),DB(1))))))));
Eq(TpArr(Base(0),TpArr(Base(0),Prop)),Prim(94),Lam(Base(0),Lam(Base(0),Ap(Ap(Ap(Ap(Prim(84),Ap(Prim(92),DB(1))),Lam(Base(0),Ap(Ap(Prim(7),DB(0)),DB(2)))),Ap(Prim(92),DB(0))),Lam(Base(0),Ap(Ap(Prim(7),DB(0)),DB(1)))))));
Eq(TpArr(Base(0),TpArr(Base(0),Prop)),Prim(95),Lam(Base(0),Lam(Base(0),Ap(Ap(Ap(Ap(Prim(85),Ap(Prim(92),DB(1))),Lam(Base(0),Ap(Ap(Prim(7),DB(0)),DB(2)))),Ap(Prim(92),DB(0))),Lam(Base(0),Ap(Ap(Prim(7),DB(0)),DB(1)))))));
Eq(TpArr(Base(0),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),Prop)),Prim(96),Lam(Base(0),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(2)),All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(3)),Ap(Ap(Prim(7),Ap(Ap(DB(2),DB(1)),DB(0))),DB(3)))))))));
Eq(TpArr(Base(0),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),TpArr(Base(0),Prop))))),Prim(97),Lam(Base(0),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Lam(Base(0),Ap(Ap(Prim(4),Ap(Ap(Prim(4),Ap(Ap(Prim(4),Ap(Ap(Prim(4),Ap(Ap(Prim(96),DB(4)),DB(3))),Ap(Ap(Prim(96),DB(4)),DB(2)))),Ap(Ap(Prim(96),DB(4)),DB(1)))),All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(5)),Ap(Ap(Prim(4),Eq(Base(0),Ap(Ap(DB(4),DB(1)),DB(0)),DB(0))),Eq(Base(0),Ap(Ap(DB(4),DB(0)),DB(1)),DB(0))))))),All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(5)),All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(6)),Ap(Ap(Prim(4),Ap(Ap(Prim(4),Ap(Ap(Prim(4),Eq(Base(0),Ap(Ap(DB(4),DB(1)),Ap(Ap(DB(5),DB(1)),DB(0))),DB(0))),Eq(Base(0),Ap(Ap(DB(5),DB(1)),Ap(Ap(DB(4),DB(1)),DB(0))),DB(0)))),Eq(Base(0),Ap(Ap(DB(3),Ap(Ap(DB(5),DB(1)),DB(0))),DB(0)),DB(1)))),Eq(Base(0),Ap(Ap(DB(5),Ap(Ap(DB(3),DB(1)),DB(0))),DB(0)),DB(1))))))))))))));
Eq(TpArr(Base(0),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),TpArr(Base(0),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),TpArr(TpArr(Base(0),TpArr(Base(0),TpArr(Base(0),Base(0)))),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),TpArr(TpArr(Base(0),TpArr(Base(0),TpArr(Base(0),Base(0)))),TpArr(TpArr(Base(0),TpArr(Base(0),TpArr(Base(0),Base(0)))),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),Prop)))))))))))))),Prim(98),Lam(Base(0),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Lam(Base(0),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Lam(TpArr(Base(0),TpArr(Base(0),TpArr(Base(0),Base(0)))),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Lam(TpArr(Base(0),TpArr(Base(0),TpArr(Base(0),Base(0)))),Lam(TpArr(Base(0),TpArr(Base(0),TpArr(Base(0),Base(0)))),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Ap(Ap(Prim(4),Ap(Ap(Prim(4),Ap(Ap(Prim(4),Ap(Ap(Prim(4),Ap(Ap(Ap(Ap(Ap(Prim(97),DB(13)),DB(12)),DB(11)),DB(10)),DB(9))),All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(14)),All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(15)),Eq(Base(0),Ap(Ap(DB(10),DB(1)),DB(0)),Ap(Ap(DB(13),Ap(Ap(DB(14),DB(0)),DB(1))),Ap(Ap(DB(14),DB(1)),DB(0)))))))))),All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(14)),All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(15)),All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(16)),Eq(Base(0),Ap(Ap(Ap(DB(10),DB(2)),DB(1)),DB(0)),Ap(Ap(DB(14),Ap(Ap(DB(15),DB(2)),Ap(Ap(DB(15),DB(1)),DB(0)))),Ap(Ap(DB(15),Ap(Ap(DB(15),DB(2)),DB(1))),DB(0)))))))))))),All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(14)),All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(15)),Ap(Ap(Prim(4),Ap(Ap(Prim(4),Ap(Ap(Prim(4),Ap(Ap(Prim(4),Eq(Base(0),Ap(Ap(DB(8),DB(1)),DB(0)),Ap(Ap(DB(13),DB(1)),Ap(Ap(DB(14),DB(0)),DB(1))))),Eq(Base(0),Ap(Ap(DB(5),DB(1)),DB(0)),Ap(Ap(DB(14),DB(1)),Ap(Ap(DB(14),DB(0)),Ap(Ap(DB(13),DB(1)),DB(11))))))),Eq(Base(0),Ap(Ap(DB(4),DB(1)),DB(0)),Ap(Ap(DB(14),Ap(Ap(DB(14),Ap(Ap(DB(12),DB(11)),DB(1))),DB(0))),DB(1))))),Eq(Base(0),Ap(Ap(DB(3),DB(1)),DB(0)),Ap(Ap(DB(14),Ap(Ap(DB(13),DB(1)),DB(0))),Ap(Ap(DB(13),Ap(Ap(DB(13),DB(1)),DB(11))),DB(11)))))),Eq(Base(0),Ap(Ap(DB(2),DB(1)),DB(0)),Ap(Ap(DB(14),Ap(Ap(DB(12),DB(11)),Ap(Ap(DB(12),DB(11)),DB(1)))),Ap(Ap(DB(12),DB(0)),DB(1))))))))))),All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(14)),All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(15)),All(Base(0),Imp(Ap(Ap(Prim(7),DB(0)),DB(16)),Ap(Ap(Prim(4),Eq(Base(0),Ap(Ap(Ap(DB(8),DB(2)),DB(1)),DB(0)),Ap(Ap(DB(14),Ap(Ap(DB(15),DB(1)),DB(2))),Ap(Ap(DB(15),DB(1)),Ap(Ap(DB(15),DB(2)),DB(0)))))),Eq(Base(0),Ap(Ap(Ap(DB(7),DB(2)),DB(1)),DB(0)),Ap(Ap(DB(13),Ap(Ap(DB(15),Ap(Ap(DB(15),DB(0)),DB(2))),DB(1))),Ap(Ap(DB(15),DB(2)),DB(1)))))))))))))))))))))))))));
Eq(TpArr(Base(0),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),TpArr(Base(0),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),TpArr(TpArr(Base(0),TpArr(Base(0),TpArr(Base(0),Base(0)))),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),TpArr(TpArr(Base(0),TpArr(Base(0),TpArr(Base(0),Base(0)))),TpArr(TpArr(Base(0),TpArr(Base(0),TpArr(Base(0),Base(0)))),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),Prop)))))))))))))),Prim(99),Lam(Base(0),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Lam(Base(0),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Lam(TpArr(Base(0),TpArr(Base(0),TpArr(Base(0),Base(0)))),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Lam(TpArr(Base(0),TpArr(Base(0),TpArr(Base(0),Base(0)))),Lam(TpArr(Base(0),TpArr(Base(0),TpArr(Base(0),Base(0)))),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Ap(Ap(Prim(4),Ap(Ap(Ap(Ap(Ap(Ap(Ap(Ap(Ap(Ap(Ap(Ap(Ap(Ap(Prim(98),DB(13)),DB(12)),DB(11)),DB(10)),DB(9)),DB(8)),DB(7)),DB(6)),DB(5)),DB(4)),DB(3)),DB(2)),DB(1)),DB(0))),Ex(Base(0),Ap(Ap(Prim(4),Ap(Ap(Prim(7),DB(0)),DB(14))),Ex(Base(0),Ap(Ap(Prim(4),Ap(Ap(Prim(7),DB(0)),DB(15))),Ex(Base(0),Ap(Ap(Prim(4),Ap(Ap(Prim(7),DB(0)),DB(16))),Ex(Base(0),Ap(Ap(Prim(4),Ap(Ap(Prim(7),DB(0)),DB(17))),Ap(Prim(3),Eq(Base(0),Ap(Ap(DB(12),Ap(Ap(DB(16),Ap(Ap(DB(15),Ap(Ap(Ap(DB(9),DB(2)),DB(1)),DB(3))),DB(13))),DB(3))),DB(0)),DB(13)))))))))))))))))))))))))));
Eq(TpArr(Base(0),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),TpArr(Base(0),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),TpArr(TpArr(Base(0),TpArr(Base(0),TpArr(Base(0),Base(0)))),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),TpArr(TpArr(Base(0),TpArr(Base(0),TpArr(Base(0),Base(0)))),TpArr(TpArr(Base(0),TpArr(Base(0),TpArr(Base(0),Base(0)))),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),TpArr(TpArr(Base(0),TpArr(Base(0),Base(0))),Prop)))))))))))))),Prim(100),Lam(Base(0),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Lam(Base(0),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Lam(TpArr(Base(0),TpArr(Base(0),TpArr(Base(0),Base(0)))),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Lam(TpArr(Base(0),TpArr(Base(0),TpArr(Base(0),Base(0)))),Lam(TpArr(Base(0),TpArr(Base(0),TpArr(Base(0),Base(0)))),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Ap(Ap(Prim(4),Ap(Ap(Ap(Ap(Ap(Ap(Ap(Ap(Ap(Ap(Ap(Ap(Ap(Ap(Prim(98),DB(13)),DB(12)),DB(11)),DB(10)),DB(9)),DB(8)),DB(7)),DB(6)),DB(5)),DB(4)),DB(3)),DB(2)),DB(1)),DB(0))),Ex(Base(0),Ap(Ap(Prim(4),Ap(Ap(Prim(7),DB(0)),DB(14))),Ex(Base(0),Ap(Ap(Prim(4),Ap(Ap(Prim(7),DB(0)),DB(15))),Ex(Base(0),Ap(Ap(Prim(4),Ap(Ap(Prim(7),DB(0)),DB(16))),Ex(Base(0),Ap(Ap(Prim(4),Ap(Ap(Prim(7),DB(0)),DB(17))),Ex(Base(0),Ap(Ap(Prim(4),Ap(Ap(Prim(7),DB(0)),DB(18))),Ap(Prim(3),Eq(Base(0),Ap(Ap(Ap(DB(12),DB(0)),Ap(Ap(DB(17),Ap(Ap(DB(15),DB(14)),DB(4))),Ap(Ap(Ap(DB(9),DB(3)),DB(2)),DB(4)))),DB(1)),DB(14)))))))))))))))))))))))))))));
Eq(TpArr(Base(0),Prop),Prim(101),Lam(Base(0),All(TpArr(Base(0),Prop),Imp(Ap(DB(0),Ap(Prim(65),Prim(9))),Imp(Ap(DB(0),Ap(Prim(65),Ap(Prim(11),Prim(9)))),Imp(All(Base(0),All(Base(0),Imp(Ap(DB(2),DB(1)),Imp(Ap(DB(2),DB(0)),Ap(DB(2),Ap(Prim(64),Ap(Ap(Prim(68),DB(1)),DB(0)))))))),Ap(DB(0),DB(1))))))));
Eq(TpArr(Base(0),TpArr(Base(0),Prop)),Prim(102),Lam(Base(0),Lam(Base(0),All(TpArr(Base(0),TpArr(Base(0),Prop)),Ap(Ap(Ap(Lam(Base(0),Lam(Base(0),Lam(TpArr(Base(0),TpArr(Base(0),Base(0))),Imp(Ap(Prim(30),DB(3)),Imp(All(Base(0),Imp(Ap(Prim(101),DB(0)),Ap(Ap(DB(4),DB(0)),DB(0)))),Imp(All(Base(0),All(Base(0),All(Base(0),All(Base(0),Imp(Ap(Prim(101),DB(3)),Imp(Ap(Prim(101),DB(2)),Imp(Ap(Prim(101),DB(1)),Imp(Ap(Prim(101),DB(0)),Imp(Ap(Ap(DB(7),DB(3)),DB(1)),Imp(Ap(Ap(DB(7),DB(2)),DB(0)),Ap(Ap(DB(7),Ap(Ap(DB(4),DB(3)),DB(2))),Ap(Ap(DB(4),DB(1)),DB(0))))))))))))),Imp(All(Base(0),All(Base(0),Ap(Ap(DB(5),Ap(Ap(DB(2),Ap(Ap(DB(2),DB(4)),DB(1))),DB(0))),DB(1)))),Imp(All(Base(0),All(Base(0),All(Base(0),Ap(Ap(DB(6),Ap(Ap(DB(3),Ap(Ap(DB(3),Ap(Ap(DB(3),DB(4)),DB(2))),DB(1))),DB(0))),Ap(Ap(DB(3),Ap(Ap(DB(3),DB(2)),DB(0))),Ap(Ap(DB(3),DB(1)),DB(0))))))),Ap(Ap(DB(3),DB(5)),DB(4)))))))))),Ap(Prim(65),Prim(9))),Ap(Prim(65),Ap(Prim(11),Prim(9)))),Lam(Base(0),Lam(Base(0),Ap(Prim(64),Ap(Ap(Prim(68),DB(1)),DB(0))))))))));
Eq(TpArr(Base(0),TpArr(Base(0),TpArr(Base(0),Prop))),Prim(103),Lam(Base(0),Lam(Base(0),Lam(Base(0),Ex(Base(0),Ex(Base(0),Ap(Ap(Prim(5),Ap(Ap(Prim(4),Ap(Ap(Prim(54),Ap(Ap(Prim(68),DB(4)),DB(1))),DB(3))),Ap(Ap(Prim(54),Ap(Ap(Prim(73),DB(0)),DB(1))),DB(2)))),Ap(Ap(Prim(4),Ap(Ap(Prim(54),Ap(Ap(Prim(68),DB(3)),DB(1))),DB(4))),Ap(Ap(Prim(54),Ap(Ap(Prim(73),DB(0)),DB(1))),DB(2))))))))))]
;;

let axl = List.map string_of_term hfaxsprenorm;;
writel "primax" axl;;

