signature FinalThm =
sig
  type thm
  type tag
  type term
  type hol_type
  type 'a set   = 'a HOLset.set
  type depdisk  = (string * int) * ((string * int list) list)

  val kernelid : string

  (* proof logging *)  
  val proofing : bool ref

  datatype prule =
    pASSUME of term
  | prefl_nocheck of hol_type * term
  | pBETA_CONV of term
  | pABS of term * thm
  | pDISCH of term * thm
  | pMP of thm * thm
  | pSUBST of (term,thm) Lib.subst * term * thm
  | pINST_TYPE of (hol_type,hol_type) Lib.subst * thm
  | pALPHA of term * term
  | pMK_COMB of thm * thm
  | pAP_TERM of term * thm
  | pAP_THM of thm * term
  | pSYM of thm
  | pTRANS of thm * thm
  | pEQ_MP of thm * thm
  | pEQ_IMP_RULE_LEFT of thm
  | pEQ_IMP_RULE_RIGHT of thm
  | pINST of (term,term) Lib.subst * thm
  | pSPEC of term * thm
  | pGEN of term * thm
  | pGENL of term list * thm
  | pEXISTS of (term * term) * thm
  | pCHOOSE of (term * thm) * thm
  | pCONJ of thm * thm
  | pCONJUNCT1 of thm
  | pCONJUNCT2 of thm
  | pDISJ1 of thm * term
  | pDISJ2 of term * thm
  | pDISJ_CASES of thm * thm * thm
  | pNOT_INTRO of thm
  | pNOT_ELIM of thm
  | pCCONTR of term * thm
  | pBeta of thm
  | pMk_comb of thm
  | pMk_abs of thm
  | pGEN_ABS of term option * term list * thm
  | pmk_oracle_thm of term list * term
  | pmk_axiom_thm of term
  | pmk_defn_thm of term
  | pSpecialize of term * thm

  val prooflog : (thm * prule) list ref
  val ptrace_proof : thm -> prule -> unit
  
  val dest_pASSUME : prule -> term
  val dest_prefl_nocheck : prule -> hol_type * term
  val dest_pBETA_CONV : prule -> term
  val dest_pABS : prule -> term * thm
  val dest_pDISCH : prule -> term * thm
  val dest_pMP : prule -> thm * thm
  val dest_pSUBST : prule -> (term,thm) Lib.subst * term * thm
  val dest_pINST_TYPE : prule -> (hol_type,hol_type) Lib.subst * thm
  val dest_pALPHA : prule -> term * term
  val dest_pMK_COMB : prule -> thm * thm
  val dest_pAP_TERM : prule -> term * thm
  val dest_pAP_THM : prule -> thm * term
  val dest_pSYM : prule -> thm
  val dest_pTRANS : prule -> thm * thm
  val dest_pEQ_MP : prule -> thm * thm
  val dest_pEQ_IMP_RULE_LEFT : prule -> thm
  val dest_pEQ_IMP_RULE_RIGHT : prule -> thm
  val dest_pINST : prule -> (term,term) Lib.subst * thm
  val dest_pSPEC : prule -> term * thm
  val dest_pGEN : prule -> term * thm
  val dest_pGENL : prule -> term list * thm
  val dest_pEXISTS : prule -> (term * term) * thm
  val dest_pCHOOSE : prule -> (term * thm) * thm
  val dest_pCONJ : prule -> thm * thm
  val dest_pCONJUNCT1 : prule -> thm
  val dest_pCONJUNCT2 : prule -> thm
  val dest_pDISJ1 : prule -> thm * term
  val dest_pDISJ2 : prule -> term * thm
  val dest_pDISJ_CASES : prule -> thm * thm * thm
  val dest_pNOT_INTRO : prule -> thm
  val dest_pNOT_ELIM : prule -> thm
  val dest_pCCONTR : prule -> term * thm
  val dest_pBeta : prule -> thm
  val dest_pMk_comb : prule -> thm
  val dest_pMk_abs : prule -> thm
  val dest_pGEN_ABS : prule -> term option * term list * thm
  val dest_pmk_oracle_thm : prule -> term list * term
  val dest_pmk_axiom_thm : prule -> term
  val dest_pmk_defn_thm : prule -> term
  val dest_pSpecialize : prule -> term * thm 
  (* end proof logging *)



  (* Simple operations on the type of theorems *)

  val tag           : thm -> tag
  val hyp           : thm -> term list
  val hypset        : thm -> term set
  val concl         : thm -> term
  val dest_thm      : thm -> term list * term
  val thm_frees     : thm -> term list
  val hyp_frees     : thm -> term set
  val hyp_tyvars    : thm -> hol_type set


  (* The primitive rules of inference *)

  val ASSUME        : term -> thm
  val REFL          : term -> thm
  val BETA_CONV     : term -> thm
  val ABS           : term -> thm -> thm
  val DISCH         : term -> thm -> thm
  val MP            : thm -> thm -> thm
  val SUBST         : (term,thm)Lib.subst -> term -> thm -> thm
  val INST_TYPE     : (hol_type,hol_type)Lib.subst -> thm -> thm


  (* Now some derivable-but-primitive rules of inference *)


  (* Lambda calculus rules *)

  val ALPHA         : term -> term -> thm
  val MK_COMB       : thm * thm -> thm
  val AP_TERM       : term -> thm -> thm
  val AP_THM        : thm -> term -> thm


  (* Equality *)

  val SYM           : thm -> thm
  val TRANS         : thm -> thm -> thm
  val EQ_MP         : thm -> thm -> thm
  val EQ_IMP_RULE   : thm -> thm * thm


  (* Free variable instantiation *)

  val INST          : (term,term)Lib.subst -> thm -> thm


  (* Universal quantification *)

  val SPEC          : term -> thm -> thm
  val GEN           : term -> thm -> thm
  val GENL          : term list -> thm -> thm


  (* Existential quantification *)

  val EXISTS        : term * term -> thm -> thm
  val CHOOSE        : term * thm -> thm -> thm


  (* Conjunction *)

  val CONJ          : thm -> thm -> thm
  val CONJUNCT1     : thm -> thm
  val CONJUNCT2     : thm -> thm


  (* Disjunction *)

  val DISJ1         : thm -> term -> thm
  val DISJ2         : term -> thm -> thm
  val DISJ_CASES    : thm -> thm -> thm -> thm


  (* Negation *)

  val NOT_INTRO     : thm -> thm
  val NOT_ELIM      : thm -> thm
  val CCONTR        : term -> thm -> thm


  (* Computing with explicit substitutions *)

  val Beta          : thm -> thm
  val Mk_comb       : thm -> thm * thm * (thm -> thm -> thm)
  val Mk_abs        : thm -> term * thm * (thm -> thm)
  val Specialize    : term -> thm -> thm

  (* Multiple binders *)

  val GEN_ABS       : term option -> term list -> thm -> thm

  (* Oracle invocation *)

  val mk_thm        : term list * term -> thm
  val mk_oracle_thm : string -> term list * term -> thm
  val mk_axiom_thm  : (string Nonce.t * term) -> thm
  val add_tag       : tag * thm -> thm

  (* definitional rules of inference *)
  val prim_type_definition : {Thy : string, Tyop : string} * thm -> thm
  val prim_specification : string -> string list -> thm -> thm
  val gen_prim_specification : string -> thm -> string list * thm

  (* Fetching theorems from disk *)

  val disk_thm : (depdisk * string list) * term list -> thm

  (* Saving proof dependencies *)

  val save_dep : string -> thm -> thm

end;
