load "hfProofRule"; open aiLib hfLib hfProofTerm hfProofRule;

(* utils *)
show_assums := true; show_types := true;

fun ktm (n,tm:term) = (KnO ("D" ^ its n), HOLset.empty Term.compare, tm);
fun ktm0 tm = ktm (0,tm);
fun ktm1 tm = ktm (1,tm);
fun ktm2 tm = ktm (2,tm);
fun ktm3 tm = ktm (3,tm) ;
fun kgoal (n,(tml,tm:term)) = (KnO ("D" ^ its n),
  HOLset.fromList Term.compare tml,tm);

val set = alpha;
val x = mk_var ("_x_",set);
val y = mk_var ("_y_",set);
val v = mk_var ("_v_",set);
val p = mk_var ("_p_",bool);
val q = mk_var ("_q_",bool);
val P = mk_var ("_P_", mk_funtype (set,bool));
val Q = mk_var ("_Q_", mk_funtype (set,bool));
val px = mk_comb (P,x);
val qx = mk_comb (Q,x);
val py = mk_comb (P,y);
val qy = mk_comb (Q,y);
val R = mk_var ("_R_", list_mk_funtype ([set,set],bool));

(* ------------------------------------------------------------------------
   PRIMITIVE RULES
   ------------------------------------------------------------------------ *)

val (pf,asl,w) = pfASSUME p;

val seq = kgoal (0,([p],p));
val (pf,asl,w) = pfDISCH p seq;

val seq1 = ktm1 (mk_imp (p,q));
val seq2 = ktm2 p;
val (pf,asl,w) = pfMP seq1 seq2; 

val seq = ktm0 px;
val (pf,asl,w) = pfGEN x seq; 

val seq = ktm0 (mk_forall (x,px));
val (pf,asl,w) = pfSPEC y seq; 
  
val (pf,asl,w) = pfEXT (set,bool);

val seq = ktm0 (mk_comb (mk_abs (x,px),y));
val (pf,asl,w) = pfCONVERT_nocheck py seq;

val seq = ktm0 (mk_eq (p,mk_comb (mk_abs (x,px),y)));
val (pf,asl,w) = pfBeta seq;

val seq = ktm0 (mk_eq (x,y));
val (pf,asl,w) = pfEQ_UNFOLD seq;
val (pf',asl',w') = pfEQ_FOLD (pf,asl,w);

val seq = ktm0 (mk_exists (x,px));
val (pf,asl,w) = pfEX_UNFOLD seq;
val (pf',asl',w') = pfEX_FOLD (pf,asl,w);

val seq = pfDISCH px (pfASSUME px);
val (pf,asl,w) = pfINST_NOHYP [x |-> y] seq;

(* ------------------------------------------------------------------------
   DERIVED RULES
   ------------------------------------------------------------------------ *)

val seq = ktm0 (list_mk_comb (R,[x,y]));
val (pf,asl,w) = pfGENL [x,y] seq; 

val seq = ktm0 (mk_forall (x,px));
val (pf,asl,w) = pfSpecialize y seq; 

val seq = ktm0 py;
val (pf,asl,w) = pfEXISTS (mk_exists (x,px),y) seq;
val (pf,asl,w) = pfEXISTS_SIMPLE y seq;
val (pf,asl,w) = pfEXISTS (mk_exists (x,mk_eq (x,x)),x) (pfREFL x);

val lemEXISTS = ktm3 (list_mk_forall ([P,y], mk_imp (py, mk_exists (x, px))));
fun shEXISTS seq = pfMP (pfSPEC y (pfSPEC P lemEXISTS)) seq;

val seq1 = 
val seq2 =  seq1 seq;

val seq1 = ktm1 (mk_exists (x,px));
val seq2 = kgoal (2, ([py],q));
val (pf,asl,w) = pfCHOOSE (y,seq1) seq2;

(* ------------------------------------------------------------------------
   Rewriting with equality
   ------------------------------------------------------------------------ *)

val seqo = pfREFL x;
val seqo = pfBETA_CONV (mk_comb (mk_abs (x,px),y));
val seqo = pfALPHA (mk_forall (x,px)) (mk_forall (y,py));

val seqREFL = ktm0 (mk_forall (x,mk_eq (x,x)));
val seqo = pfSPEC y seqREFL;

val seq = ktm0 (mk_eq (x,y));
val (pf,asl,w) = pfLEIBNIZ seq; (* use Leibniz as a lemma *)


val seqeq = ktm0 (mk_eq (x,y));
val seqthm = ktm0 (list_mk_comb (R,[x,x]));
val (pf,asl,w) = pfSUBST_ONE (v,list_mk_comb (R,[x,v])) seqeq seqthm;
(* pfLEIBNIZL eql *)
val (pf,asl,w) = pfSUBST [v |-> seqeq] (list_mk_comb (R,[x,v])) seqthm;
val eq = ktm1 (mk_eq (px,qx))
val seq = ktm2 px;
val (pf,asl,w) = pfEQ_MP eq seq;

val seq = ktm0 (mk_eq (x,y));
val (pf,asl,w) = pfABS x seq;

val termo = (SOME universal);
val vl = [x,y];
val rxy = list_mk_comb (R,vl);
val ryx = list_mk_comb (R,rev vl);
val eq = ktm0 (mk_eq (px,py));
val (pf,asl,w) =  pfGEN_ABS termo vl eq;

(* ------------------------------------------------------------------------
   Others
   ------------------------------------------------------------------------ *)

val seq = ktm0 (mk_eq (x,y));
val seqAP_TERM = ktm0 (``!P x y. (x:hf$set) = y ==> (P x <=> P y)``);
val seq1 = pfSPEC y (pfSPEC x (pfSPEC P seqAP_TERM));
val seq2 = pfMP seq1 seq;

val seq2 = pfAP_TERM P seq;

val seq = ktm0 (mk_eq (P,Q));
val seq0 = ktm0 (``!P Q x:hf$set. P = Q ==> (P x <=> Q x)``);
val seq1 = pfSPEC x (pfSPEC Q (pfSPEC P seq0));
val seq2 = pfMP seq1 seq;

val (pf,asl,w) = pfAP_THM seq x;


end (* struct *)
