structure hfATP :> hfATP = 
struct

open HolKernel boolLib aiLib smlRedirect smlTimeout hfLib 
  hfProofRule hfProofTerm hfImportRaw hfAlign hfTheory holyHammer
 

val ERR = mk_HOL_ERR "hfATP"

(* ------------------------------------------------------------------------
   external ATP call
   ------------------------------------------------------------------------ *)

val thmidl =
  map (fn x => "hfTheory." ^ x) 
  (filter (String.isPrefix "ax") (map fst (DB.thms "hf")));
val proverl = [Eprover,Vampire,Z3];

fun fetch_thmid s = 
  let val (a,b) = split_string "Theory." s in DB.fetch a b end;

fun mini_lemma acc axl cj = case axl of
     [] => rev acc 
   | a :: m => if can (timeout 1.0 (METIS_PROVE (acc @ m))) cj 
               then mini_lemma acc m cj
               else mini_lemma (a :: acc) m cj;

fun hh_core cj = 
  let 
    val goal = ([],cj)
    val mem = !dep_flag
    val _ = dep_flag := true
    val _ = hh_pb proverl thmidl goal
    val _ = OS.Process.sleep (Time.fromReal 1.0)
    val _ = dep_flag := mem
  in
    if not (isSome (!parallel_result)) 
    then raise ERR "hh_core" "" 
    else mini_lemma [] (map fetch_thmid (valOf (!parallel_result))) cj
  end

(* ------------------------------------------------------------------------
   Minimizing number of equality theorems using Meson.
   Masking occurs in between.
   ------------------------------------------------------------------------ *)

fun is_hfconst tm = is_const tm andalso #Thy (dest_thy_const tm) = "hf"

fun cong_ax c = 
  let 
    val (tyl,_) = strip_type (type_of c)
    fun f i ty = 
      if ty <> ``:hf$set`` then raise ERR "cong_ax" "" else 
      mk_eq (mk_var ("x" ^ its i,ty), mk_var ("y" ^ its i,ty))
    val eql = mapi f tyl
  in
    GEN_ALL (DISCH_ALL (AP_TERM_LIST c (map ASSUME eql)))
  end

fun create_eql (axl,gencj) =
  let
    val (x,y,z) = (``x:hf$set``,``y:hf$set``,``z:hf$set``)
    val faketm = list_mk_conj (gencj :: (map concl axl))
    val hfcl = mk_term_set (find_terms is_hfconst faketm)
    val refl = GEN x (REFL x)
    val trans1 = TRANS (ASSUME (mk_eq (x,y))) (ASSUME (mk_eq (y,z)))
    val trans2 = 
      (GENL [x,y,z] o DISCH (mk_eq (x,y)) o DISCH (mk_eq (y,z))) trans1
  in
    refl :: trans2 :: map cong_ax hfcl
  end

fun mini_eql acc eql axl cj = case eql of
     [] => rev acc 
   | a :: m => if can (smlTimeout.timeout 1.0 (PROVE (
                 (map snd (acc @ m)) @ axl))) cj 
              then mini_eql acc m axl cj
              else mini_eql (a :: acc) m axl cj;

val eqi = ref 0;
val seteq = 
  mk_thy_const {Name = "=", Thy = "min", Ty = ``:hf$set -> hf$set -> bool``};

(* todo : axioms needs to be fofify before rewriting *)
fun minimize_eql (axl,gencj) eql =
  let 
    val proofmem = !prooflog
    val (x,y,z) = (``x:hf$set``,``y:hf$set``,``z:hf$set``)
    val eq = mk_var ("_eq" ^ its (!eqi), ``:hf$set -> hf$set -> bool``)
    val _ = incr eqi
    val alteq = new_definition ("alteq", mk_eq (eq,seteq))
    val alteqfof = AP_THM_LIST alteq [x,y]
    val gencj_uni = subst [{redex = seteq, residue = (lhs (concl alteq))}] gencj
    val axl_uni = map (REWRITE_RULE [alteqfof]) axl
    val eql_uni = map_assoc (REWRITE_RULE [SYM alteqfof]) eql
    val r = map fst (hidef (mini_eql [] eql_uni axl_uni) gencj_uni)
  in 
    prooflog := proofmem; r
  end


end (* struct *)
