structure hfCNF :> hfCNF =
struct

open HolKernel boolLib aiLib hfLib hfTheory hfLemTheory

val ERR = mk_HOL_ERR "hfCNF"

(* val th0 = ASSUME ``?x:hf$set. x <> y``; *)
val ski = ref 0
fun new_skrw tm =
  if not (is_exists tm) then raise ERR "new_skolemdef" "" else
  let 
    val lam = rand tm
    val fvl = free_vars_lr tm
    val name = "_sk" ^ its (!ski)
    val _ = incr ski;
    val sk = mk_var (name, type_of (list_mk_abs (fvl,lam)))
    val eq = mk_eq (sk, list_mk_abs (fvl,lam))
    val def = ASSUME eq
  in 
    CONV_RULE (RHS_CONV LIST_BETA_CONV) (AP_THM_LIST def fvl)
  end

fun skolem_imp th0 =
  let 
    val skrw = new_skrw (concl th0)
    val sktm = lhs (snd (strip_forall (concl skrw)))
    val sk = fst (strip_comb sktm)
    val th1 = SPEC sktm Eps_i_R2
    val tempv = mk_var ("_temp", type_of sktm)
    val template = subst_occs [[1,2]] [sktm |-> tempv] (concl th1)
    val th2 = SUBST [tempv |-> skrw] template th1
  in
    CONV_RULE (RATOR_CONV (RAND_CONV (QUANT_CONV BETA_CONV)) 
               THENC RAND_CONV BETA_CONV)
    th2
  end

fun ELIM_SKDEF th =  
  if exists is_skdef (hyp th)  
  then
    let 
      val skdef = valOf (List.find is_skdef (hyp th)) 
      val imp = DISCH skdef th
      val eq = fst (dest_imp (concl imp)) 
      val tha = SPEC (rhs eq) (GEN (lhs eq) imp)
      val thb = REFL (rhs eq)
    in
      ELIM_SKDEF (MP tha thb)
    end
  else th

val alli = ref 0
fun SPEC_FRESH thm = 
  let 
    val name = "_all" ^ its (!alli) 
    val sk = mk_var (name, ``:hf$set``)
  in
    incr alli; SPEC sk thm
  end

fun CNF_STEP th =
  let val w = concl th in
    if is_forall w then [SPEC_FRESH th]
    else if is_exists w then [MP (skolem_imp th) th]
    else if is_imp_only w then [UNDISCH th]
    else if is_conj w then [CONJUNCT1 th, CONJUNCT2 th]
    else if is_disj w then [MATCH_MP disjimp th]
    else if is_equiv w then [MATCH_MP equivconj th]
    else if is_neg w then 
      if is_forall (dest_neg w) then [HO_MATCH_MP notall th]
      else if is_exists (dest_neg w) then [HO_MATCH_MP notex th]
      else if is_imp_only (dest_neg w) then [MATCH_MP notimp th]
      else if is_conj (dest_neg w) then [MATCH_MP notconj th]
      else if is_disj (dest_neg w) then [MATCH_MP notdisj th]
      else if is_equiv (dest_neg w) then [MATCH_MP notequiv th]
      else if is_neg (dest_neg w) then [MATCH_MP notnot th]
      else [th]
    else [th]
  end

fun is_cnf cjo th = all is_lit (concl th :: acc_asl cjo th) 

fun SWAP cjo th = 
  let
    val asl = acc_asl cjo th
    val tm = valOf (List.find (not o is_lit) asl)
      handle Option => raise ERR "SWAP" 
        (String.concatWith " " (map term_to_string asl))
    val th1 = DISCH tm th
    val th2 = tryfind (fn x => MATCH_MP x th1) [swap1,swap2,swap3,swap4]
  in
    UNDISCH th2
  end

fun CNF_LOOP cjo thl = 
  if all (is_cnf cjo) thl then thl else
  let 
    val (thl1,thl2) = partition (is_cnf cjo) thl 
    fun f x = 
      let val x' = if is_lit (concl x) then SWAP cjo x else x in
        CNF_STEP x'
      end
    val thl3 = List.concat (map f thl2)    
  in
    thl1 @ CNF_LOOP cjo thl3
  end

(*
load "aiLib"; open aiLib;
load "hfCNF"; open hfCNF;
load "hfProof"; open hfProof;
load "hfTheory"; open hfTheory;
val ncj1 = mk_neg cj1;
val ax21fof = fofify_ax ax21;
val cl = CNF_LOOP (SOME ncj1) [ax21fof,ASSUME ncj1];
*)

end
