structure hfDep :> hfDep =
struct

open HolKernel boolLib aiLib hfLib hfProofTerm hfProofRule

val ERR = mk_HOL_ERR "hfDep"

fun rule_parents rule = case rule of
    pABS (_,th) => [th] 
  | pDISCH (_,th) => [th]
  | pMP (th1,th2) => [th1,th2]
  | pSUBST (oldsubst,template,th) => 
    let
      val fvs = Term.FVL [template] Term.empty_varset
      val subst = filter (fn {redex,residue} => HOLset.member (fvs,redex)) 
        oldsubst
    in
      th :: map #residue subst
    end
  | pINST_TYPE (_,th) => [th]
  | pMK_COMB (th1,th2) => [th1,th2]
  | pAP_TERM (_,th) => [th]
  | pAP_THM (th,_) => [th]
  | pSYM th => [th]
  | pTRANS (th1,th2) => [th1,th2]
  | pEQ_MP (th1,th2) => [th1,th2]
  | pEQ_IMP_RULE_LEFT th => [th]
  | pEQ_IMP_RULE_RIGHT th => [th]
  | pINST (_,th) => [th]
  | pSPEC (_,th) => [th]
  | pGEN (_,th) => [th]
  | pGENL (_,th) => [th]
  | pEXISTS (_,th) => [th]
  | pCHOOSE ((_,th1),th2) => [th1,th2]
  | pCONJ (th1,th2) => [th1,th2]
  | pCONJUNCT1 th => [th]
  | pCONJUNCT2 th => [th]
  | pDISJ1 (th,_) => [th]
  | pDISJ2 (_,th) => [th]
  | pDISJ_CASES (th1,th2,th3) => [th1,th2,th3]
  | pNOT_INTRO th => [th]
  | pNOT_ELIM th => [th]
  | pCCONTR (_,th) => [th]
  | pBeta th => [th]
  | pMk_comb th => [th]
  | pMk_abs th => [th]
  | pGEN_ABS (_,_,th) => [th]
  | pSpecialize (_,th) => [th]
  | _ => []

fun ben_parents logmap ben = 
  let val (thm,prule) = dfind ben logmap in 
    map ben_thm (rule_parents prule)
  end
  handle NotFound => (print_endline (string_of_goal ben); [])

fun benl_ancestry logmap benset benl =
  if null benl then benset else
  let
    val newbenset = HOLset.addList (benset,benl)
    val benl0 = List.concat (map (ben_parents logmap) benl)
    val benl1 = HOLset.listItems (HOLset.fromList goal_compare benl0)
    val benl2 = filter (fn x => not (HOLset.member (newbenset,x))) benl1
  in
    benl_ancestry logmap newbenset benl2 
  end

fun mk_sameorder_logset log =
  let
    val mem = ref (HOLset.empty goal_compare)
    fun f (thm,prule) = 
      let val ben = ben_thm thm in
        if HOLset.member (!mem,ben) then [] else 
        (mem := HOLset.add (!mem,ben); [(ben,(thm,prule))])
      end 
    val logset = List.concat (map f log) 
    val logmap = dnew goal_compare logset
  in
    (logset,logmap)
  end

(* choose the earliest proof *)
fun minimize_prooflog thyl thml log =
  let
    val axl = List.concat (map DB.thms thyl)
    val prelog = map 
      (fn (a,b) => (b, pmk_oracle_thm ([],mk_var (a,bool)))) axl 
    val (logset,logmap) = mk_sameorder_logset (prelog @ log)
    val benset = benl_ancestry logmap 
      (HOLset.empty goal_compare) (map ben_thm thml)     
    val newlogset = filter (fn x => HOLset.member (benset,fst x)) logset
    val _ = print_endline 
      ("HOL4 kernel steps: " ^ its (length newlogset))
  in
    map snd newlogset
  end

end (* struct *)

