structure hfDev :> hfDev =
struct

open HolKernel boolLib aiLib hfLib hfProofTerm hfProofRule hfCheck hfExport 
hfDep hfProof hfTheory

val ERR = mk_HOL_ERR "hfDev"

fun compute_pf (thm,minlog) =
  let
    val checkd = check_log (dempty goal_compare) minlog
    val _ = print_endline "building Proofgold proof term"
    val pf = dfind_pfd thm checkd
  in
    pf
  end

fun export_pf file (thm,pf) =
  let
    val newpf = rm_fv_in_pf (thm,pf)
    val _ = print_endline "exporting to raw format"
  in
    raw_pfg file (thm,newpf)
  end

fun export_lemma name thm =
  let val log = minimize_prooflog ["hf"] [thm] (rev (!prooflog)) in
    export_pf ("lemmas/" ^ name ^ ".s") (thm, compute_pf (thm, log))
  end

fun save_thm_export (name,thm) = 
  (export_lemma name thm; save_thm (name,thm))

end (* struct *)

