structure hfExport :> hfExport =
struct

open HolKernel boolLib aiLib hfLib hfProofTerm hfImportSexp hfFormat hfAlign 

val ERR = mk_HOL_ERR "hfExport"

val propi = ref 0

fun space l = String.concatWith " " l

val vard = ref (dempty String.compare)

fun name_var s = 
  if dmem s (!vard) then dfind s (!vard) else 
  let val xname = "X" ^ (its (dlength (!vard))) in
    vard := dadd s xname (!vard); xname 
  end

fun name_pfv s = "U" ^ s

val tydef = ref (dempty String.compare)
val constdef = ref (dempty String.compare)
val thmdef = ref (dempty String.compare)

fun raw_hfty ty = case ty of
    Base s => (tydef := dadd s () (!tydef); s) 
  | TpArr (a,b) => space ["TpArr", raw_hfty a, raw_hfty b] 
  | Prop => "Prop"

fun raw_hftm tm = case tm of
    Var s => name_var s
  | Const s => (constdef := dadd s () (!constdef); s)
  | Ap (t1,t2) => space ["Ap", raw_hftm t1, raw_hftm t2] 
  | Lam (s,ty,t) => space ["Lam", name_var s, raw_hfty ty, raw_hftm t] 
  | Imp (t1,t2) => space ["Imp", raw_hftm t1, raw_hftm t2] 
  | All (s,ty,t) => space ["All", name_var s, raw_hfty ty, raw_hftm t] 
  | Ex (s,ty,t) => space ["Ex", name_var s, raw_hfty ty, raw_hftm t] 
  | Eq (ty,t1,t2) => space ["Eq", raw_hfty ty, raw_hftm t1, raw_hftm t2] 

fun raw_hfpf pftop = case pftop of
    Known s => (thmdef := dadd s () (!thmdef); s)
  | PrVar s => name_pfv s
  | PrAp (pf1,pf2) => space ["PrAp", raw_hfpf pf1, raw_hfpf pf2] 
  | TmAp (pf,t) => space ["TmAp", raw_hfpf pf, raw_hftm t]
  | PrLa (s,t,pf) => space ["PrLa", name_pfv s, raw_hftm t, raw_hfpf pf]
  | TmLa (s,ty,pf) => space ["TmLa", name_var s, raw_hfty ty, raw_hfpf pf]
  | Ext (a,b) => space ["Ext", raw_hfty a, raw_hfty b] 

fun raw_constdef cs =
  if can (dfind cs) ctyd then
    let val tys = raw_hfty (dfind cs ctyd) in
      space ["Let",cs,":",tys,":=","Prim", its (dfind cs primnamed)]
    end
  else raise ERR "Undeclared" cs

fun raw_tydef tys = space ["Base",tys]

fun trydbfetch s = 
  DB.fetch "hf" s handle HOL_ERR _ => DB.fetch "hfLem" s

fun raw_thmdef thms = 
  if can trydbfetch thms then 
    let val thm = trydbfetch thms in
      space
      ["Known", thms, ":", raw_hftm (hf_term (concl thm))]
    end
  else raise ERR "Unknown" thms

val header = space ["Document",
  "6ffc9680fbe00a58d70cdeb319f11205ed998131ce51bb96f16c7904faf74a3d"]

fun raw_pfg filename (thm,pf) =
  let
    val _ = vard := dempty String.compare
    val _ = tydef := dempty String.compare
    val _ = constdef := dempty String.compare
    val _ = thmdef := dempty String.compare
    val (asl,w) = dest_thm thm
    val _ = if not (null asl) 
            then raise ERR "raw_pfg" "no assumption expected"
            else ()
    val _ = if has_free_vars pf orelse not (null (free_vars w))
            then raise ERR "raw_pfg" "free variables"
            else ()
    val r = space ["Thm", ("prop" ^ its (!propi)),":",
      raw_hftm (hf_term (concl thm)),":=", 
      split_pf 78 (raw_hfpf (hf_proof pf))]
    val _ = incr propi
    val thmdefl = map raw_thmdef (dkeys (!thmdef))
    val cdefl = map raw_constdef (dkeys (!constdef))
    val tydefl = map raw_tydef (dkeys (!tydef)) 
  in
    writel filename ([header] @ tydefl @ cdefl @ thmdefl @ [r])
  end


end (* struct *)

