signature hfFormat = 
sig

  include Abbrev

  datatype hftype =
      Base of string
    | TpArr of hftype * hftype
    | Prop

  datatype hfterm =
      Var of string
    | Const of string
    | Ap of hfterm * hfterm
    | Lam of string * hftype * hfterm
    | Imp of hfterm * hfterm
    | All of string * hftype * hfterm
    | Ex of string * hftype * hfterm
    | Eq of hftype * hfterm * hfterm

  datatype hfpf =
      Known of string
    | PrVar of string
    | PrAp of hfpf * hfpf
    | TmAp of hfpf * hfterm
    | PrLa of string * hfterm * hfpf
    | TmLa of string * hftype * hfpf
    | Ext of hftype * hftype

  val import_dir : string

end
