structure hfFormat :> hfFormat =
struct

open HolKernel boolLib aiLib

val ERR = mk_HOL_ERR "hfFormat"

(* ------------------------------------------------------------------------
   Logical AST
   ------------------------------------------------------------------------ *)

datatype hftype =
    Base of string
  | TpArr of hftype * hftype
  | Prop

datatype hfterm =
    Var of string
  | Const of string
  | Ap of hfterm * hfterm
  | Lam of string * hftype * hfterm
  | Imp of hfterm * hfterm
  | All of string * hftype * hfterm
  | Ex of string * hftype * hfterm
  | Eq of hftype * hfterm * hfterm

datatype hfpf =
    Known of string
  | PrVar of string
  | PrAp of hfpf * hfpf
  | TmAp of hfpf * hfterm
  | PrLa of string * hfterm * hfpf
  | TmLa of string * hftype * hfpf
  | Ext of hftype * hftype

(* ------------------------------------------------------------------------
   Human readable
   ------------------------------------------------------------------------ *)

fun human_hfty ty = case ty of
    Base s => s
  | TpArr (a,b) => "(" ^ human_hfty a ^ " > " ^ human_hfty b ^ ")" 
  | Prop => "o"

fun human_hftm tm = case tm of
    Var s => s
  | Const s => s
  | Ap (t1,t2) => "(" ^ human_hftm t1 ^ " " ^ human_hftm t2 ^ ")"
  | Lam (s,ty,t) => "(\\" ^ s ^ ":" ^ human_hfty ty ^ "." ^ human_hftm t ^ ")"
  | Imp (t1,t2) => "(" ^ human_hftm t1 ^ " -> " ^ human_hftm t2 ^ ")"
  | All (s,ty,t) => "(!" ^ s ^ ":" ^ human_hfty ty ^ "." ^ human_hftm t ^ ")"
  | Ex (s,ty,t) => "(?" ^ s ^ ":" ^ human_hfty ty ^ "." ^ human_hftm t ^ ")"
  | Eq (ty,t1,t2) => "(" ^ human_hftm t1 ^ " = " ^ human_hftm t2 ^ ")"

fun human_hfpf pftop = case pftop of
    Known s => s 
  | PrVar s => s
  | PrAp (pf1,pf2) => 
    "(" ^ human_hfpf pf1 ^ " " ^ human_hfpf pf2 ^ ")"
  | TmAp (pf,t) => 
    "(" ^ human_hfpf pf ^ " " ^ human_hftm t ^ ")"
  | PrLa (s,t,pf) => 
    "(\\" ^ s ^ ":" ^ human_hftm t ^ "." ^ human_hfpf pf ^ ")"
  | TmLa (s,ty,pf) => 
    "(\\" ^ s ^ ":" ^ human_hfty ty ^ "." ^ human_hfpf pf ^ ")"
  | Ext (a,b) => "(Ext " ^ human_hfty a ^ " " ^ human_hfty b ^ ")"


(* ------------------------------------------------------------------------
   Directories
   ------------------------------------------------------------------------ *)

val import_dir = "../import"

end
