structure hfImportRaw :> hfImportRaw =
struct

open HolKernel boolLib aiLib hfFormat hfImportSexp

val ERR = mk_HOL_ERR "hfImportRaw"

fun hf_rawty sl = case sl of
    [] => raise ERR "hf_rawty" ""
  | "Prop" :: m => (Prop,m) 
  | "TpArr" :: m => 
    let 
      val (ty1,cont1) = hf_rawty m
      val (ty2,cont2) = hf_rawty cont1
    in
      (TpArr (ty1,ty2), cont2)
    end
  | s :: m => (Base s, m) 

fun hf_rawtm vl sl = case sl of
    [] => raise ERR "hf_rawty" ""
  | "All" :: vs :: m => hf_rawquant All vs vl m
  | "Ex" :: vs :: m => hf_rawquant Ex vs vl m
  | "Imp" :: m => hf_rawbinop Imp vl m
  | "Lam" :: vs :: m => hf_rawquant Lam vs vl m
  | "Ap" :: m => hf_rawbinop Ap vl m
  | "Eq" :: m => hf_raweq vl m
  | "Prim" :: is :: m => (Const (Vector.sub (primnamev, string_to_int is)),m)
  | s :: m => (if mem s vl then Var s else Const s, m)
and hf_rawquant qop vs vl m = 
  let 
    val (ty,cont1) = hf_rawty m
    val (tm,cont2) = hf_rawtm (vs :: vl) cont1
  in
    (qop (vs,ty,tm), cont2)
  end
and hf_rawbinop binop vl m = 
  let
    val (tm1,cont1) = hf_rawtm vl m
    val (tm2,cont2) = hf_rawtm vl cont1
  in
    (binop (tm1,tm2), cont2)
  end
and hf_raweq vl m =
  let 
    val (ty,cont0) = hf_rawty m
    val (tm1,cont1) = hf_rawtm vl cont0
    val (tm2,cont2) = hf_rawtm vl cont1
  in
    (Eq (ty,tm1,tm2), cont2)
  end

fun read_rawtm_sl sl = 
  let
    val (hftm,rl) = hf_rawtm [] sl
    val _ = if not (null rl) 
      then raise ERR "read_raw" (String.concatWith " "  rl) else ()
  in
    hftm
  end

fun read_rawtm s = read_rawtm_sl (String.tokens Char.isSpace s)

fun read_rawlemma s =
  let 
    val sl = String.tokens Char.isSpace s
    val (sl1,sl2) = split_sl ":" sl
    val name = case sl1 of
        ["Known", b] => b
      | _ => raise ERR "read_rawlemma" ""
  in
    (name, read_rawtm_sl sl2)
  end

val random1dir = "../bounty/random1"

fun read_bounty file = 
  let 
    val sl = readl file 
    fun f s = 
      let val (a,b) = split_sl ":" (String.tokens Char.isSpace s) 
        handle HOL_ERR _ => ([],[]) in
        case a of
            ["Conj",_] => SOME (read_rawtm_sl b)
          | _ => NONE
      end
  in   
    singleton_of_list (List.mapPartial f sl)
  end


val pglemmal = mapfilter read_rawlemma (readl (import_dir ^ "/lemmas.pfg"))
val pglemmad = dnew String.compare pglemmal

val pglogicl = 
  let val logicl =      
    ["False_def", "True_def", "not_def","and_def","or_def","xm",
     "contra","andI","andEL","andER","orIL","orIR","orE","notE","notI"
     ,"Eps_i_R2","Eps_i_R"]
  in
    map (fn x => (x, dfind x pglemmad)) logicl
  end
(* 
load "hfImportRaw"; open aiLib hfFormat hfImportRaw;
*)

end (* struct *)

