structure hfImportSexp :> hfImportSexp =
struct

open HolKernel boolLib aiLib hfFormat

val ERR = mk_HOL_ERR "hfImportSexp"

(* ------------------------------------------------------------------------
   Names of primitive constants
   ------------------------------------------------------------------------ *)

val primnamel = readl (import_dir ^ "/primname");
val primnamev = Vector.fromList primnamel;
val primnamed = dnew String.compare (number_snd 0 primnamel)

(* ------------------------------------------------------------------------
   Alignment of primitive constants
   ------------------------------------------------------------------------ *)

val aligncl = [(F,"False"),(T,"True"),
  (negation,"not"),(conjunction,"and"),(disjunction,"or")]
val h4cd = dnew Term.compare aligncl
val hfcd = dnew String.compare (map swap aligncl)

(* ------------------------------------------------------------------------
   Types of primitive constants
   ------------------------------------------------------------------------ *)

fun hf_sexpty sexp = case sexp of
    Lterm [Lstring "Base", Lstring "0"] => Base "set"
  | Lterm [Lstring "TpArr",a,b] => TpArr (hf_sexpty a, hf_sexpty b)
  | Lterm [Lstring "Prop"] => Prop
  | _ => raise ERR "hf_sexpty" ""

val primtypel =
  let 
    val primtype1 = readl (import_dir ^ "/primtype");
    val primtype2 = map lisp_parser primtype1;
  in
    map (hf_sexpty o singleton_of_list) primtype2
  end

val ctyd = dnew String.compare (combine (primnamel,primtypel))

(* ------------------------------------------------------------------------
   Terms of primitive axioms
   ------------------------------------------------------------------------ *)

fun hf_sexptm vl sexp = case sexp of
    Lterm [Lstring "DB", Lstring i] => 
    Var (List.nth (vl,string_to_int i))
  | Lterm [Lstring "Prim", Lstring i] => 
    Const (Vector.sub (primnamev ,string_to_int i))
  | Lterm [Lstring "Ap",a,b] => 
    Ap (hf_sexptm vl a, hf_sexptm vl b)
  | Lterm [Lstring "Lam",ty,a] => 
    let val vs = "x" ^ its (length vl) in
      Lam (vs, hf_sexpty ty, hf_sexptm (vs :: vl) a)
    end
  | Lterm [Lstring "Imp",a,b] => 
    Imp (hf_sexptm vl a, hf_sexptm vl b)
  | Lterm [Lstring "All",ty,a] => 
    let val vs = "x" ^ its (length vl) in
      All (vs, hf_sexpty ty, hf_sexptm (vs :: vl) a)
    end
  | Lterm [Lstring "Ex",ty,a] =>
    let val vs = "x" ^ its (length vl) in
      Ex (vs, hf_sexpty ty, hf_sexptm (vs :: vl) a)
    end
  | Lterm [Lstring "Eq",ty,a,b] => 
    Eq (hf_sexpty ty, hf_sexptm vl a, hf_sexptm vl b)
  | _ => raise ERR "hf_sexptm" "";

val primaxl = 
  let 
    val primax1 = readl (import_dir ^ "/primax")
    val primax2 = map lisp_parser primax1
  in
    map (hf_sexptm [] o singleton_of_list) primax2
  end



end
