load "aiLib"; open aiLib;

(* 
mkdir lemmas
../../../HOL-log/bin/Holmake
rlwrap ../../../HOL-log/bin/hol
*)

val pfgdir = "/home/thibault/big/proofgold-0.1.10";

fun pfgcli cmd = 
  let 
    val cli = pfgdir ^ "/bin/proofgoldcli"
    val fullcmd = String.concatWith " " [cli,mlquote cmd,">","temp"] 
  in
    ignore (OS.Process.system fullcmd); aiLib.readl "temp"
  end;

val s = singleton_of_list (filter (String.isPrefix "Burned") sl);

val ERR = mk_HOL_ERR "test";

fun after_s s sl = case sl of
    [] => raise ERR "" ""
  | a :: m => if a = s then hd m else after_s s m;

fun split_block acc sl = case sl of
    [] => []
  | a :: m => (
    if String.isPrefix "block" a then 
      let val s1 = after_s "block" (String.tokens Char.isSpace a) in
        split_block [s1] m
      end
    else if String.isPrefix "Burned" a then 
      let
        val sl1 = String.tokens Char.isSpace a
        val (s1,s2) = (after_s "block" sl1, after_s "tx" sl1)
      in
        (acc @ [s1,s2]) :: split_block [] m
      end
    else split_block acc m)

(* 
load "hfImportRaw"; open hfImportRaw; 
load "hfAlign"; open hfAlign;
PolyML.print_depth 4;
*)

val sl = pfgcli "blockchain 2";
val blockl = rev (map triple_of_list (split_block [] sl));

fun block_bounty (s1,s2,s3) =
  let 
    val _ = pfgcli ("rewardbountyprop " ^ s2 ^ " " ^ s3 ^ " assembly");
    val cj = h4_term (read_bounty "temp");
  in
    (string_to_int s1, cj)
  end

val bountyl = map block_bounty blockl;


