structure hfLib :> hfLib =
struct

open HolKernel boolLib aiLib

val ERR = mk_HOL_ERR "hfLib"

fun mk_funtype (a,b) = mk_thy_type {Thy="min",Tyop="fun",Args=[a,b]};

fun list_mk_funtype (atyl,imty) = case atyl of
    [] => imty
  | a :: m => mk_funtype (a, list_mk_funtype (m,imty))

val rc = rand o concl

fun beta_conv_err t = beta_conv t handle HOL_ERR _ => t


(*
fun eta_conv_err t = eta_conv t handle HOL_ERR _ => t

fun eta_step tm = 
  if is_abs tm then 
    let val (v,bod) = dest_abs tm in
      eta_conv_err (mk_abs (v,eta_step bod))
    end
  else if is_comb tm then
    let val (a,b) = dest_comb tm in
      mk_comb (eta_step a, eta_step b)
    end
  else tm
*)

fun beta_step tm = 
  if is_abs tm then 
    let val (v,bod) = dest_abs tm in
      mk_abs (v, beta_step bod)
    end
  else if is_comb tm then
    let val (a,b) = dest_comb tm in
      beta_conv_err (mk_comb (beta_step a, beta_step b))
    end
  else tm

fun repeat_changed f tm =
  let val tm' = f tm in 
    if term_eq tm tm' then tm else repeat_changed f tm'
  end

(* does not do eta *)
fun betaeta_norm t = repeat_changed beta_step t

fun ben_thm thm = 
  let val (asl,w) = dest_thm thm in
    (map betaeta_norm asl, betaeta_norm w)
  end

(* fails if first head operator is not an abstraction *)
fun list_beta_conv tm = 
  if not (is_comb tm) then tm else
  let val (Rator,Rand) = dest_comb tm in
    if is_abs Rator
    then beta_conv tm
    else beta_conv (mk_comb (list_beta_conv Rator, Rand))
  end

fun thm_compare (a,b) = goal_compare (dest_thm a, dest_thm b)

fun is_equiv tm = is_eq tm andalso type_of (lhs tm) = bool

fun regroup_token acc (i,limit) sl = case sl of
    [] => [rev acc]
  | a :: m => 
    if i + String.size a >= limit
    then 
      if null acc 
      then rev (a :: acc) :: regroup_token [] (0,limit) m
      else rev acc :: regroup_token [] (0,limit) (a :: m)
    else regroup_token (a :: acc) (i + String.size a + 1, limit) m  

fun split_pf limit s =
  let 
    val sl = String.tokens Char.isSpace s 
    val sll = regroup_token [] (0,limit) sl
  in
    String.concatWith "\n" (map (String.concatWith " ") sll)  ^ "\n"  
  end

fun gen_all_lr x = list_mk_forall (free_vars_lr x,x)


fun is_atom x = 
  not (is_forall x orelse is_exists x orelse
  is_imp_only x orelse is_conj x orelse is_disj x orelse
  is_equiv x orelse is_neg x);

fun is_lit x = is_atom x orelse (is_neg x andalso is_atom (dest_neg x));

fun is_skdef tm = 
  is_eq tm andalso 
  is_var (lhs tm) andalso 
  String.isPrefix "_sk" (fst (dest_var (lhs tm)))
  
fun acc_asl start th =
  let 
    val asl1 =
      if isSome start andalso HOLset.member (hypset th,  valOf start)
      then HOLset.listItems (HOLset.delete (hypset th, valOf start)) 
      else HOLset.listItems (hypset th)
    val asl2 =  filter (not o is_skdef) asl1
  in
    asl2
  end   

fun fof_oper thm = 
  let val w = concl thm in
    if is_forall w then "all"
    else if is_exists w then "ex"
    else if is_imp_only w then "imp"
    else if is_conj w then "conj"
    else if is_disj w then "disj"
    else if is_equiv w then "equiv"
    else if is_neg w then 
      if is_forall (dest_neg w) then "nall"
      else if is_exists (dest_neg w) then "nex"
      else if is_conj (dest_neg w) then "nconj"
      else if is_disj (dest_neg w) then "ndisj"
      else if is_equiv (dest_neg w) then "nequiv"
      else if is_neg w then "nn"
      else raise ERR "" ""
    else raise ERR "" ""
  end;

fun GEN_ALL_LR th = GENL (free_vars_lr (concl th)) th;

fun AP_THM_LIST th tml = case tml of
    [] => th
  | a :: m => AP_THM_LIST (AP_THM th a) m

fun AP_TERM_LIST_aux tm thml = case thml of
    [] => REFL tm
  | a :: m => MK_COMB (AP_TERM_LIST_aux tm m, a) 

fun AP_TERM_LIST tm thml = AP_TERM_LIST_aux tm (rev thml)

fun expand_def def =
  let val (vl,_) = strip_abs (rhs (concl def)) in
    CONV_RULE (RHS_CONV LIST_BETA_CONV) (AP_THM_LIST def vl)
  end

fun fofify_ax ax =
  if not (is_eq (concl ax) andalso is_abs (rhs (concl ax))) 
  then ax 
  else expand_def ax


end
