structure hfMiner :> hfMiner = 
struct

open HolKernel boolLib aiLib hfLib 
  hfProofRule hfProofTerm 
  hfImportRaw hfTheory hfLemTheory hfAlign 
  hfDep hfCheck hfExport hfDev
  hfMask hfResolution hfCNF hfATP

val ERR = mk_HOL_ERR "hfMiner"

fun elim_locdef (cj,gencj) th = 
  let 
    val fin2 = ELIM_SKDEF th
    val fin3 = CCONTR gencj fin2
    val fin4 = GEN_ALL_LR fin3
    val fin5 = ELIM_GENDEF fin4
    val fin6 = CONV_RULE (REDEPTH_CONV BETA_CONV) fin5
  in
    if null (hyp fin6) andalso term_eq cj (concl fin6)
    then fin6
    else raise ERR "elim_alldef" ""
  end

fun auto_mine_cj fileout cj =
  let 
    val _ = print_endline "call holyhammer"
    val axl = hh_core cj
    val _ = print_endline "generalize conjecture"
    val gencj = gen_cj axl cj
    val _  = prooflog := [];
    val _ = print_endline "minimize equality lemmas"
    val eql = create_eql (axl,gencj)
    val mineql =  minimize_eql (axl,gencj) eql
    val _ = print_endline (its (length mineql) ^ " equality lemmas")
    val  _ = print_endline "expand axiom definitions"
    val axlfof = map (GEN_ALL_LR o fofify_ax) axl  
    val ncj = mk_neg gencj
    val ncjo = SOME ncj
    val _ = print_endline "convert to cnf"
    val clausel = CNF_LOOP ncjo (ASSUME ncj :: (axlfof @ mineql))
    val _ = print_endline (its (length clausel) ^ " clauses")
    val _ = print_endline "prove by resolution"
    val resthm = search_pb 10000 ncjo clausel
    val _ = print_endline "eliminate local definitions"
    val finalthm = elim_locdef (cj,gencj) resthm
    val _ = print_endline "extract hol4 kernel steps"
    val log = minimize_prooflog ["hf","hfLem"] [finalthm] (rev (!prooflog))
    val _ = print_endline "produce proofgold proof term"
    val pf = compute_pf (finalthm,log)
    val _ = print_endline ("exporting proof to: " ^ fileout)
  in
    export_pf fileout (finalthm,pf)
  end


fun auto_mine file =
  let 
    val _ = print_endline "read bounty"
    val fileout = OS.Path.dir file ^ "_proofs/" ^ OS.Path.file file
    val cj = h4_term (read_bounty file)
  in
    auto_mine_cj fileout cj 
  end


end (* struct *)
