structure hfProof :> hfProof =
struct

open HolKernel boolLib aiLib hfLib hfProofRule 
hfImportRaw hfProofTerm hfCheck hfTheory hfAlign

val ERR = mk_HOL_ERR "hfProof"

(* ------------------------------------------------------------------------
   Utils
   ------------------------------------------------------------------------ *)

val beta = CONV_RULE (ONCE_DEPTH_CONV BETA_CONV);
val set = ``:hf$set``;

(* ------------------------------------------------------------------------
   Importing conjecture
   ------------------------------------------------------------------------ *)

val rawcj =
  "All X0 set Imp All X1 set Ap nat_p X1 All X1 set Imp Ap Ap In X1 X0 Ex X2 set Imp Ex X3 set Ap Ap and Ap Ap Subq X3 X2 Ex X4 set Ap Ap and Ap exactly2 Ap Ap binrep Ap Power Ap Power Ap Power Empty Empty Ap not Ap atleast4 Ap Power Empty All X3 set Imp Ap atleast5 Ap Union Empty Ap atleast4 X2";
val hfcj = read_rawtm rawcj;
val cj1 = h4_term hfcj;

(* ------------------------------------------------------------------------
   Extracting subterms
   ------------------------------------------------------------------------ *)

val (x0,bod0) = dest_forall cj1;
val (imp0a,imp0b) = dest_imp bod0;
val (x1,bod1) = dest_forall imp0b;
val (imp1a,imp1b) = dest_imp bod1;
val (x2,bod2) = dest_exists imp1b;
val (imp2a,imp2b) = dest_imp bod2;
val (x3,bod3) = dest_forall imp2b;
val (imp3a,imp3b) = dest_imp bod3;

(* ------------------------------------------------------------------------
   Lemma and rules
   ------------------------------------------------------------------------ *)

fun EX_ALL newv thm = 
  let
    val (x,px) = dest_exists (concl thm)
    val th1 = GEN newv (ASSUME px)
    val th2 = EXISTS (mk_exists (x,concl th1),x) th1
  in
    CHOOSE (x,thm) th2
  end

fun EX_ADD_IMP q thm =
  let 
    val (x,px) = dest_exists (concl thm)
    val qx = mk_comb (q,x)
    val asm1 = DISCH qx (ADD_ASSUM qx (ASSUME px))
    val asm2 = EXISTS (mk_exists (x,concl asm1),x) asm1
  in
    beta (CHOOSE (x,thm) asm2)
  end

fun ALL_ADD_IMP q thm =
  let 
    val (x,px) = dest_forall (concl thm)
    val th1 = SPEC x thm
    val th2 = ADD_ASSUM (mk_comb (q,x)) th1
  in
    beta (GEN x (DISCH (mk_comb (q,x)) th2))
  end

(* ------------------------------------------------------------------------
   Proofs
   ------------------------------------------------------------------------ *)

fun proof1 cj =
  let 
    val right_exists_imp =
      let 
        val q = genvar bool
        val p = genvar (mk_funtype (set,bool))
        val x = genvar set
        val asm1 = mk_imp (q,mk_exists (x,mk_comb (p,x)))
        val thm11 = ASSUME asm1
        val thm12 = ASSUME q
        val thm13 = MP thm11 thm12
        val thm14 = EX_ADD_IMP (mk_abs (x,q)) thm13
        val thm15 = NOT_ELIM (ASSUME (mk_neg q))
        val thm16 = EQ_MP False_def (UNDISCH thm15)
        val thm17 = DISCH q (SPEC (mk_comb (p,x)) thm16)
        val thm18 = SIMPLE_EXISTS x thm17
        val thm19 = DISJ_CASES (SPEC q xm) thm14 thm18
      in
        GENL [q,p] (DISCH_ALL thm19)
      end
    fun EX_MOVE_BACK thm =
      let 
        val (q,bod) = dest_imp (concl thm)
        val (x,px) = dest_exists bod
        val p = mk_abs (x,px)
        val th1 = beta (SPECL [q,p] right_exists_imp)
      in
        MP th1 thm
      end
    val thm1 = ASSUME imp3a;
    val thm2 = AP_THM ax21 (rand imp3a);
    val thm3 = EQ_MP thm2 thm1;
    val thm4 = BETA_RULE thm3;
    val (x,px) = dest_exists (concl thm4);
    val thm5 = CONJUNCT2 (CONJUNCT2 (ASSUME px));
    val thm6 = EXISTS (mk_exists (x,concl thm5),x) thm5;
    val thm7 = CHOOSE (x, thm4) thm6;
    val thm8 = DISCH imp3a thm7;
    val thm9 = EX_ALL x3 (EX_MOVE_BACK thm8);
    val thm10 = EX_ADD_IMP (mk_abs (x2,imp2a)) thm9;
    val thm11 = ALL_ADD_IMP (mk_abs (x1,imp1a)) (GEN x1 thm10);
    val thm12 = ALL_ADD_IMP (mk_abs (x0,imp0a)) (GEN x0 thm11)
  in
    if null (hyp thm12) andalso term_eq (concl thm12) cj
    then thm12
    else raise ERR "proof1" "theorem does not match conjecture" 
  end





end


