signature hfProofRule = 
sig
  include Abbrev

  type seq = hfProofTerm.pf * term HOLset.set * term

  val last_rules : string list ref
  val pfKnO : string -> hfProofTerm.pf

  (* Primitives *)
  val pfASSUME : term -> seq
  val pfEXT : hol_type * hol_type -> seq

  val pfDISCH : term -> seq -> seq
  val pfMP_ONLY : seq -> seq -> seq
  val pfGEN : term -> seq -> seq
  val pfSPEC : term -> seq -> seq
  
  val pfCONVERT_nocheck : term -> seq -> seq
  val pfBeta : seq -> seq

  val pfEQ_FOLD : seq -> seq
  val pfEQ_UNFOLD : seq -> seq
  val pfEX_FOLD : seq -> seq
  val pfEX_UNFOLD : seq -> seq

  val pfINST_NOHYP : (term, term) Lib.subst -> seq -> seq
  val pfINST_TYPE_NOHYP : (hol_type, hol_type) Lib.subst -> seq -> seq

  (* Derived *)
  val pfDISCHL : term list -> seq -> seq
  val pfUNDISCH : seq -> seq
  val pfUNDISCHN : int -> seq -> seq
  
  val pfGENL : term list -> seq -> seq
  val pfSpecialize : term -> seq -> seq
  val pfSPECL : term list -> seq -> seq
  val pfEXISTS : term * term -> seq -> seq  
  val pfCHOOSE : term * seq -> seq -> seq
  val pfINST : (term, term) Lib.subst -> seq -> seq
  val pfINST_TYPE : (hol_type, hol_type) Lib.subst -> seq -> seq

  val pfREFL : term -> seq
  val pfBETA_CONV : term -> seq 
  val pfALPHA : term -> term -> seq
  val pfETA_AX : seq
  
  val pfLEIBNIZ : seq -> seq
  val pfSUBST_ONE : term * term -> seq -> seq -> seq
  val pfLEIBNIZL : seq list -> seq
  val pfSUBST : (term, seq) Lib.subst -> term -> seq -> seq

  val pfEQ_MP : seq -> seq -> seq
  val pfAP_TERM : term -> seq -> seq
  val pfAP_THM : seq -> term -> seq
  val pfSYM : seq -> seq
  val pfTRANS : seq -> seq -> seq  
  val pfMK_COMB : seq -> seq -> seq
  val pfEQ_IMP_RULE_LEFT : seq -> seq
  val pfEQ_IMP_RULE_RIGHT : seq -> seq

  val pfABS : term -> seq -> seq 
  val pfGEN_ABS : term option -> term list -> seq -> seq

  val pfCONJ : seq -> seq -> seq
  val pfCONJUNCT1 : seq -> seq
  val pfCONJUNCT2 : seq -> seq
  val pfDISJ1 : seq -> term -> seq
  val pfDISJ2 : term -> seq -> seq
  val pfDISJ_CASES : seq -> seq -> seq -> seq
  val pfNOT_INTRO : seq -> seq
  val pfNOT_ELIM : seq -> seq
  val pfMP : seq -> seq -> seq 
  val pfCCONTR : term -> seq -> seq

  (* Shorter proofs from lemmas *) 
  val shREFL : term -> seq
  val shBETA_CONV : term -> seq 
  val shALPHA : term -> term -> seq
  val shETA_AX : seq
  
  val shLEIBNIZ : seq -> seq
  val shSUBST_ONE : term * term -> seq -> seq -> seq
  val shLEIBNIZL : seq list -> seq
  val shSUBST : (term, seq) Lib.subst -> term -> seq -> seq

  val shEQ_MP : seq -> seq -> seq
  val shAP_TERM : term -> seq -> seq
  val shAP_THM : seq -> term -> seq
  val shSYM : seq -> seq
  val shTRANS : seq -> seq -> seq  
  val shMK_COMB : seq -> seq -> seq
  val shEQ_IMP_RULE_LEFT : seq -> seq
  val shEQ_IMP_RULE_RIGHT : seq -> seq




end
