signature hfProofTerm = 
sig

  include Abbrev

  datatype pf =
    KnO of string
  | PrV of int
  | PrA of pf * pf
  | TmA of pf * term
  | PrL of int * term * pf
  | TmL of term (* var *) * pf
  | ExT of hol_type * hol_type

  val human_pf : pf -> string

  val pfvd_global : (term,int) Redblackmap.dict ref
  val gen_pfv : term -> int
  val human_pfvl : (term * int) list -> string 
  val pf_size : pf -> int
  val pfsubst_term : (term, term) Term.subst -> pf -> pf
  val pfsubst_type : (hol_type, hol_type) Term.subst -> pf -> pf
  val has_free_vars : pf -> bool
  val pf_find_term : (term -> bool) -> pf -> bool
  val free_vars_pf : pf -> term list  
  val pf_subterms : (pf * (term, int) Redblackmap.dict) -> 
    (term, int) Redblackmap.dict

end
