(* ========================================================================= *)
(* FILE          : proofgold_tutorial.sml                                    *)
(* DESCRIPTION   : copy the following commands in an interactive sessions    *)
(*  HOL4 as interface to Proofgold HF theory                                 *)
(* AUTHOR        : Thibault Gauthier, Czech Technical University             *)
(* DATE          : 2021                                                      *)
(* ========================================================================= *)

load "hfProofRule"; open hfProofRule;
load "hfProofTerm"; open hfProofTerm;
load "hfCheck"; open hfCheck;
load "hfProof"; open hfProof;
load "aiLib"; open aiLib;
load "hfLib"; open hfLib;
load "hfCNF"; open hfCNF;
load "hfExport"; open hfExport;
load "hfTheory"; open hfTheory;
load "hfDep"; open hfDep;
load "hfDev"; open hfDev;
load "mlTacticData"; open mlTacticData;
load "hfProofRule"; open hfProofRule;
load "hfATP"; open hfATP;
load "hfMask"; open hfMask;
load "hfMiner"; open hfMiner;
load "hfResolution"; open hfResolution;
mlibUseful.trace_level := 0; mesonLib.chatting := 0;
show_assums := true;

(* --------------------------------------------------------------------------
   List of theorems available in the hfTheory
   ------------------------------------------------------------------------- *)

val hf_thml = DB.thms "hf";

(* --------------------------------------------------------------------------
   Manual proof
   ------------------------------------------------------------------------- *)

val bounty = hd (import_terml "zcjproven");
(* you can also try your luck on other elements of this list *) 

(* HOL4 proof *)
val (x0,bod0) = dest_exists bounty;
val (imp0a,imp0b) = dest_conj bod0;
val (x1,bod1) = dest_forall imp0b;
val (imp1a,imp1b) = dest_imp bod1;
val p4 = rand imp0a;

prooflog := []; 
val th1 = AP_THM (AP_THM ax16 p4) p4;
val th2 = CONV_RULE (RAND_CONV LIST_BETA_CONV) th1;
val th3 = ASSUME (mk_comb (``hf$In x2``, p4));
val th4 = GEN ``x2: hf$set`` (DISCH_ALL th3);
val th5 = EQ_MP (SYM th2) th4;
val th6 = REFL ``X1 :hf$set``;
val th7 = DISCH_ALL (ADD_ASSUM imp1a th6);
val th8 = SPEC p4 (GEN ``X0 :hf$set`` th7);
val th9 = CONJ th5 (GEN ``X1 :hf$set`` th8);
val finalthm = EXISTS (bounty,p4) th9;

(* exporting the proofgold proof term *) 
let
  val log = minimize_prooflog ["hf"] [finalthm] (rev (!prooflog))
  val pf = compute_pf (finalthm,log) 
in 
  export_pf "manual_proof.pfg" (finalthm,pf)
end;

(* --------------------------------------------------------------------------
   Automated proof for first-order bounties (all in one)
   ------------------------------------------------------------------------- *)

val bounty = hd (import_terml "zcjproven"); 
(* you can also try your luck on other elements of this list *)

(* requires the binary of eprover vampire z3 to be installed in HOL-pfg/
   holyHammer/provers
   linux binaries are included in this package *)
auto_mine_cj "automated_proof.pfg" bounty;

