;; sequence(s): A3816
;; terms: 0 1 ~1 4 0 5 ~1 8 0 9 ~1 12 0 13 ~1 16 0 17 ~1 20
;; small program: loop(if x <= 0 then (y - x) else (x - y), x, 0)
;; fast program: (0 - (((1 + x) div 2) mod 2)) + ((x mod 2) * (1 + x))
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun h0 () Int)
(declare-fun u0 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun fast (Int) Int)
(assert (forall ((x Int) (y Int)) (= (f0 x y) (ite (<= x 0) (- y x) (- x y)))))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (= h0 0))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (small x) (v0 x))))
(assert (forall ((x Int)) (= (fast x) (+ (- 0 (mod (div (+ 1 x) 2) 2)) (* (mod x 2) (+ 1 x))))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
