;; sequence(s): A70470
;; terms: 0 1 4 9 16 25 36 1 16 33 4 25 0 25 4 33 16 1 36 25
;; small program: (x * x) mod loop((x + y) * x, 2, 2)
;; fast program: (x * x) mod (2 * (2 * (2 * (2 + (2 + 2)))))
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun g0 () Int)
(declare-fun h0 () Int)
(declare-fun u0 (Int Int) Int)
(declare-fun v0 () Int)
(declare-fun small (Int) Int)
(declare-fun fast (Int) Int)
(assert (forall ((x Int) (y Int)) (= (f0 x y) (* (+ x y) x))))
(assert (= g0 2))
(assert (= h0 2))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (= v0 (u0 g0 h0)))
(assert (forall ((x Int)) (= (small x) (mod (* x x) v0))))
(assert (forall ((x Int)) (= (fast x) (mod (* x x) (* 2 (* 2 (* 2 (+ 2 (+ 2 2)))))))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
