;; small program: ((x mod 2) + (loop (if (x mod (2 + 2)) <= 0 then 1 else (x div 2)) x x))
;; K C H K C C D H B K C G I K K J D
;; fast program: ((((loop ((if (x mod (2 + 2)) <= 0 then 2 else x) div 2) (2 + (2 + 2)) x) + x) mod 2) + (x mod 2))
;; K C C D H C K I C G C C C D D K J K D C H K C H D
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 () Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (h0 x) x)))
(assert (forall ((x Int)) (= (h1 x) x)))
(assert (= g1 (+ 2 (+ 2 2))))
(assert (forall ((x Int)) (= (f1 x) (divf (ite (<= (modf x (+ 2 2)) 0) 2 x) 2))))
(assert (forall ((x Int)) (= (f0 x) (ite (<= (modf x (+ 2 2)) 0) 1 (divf x 2)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) (h0 x)))))
(assert (forall ((x Int)) (= (small x) (+ (modf x 2) (v0 x)))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 g1 (h1 x)))))
(assert (forall ((x Int)) (= (fast x) (+ (modf (+ (v1 x) x) 2) (modf x 2)))))
(assert (=> (forall ((x Int)) (= (f0 x) (f1 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
