;; small program: (1 + (2 * (2 * ((loop (x * x) x 2) div (1 + 2)))))
;; B C C K K F K C J B C D G F F D
;; fast program: (((loop (x * x) x 2) * (2 + (if (x * x) <= 0 then x else 2))) div (1 + 2))
;; K K F K C J C K K F K C I D F B C D G
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun h0 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun v0 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(assert (= h0 2))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (f0 x) (* x x))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (small x) (+ 1 (* 2 (* 2 (divf (v0 x) (+ 1 2))))))))
(assert (forall ((x Int)) (= (fast x) (divf (* (v0 x) (+ 2 (ite (<= (* x x) 0) x 2))) (+ 1 2)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (u0 x y))))
(assert (=> (forall ((x Int)) (= (f0 x) (f0 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u0 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
