;; small program: ((1 + (loop (y mod 2) (x mod (2 + 2)) (2 + (2 * (2 + 2))))) * (if x <= 0 then 1 else 2))
;; B L C H K C C D H C C C C D F D J D K B C I F
;; fast program: ((1 + (loop (2 + (2 * (2 + 2))) (1 - (x mod (2 + 2))) (x mod 2))) * (if x <= 0 then 1 else 2))
;; B C C C C D F D B K C C D H E K C H J D K B C I F
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 () Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (modf y 2))))
(assert (forall ((x Int)) (= (h1 x) (modf x 2))))
(assert (forall ((x Int)) (= (g0 x) (modf x (+ 2 2)))))
(assert (= f1 (+ 2 (* 2 (+ 2 2)))))
(assert (= h0 (+ 2 (* 2 (+ 2 2)))))
(assert (forall ((x Int)) (= (g1 x) (- 1 (modf x (+ 2 2))))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y f1))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) (h1 x)))))
(assert (forall ((x Int)) (= (small x) (* (+ 1 (v0 x)) (ite (<= x 0) 1 2)))))
(assert (forall ((x Int)) (= (fast x) (* (+ 1 (v1 x)) (ite (<= x 0) 1 2)))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) f1)) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
