;; small program: (if ((1 + x) mod (2 + (2 * (2 + 2)))) <= 0 then (loop (x + y) (2 + 2) x) else x)
;; B K D C C C C D F D H K L D C C D K J K I
;; fast program: (loop (((if ((1 + x) mod (1 + (2 + 2))) <= 0 then (1 + (2 + 2)) else 0) * 2) + x) (x mod 2) x)
;; B K D B C C D D H B C C D D A I C F K D K C H K J
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (forall ((x Int)) (= (h0 x) x)))
(assert (forall ((x Int)) (= (h1 x) x)))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (+ x y))))
(assert (= g0 (+ 2 2)))
(assert (forall ((x Int)) (= (g1 x) (modf x 2))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 g0 (h0 x)))))
(assert (forall ((x Int)) (= (f1 x) (+ (* (ite (<= (modf (+ 1 x) (+ 1 (+ 2 2))) 0) (+ 1 (+ 2 2)) 0) 2) x))))
(assert (forall ((x Int)) (= (small x) (ite (<= (modf (+ 1 x) (+ 2 (* 2 (+ 2 2)))) 0) (v0 x) x))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) (h1 x)))))
(assert (forall ((x Int)) (= (fast x) (v1 x))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f1 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
