;; small program: ((loop (x div (if (x mod (1 + 2)) <= 0 then (1 + 2) else 1)) 2 x) div (2 - (x mod 2)))
;; K K B C D H B C D B I G C K J C K C H E G
;; fast program: (loop (if (x mod (1 + 2)) <= 0 then (x div (1 + 2)) else x) 2 (loop (x div 2) (1 - (x mod 2)) x))
;; K B C D H K B C D G K I C K C G B K C H E K J J
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun f2 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun g1 () Int)
(declare-fun g2 (Int) Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 (Int) Int)
(declare-fun h2 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(declare-fun v2 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= g0 2))
(assert (= g1 2))
(assert (forall ((x Int)) (= (h0 x) x)))
(assert (forall ((x Int)) (= (h2 x) x)))
(assert (forall ((x Int)) (= (f2 x) (divf x 2))))
(assert (forall ((x Int)) (= (g2 x) (- 1 (modf x 2)))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y))))))
(assert (forall ((x Int)) (= (v2 x) (u2 (g2 x) (h2 x)))))
(assert (forall ((x Int)) (= (h1 x) (v2 x))))
(assert (forall ((x Int)) (= (f0 x) (divf x (ite (<= (modf x (+ 1 2)) 0) (+ 1 2) 1)))))
(assert (forall ((x Int)) (= (f1 x) (ite (<= (modf x (+ 1 2)) 0) (divf x (+ 1 2)) x))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 g0 (h0 x)))))
(assert (forall ((x Int)) (= (small x) (divf (v0 x) (- 2 (modf x 2))))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (forall ((x Int)) (= (v1 x) (u1 g1 (h1 x)))))
(assert (forall ((x Int)) (= (fast x) (v1 x))))
(assert (=> (forall ((x Int)) (= (f0 x) (f1 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (=> (forall ((x Int)) (= (f0 x) (f2 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u2 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
