;; small program: (1 + (2 * (loop 0 (x mod (1 + (2 + (2 + 2)))) (1 + 2))))
;; B C A K B C C C D D D H B C D J F D
;; fast program: (loop (1 + (2 + (2 + 2))) ((x mod (1 - (2 * (2 + 2)))) + 1) 1)
;; B C C C D D D K B C C C D F E H B D B J
(set-logic UFNIA)
(declare-fun f0 () Int)
(declare-fun f1 () Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= f0 0))
(assert (= h1 1))
(assert (= h0 (+ 1 2)))
(assert (= f1 (+ 1 (+ 2 (+ 2 2)))))
(assert (forall ((x Int)) (= (g0 x) (modf x (+ 1 (+ 2 (+ 2 2)))))))
(assert (forall ((x Int)) (= (g1 x) (+ (modf x (- 1 (* 2 (+ 2 2)))) 1))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y f0))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (small x) (+ 1 (* 2 (v0 x))))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y f1))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int)) (= (fast x) (v1 x))))
(assert (=> (= f0 f1) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
