;; small program: (if (x mod (loop (1 + (x + x)) 2 2)) <= 0 then (loop (1 + (x + x)) 2 2) else 1)
;; K B K K D D C C J H B K K D D C C J B I
;; fast program: (loop (1 + (2 + (2 * (2 + 2)))) (1 - (x mod (1 + (2 + (2 * (2 + 2)))))) 1)
;; B C C C C D F D D B K B C C C C D F D D H E B J
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 () Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 () Int)
(declare-fun v1 (Int) Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h1 1))
(assert (= g0 2))
(assert (= h0 2))
(assert (forall ((x Int)) (= (f0 x) (+ 1 (+ x x)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (= v0 (u0 g0 h0)))
(assert (= f1 (+ 1 (+ 2 (* 2 (+ 2 2))))))
(assert (forall ((x Int)) (= (g1 x) (- 1 (modf x (+ 1 (+ 2 (* 2 (+ 2 2)))))))))
(assert (forall ((x Int)) (= (small x) (ite (<= (modf x v0) 0) v0 1))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y f1))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int)) (= (fast x) (v1 x))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (u0 x y))))
(assert (=> (forall ((x Int)) (= (f0 x) f1)) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (=> (forall ((x Int)) (= (f0 x) f1)) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
