;; small program: ((if (x mod (loop (1 + (x + x)) 2 2)) <= 0 then 1 else (loop (1 + (x + x)) 2 2)) * x)
;; K B K K D D C C J H B B K K D D C C J I K F
;; fast program: (((x + x) * (if (x mod (1 + (2 + (2 * (2 + 2))))) <= 0 then 1 else (2 + (2 + 2)))) - x)
;; K K D K B C C C C D F D D H B C C C D D I F K E
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun h0 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun v0 () Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= g0 2))
(assert (= h0 2))
(assert (forall ((x Int)) (= (f0 x) (+ 1 (+ x x)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (= v0 (u0 g0 h0)))
(assert (forall ((x Int)) (= (small x) (* (ite (<= (modf x v0) 0) 1 v0) x))))
(assert (forall ((x Int)) (= (fast x) (- (* (+ x x) (ite (<= (modf x (+ 1 (+ 2 (* 2 (+ 2 2))))) 0) 1 (+ 2 (+ 2 2)))) x))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (u0 x y))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
