;; small program: (1 mod (loop (loop (loop y (x - y) x) x (1 + y)) x 2))
;; B L K L E K J K B L D J K C J H
;; fast program: (if ((1 + (loop (x - (if x <= 0 then 0 else y)) (loop (x * x) 2 2) x)) * x) <= 0 then 1 else (x - x))
;; B K K A L I E K K F C C J K J D K F B K K E I
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun f2 (Int Int) Int)
(declare-fun f3 (Int Int) Int)
(declare-fun f4 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun g2 (Int Int) Int)
(declare-fun g3 () Int)
(declare-fun g4 () Int)
(declare-fun h0 () Int)
(declare-fun h1 (Int Int) Int)
(declare-fun h2 (Int) Int)
(declare-fun h3 (Int) Int)
(declare-fun h4 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun u3 (Int Int) Int)
(declare-fun u4 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int Int) Int)
(declare-fun v2 (Int Int) Int)
(declare-fun v3 (Int) Int)
(declare-fun v4 () Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= g4 2))
(assert (= h0 2))
(assert (= h4 2))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (g1 x) x)))
(assert (forall ((x Int)) (= (h2 x) x)))
(assert (forall ((x Int)) (= (h3 x) x)))
(assert (forall ((x Int) (y Int)) (= (f2 x y) y)))
(assert (forall ((x Int) (y Int)) (= (h1 x y) (+ 1 y))))
(assert (forall ((x Int) (y Int)) (= (g2 x y) (- x y))))
(assert (forall ((x Int)) (= (f4 x) (* x x))))
(assert (forall ((x Int) (y Int)) (= (f3 x y) (- x (ite (<= x 0) 0 y)))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y) x)))))
(assert (forall ((x Int) (y Int)) (= (v2 x y) (u2 (g2 x y) (h2 x)))))
(assert (forall ((x Int) (y Int)) (= (f1 x y) (v2 x y))))
(assert (forall ((x Int) (y Int)) (= (u4 x y) (ite (<= x 0) y (f4 (u4 (- x 1) y))))))
(assert (= v4 (u4 g4 h4)))
(assert (= g3 v4))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y) x)))))
(assert (forall ((x Int) (y Int)) (= (v1 x y) (u1 (g1 x) (h1 x y)))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (v1 x y))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int) (y Int)) (= (u3 x y) (ite (<= x 0) y (f3 (u3 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v3 x) (u3 g3 (h3 x)))))
(assert (forall ((x Int)) (= (small x) (modf 1 (v0 x)))))
(assert (forall ((x Int)) (= (fast x) (ite (<= (* (+ 1 (v3 x)) x) 0) 1 (- x x)))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f3 x y))) (forall ((x Int) (y Int)) (= (u0 x y) (u3 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f4 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u4 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f1 x y) (f3 x y))) (forall ((x Int) (y Int)) (= (u1 x y) (u3 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f1 x y) (f4 x))) (forall ((x Int) (y Int)) (= (u1 x y) (u4 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f2 x y) (f3 x y))) (forall ((x Int) (y Int)) (= (u2 x y) (u3 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f2 x y) (f4 x))) (forall ((x Int) (y Int)) (= (u2 x y) (u4 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
