;; small program: (((loop (2 * ((x - (x div y)) + x)) x (1 + ((x * x) + x))) div 2) * x)
;; C K K L G E K D F K B K K F K D D J C G K F
;; fast program: (((loop (2 * (((x div y) + x) + x)) (x - 1) 1) div (if x <= 0 then 1 else x)) * ((((x * x) + x) * x) + x))
;; C K L G K D K D F K B E B J K B K I G K K F K D K F K D F
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(assert (= h1 1))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (g1 x) (- x 1))))
(assert (forall ((x Int)) (= (h0 x) (+ 1 (+ (* x x) x)))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (* 2 (+ (- x (divf x y)) x)))))
(assert (forall ((x Int) (y Int)) (= (f1 x y) (* 2 (+ (+ (divf x y) x) x)))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) (h0 x)))))
(assert (forall ((x Int)) (= (small x) (* (divf (v0 x) 2) x))))
(assert (forall ((x Int)) (= (fast x) (* (divf (v1 x) (ite (<= x 0) 1 x)) (+ (* (+ (* x x) x) x) x)))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f1 x y))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
