;; small program: (((loop ((if (((y - 1) div 2) mod (1 + 2)) <= 0 then 1 else 2) + x) x 1) * 2) + 1)
;; L B E C G B C D H B C I K D K B J C F B D
;; fast program: (((((((loop y ((x mod (2 + (2 + 2))) - 1) (1 + 2)) + x) + x) div (1 + 2)) + x) * 2) + 1)
;; L K C C C D D H B E B C D J K D K D B C D G K D C F B D
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h0 1))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int) (y Int)) (= (f1 x y) y)))
(assert (= h1 (+ 1 2)))
(assert (forall ((x Int)) (= (g1 x) (- (modf x (+ 2 (+ 2 2))) 1))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (+ (ite (<= (modf (divf (- y 1) 2) (+ 1 2)) 0) 1 2) x))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (small x) (+ (* (v0 x) 2) 1))))
(assert (forall ((x Int)) (= (fast x) (+ (* (+ (divf (+ (+ (v1 x) x) x) (+ 1 2)) x) 2) 1))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f1 x y))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
