;; small program: (loop (((1 + y) * (loop (x + y) y 1)) + x) x 1)
;; B L D K L D L B J F K D K B J
;; fast program: ((((((1 + x) * ((2 + x) * x)) div (1 + 2)) + ((loop ((x * x) + x) 1 (((x * x) + x) div 2)) div 2)) + 1) + x)
;; B K D C K D K F F B C D G K K F K D B K K F K D C G J C G D B D K D
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun f2 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int Int) Int)
(declare-fun g2 () Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun h2 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int Int) Int)
(declare-fun v2 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(assert (= g2 1))
(assert (= h0 1))
(assert (= h1 1))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int) (y Int)) (= (g1 x y) y)))
(assert (forall ((x Int) (y Int)) (= (f1 x y) (+ x y))))
(assert (forall ((x Int)) (= (f2 x) (+ (* x x) x))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y) x)))))
(assert (forall ((x Int) (y Int)) (= (v1 x y) (u1 (g1 x y) h1))))
(assert (forall ((x Int)) (= (h2 x) (divf (+ (* x x) x) 2))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (+ (* (+ 1 y) (v1 x y)) x))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y))))))
(assert (forall ((x Int)) (= (v2 x) (u2 g2 (h2 x)))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (small x) (v0 x))))
(assert (forall ((x Int)) (= (fast x) (+ (+ (+ (divf (* (+ 1 x) (* (+ 2 x) x)) (+ 1 2)) (divf (v2 x) 2)) 1) x))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f2 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u2 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f1 x y) (f2 x))) (forall ((x Int) (y Int)) (= (u1 x y) (u2 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
