;; small program: ((loop (2 * (((x div y) + x) + x)) x 1) mod (2 + x))
;; C K L G K D K D F K B J C K D H
;; fast program: ((if ((loop ((x * x) * x) 1 (2 + 2)) mod (2 + x)) <= 0 then (2 + x) else 0) div 2)
;; K K F K F B C C D J C K D H C K D A I C G
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 () Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 () Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= g1 1))
(assert (= h0 1))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (= h1 (+ 2 2)))
(assert (forall ((x Int)) (= (f1 x) (* (* x x) x))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (* 2 (+ (+ (divf x y) x) x)))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (= v1 (u1 g1 h1)))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (small x) (modf (v0 x) (+ 2 x)))))
(assert (forall ((x Int)) (= (fast x) (divf (ite (<= (modf v1 (+ 2 x)) 0) (+ 2 x) 0) 2))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f1 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
