;; small program: (loop (((if (y mod 2) <= 0 then y else 1) * y) + x) (1 + x) 0)
;; L C H L B I L F K D B K D A J
;; fast program: (loop ((loop (x * x) (y mod 2) (1 + y)) + x) x 1)
;; K K F L C H B L D J K D K B J
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun f2 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun g2 (Int Int) Int)
(declare-fun h0 () Int)
(declare-fun h1 () Int)
(declare-fun h2 (Int Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(declare-fun v2 (Int Int) Int)
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h0 0))
(assert (= h1 1))
(assert (forall ((x Int)) (= (g1 x) x)))
(assert (forall ((x Int)) (= (g0 x) (+ 1 x))))
(assert (forall ((x Int) (y Int)) (= (h2 x y) (+ 1 y))))
(assert (forall ((x Int)) (= (f2 x) (* x x))))
(assert (forall ((x Int) (y Int)) (= (g2 x y) (modf y 2))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (+ (* (ite (<= (modf y 2) 0) y 1) y) x))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y))))))
(assert (forall ((x Int) (y Int)) (= (v2 x y) (u2 (g2 x y) (h2 x y)))))
(assert (forall ((x Int) (y Int)) (= (f1 x y) (+ (v2 x y) x))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) h1))))
(assert (forall ((x Int)) (= (fast x) (v1 x))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) h0))))
(assert (forall ((x Int)) (= (small x) (v0 x))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f1 x y))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f2 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u2 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
