;; small program: ((if ((loop (loop y (x - y) x) x (1 + x)) - 1) <= 0 then 1 else 0) * (loop (0 - x) (x div 2) 1))
;; L K L E K J K B K D J B E B A I A K E K C G B J F
;; fast program: ((if ((loop (loop y (x - y) x) x (1 + x)) - 1) <= 0 then 1 else 0) * (1 - (((x * x) - x) mod (2 + 2))))
;; L K L E K J K B K D J B E B A I B K K F K E C C D H E F
(set-logic UFNIA)
(declare-fun f0 (Int Int) Int)
(declare-fun f1 (Int Int) Int)
(declare-fun f2 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int Int) Int)
(declare-fun g2 (Int) Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 (Int) Int)
(declare-fun h2 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun u2 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int Int) Int)
(declare-fun v2 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(define-fun modf ((a Int) (b Int)) Int (ite (< 0 b) (mod a b) (- (mod (- a) (- b)))))
(assert (= h2 1))
(assert (forall ((x Int)) (= (g0 x) x)))
(assert (forall ((x Int)) (= (h1 x) x)))
(assert (forall ((x Int) (y Int)) (= (f1 x y) y)))
(assert (forall ((x Int)) (= (h0 x) (+ 1 x))))
(assert (forall ((x Int)) (= (f2 x) (- 0 x))))
(assert (forall ((x Int) (y Int)) (= (g1 x y) (- x y))))
(assert (forall ((x Int)) (= (g2 x) (divf x 2))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y) x)))))
(assert (forall ((x Int) (y Int)) (= (v1 x y) (u1 (g1 x y) (h1 x)))))
(assert (forall ((x Int) (y Int)) (= (f0 x y) (v1 x y))))
(assert (forall ((x Int) (y Int)) (= (u2 x y) (ite (<= x 0) y (f2 (u2 (- x 1) y))))))
(assert (forall ((x Int)) (= (v2 x) (u2 (g2 x) h2))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y) x)))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) (h0 x)))))
(assert (forall ((x Int)) (= (small x) (* (ite (<= (- (v0 x) 1) 0) 1 0) (v2 x)))))
(assert (forall ((x Int)) (= (fast x) (* (ite (<= (- (v0 x) 1) 0) 1 0) (- 1 (modf (- (* x x) x) (+ 2 2)))))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (u0 x y))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (u1 x y))))
(assert (=> (forall ((x Int) (y Int)) (= (f2 x) (f0 x y))) (forall ((x Int) (y Int)) (= (u2 x y) (u0 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f2 x) (f1 x y))) (forall ((x Int) (y Int)) (= (u2 x y) (u1 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f0 x y))) (forall ((x Int) (y Int)) (= (u0 x y) (u0 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f0 x y) (f1 x y))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f1 x y) (f0 x y))) (forall ((x Int) (y Int)) (= (u1 x y) (u0 x y)))))
(assert (=> (forall ((x Int) (y Int)) (= (f1 x y) (f1 x y))) (forall ((x Int) (y Int)) (= (u1 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
