;; small program: (loop (1 + ((2 + (x + x)) div ((2 * (2 * (2 + 2))) - 1))) 2 (2 - x))
;; B C K K D D C C C C D F F B E G D C C K E J
;; fast program: (((((2 + (2 * (2 * (2 + 2)))) - x) div (loop (1 + (x * x)) 2 2)) div 2) + 1)
;; C C C C C D F F D K E B K K F D C C J G C G B D
(set-logic UFNIA)
(declare-fun f0 (Int) Int)
(declare-fun f1 (Int) Int)
(declare-fun fast (Int) Int)
(declare-fun g0 () Int)
(declare-fun g1 () Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 () Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 () Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(assert (= g0 2))
(assert (= g1 2))
(assert (= h1 2))
(assert (forall ((x Int)) (= (h0 x) (- 2 x))))
(assert (forall ((x Int)) (= (f1 x) (+ 1 (* x x)))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y (f1 (u1 (- x 1) y))))))
(assert (= v1 (u1 g1 h1)))
(assert (forall ((x Int)) (= (f0 x) (+ 1 (divf (+ 2 (+ x x)) (- (* 2 (* 2 (+ 2 2))) 1))))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y (f0 (u0 (- x 1) y))))))
(assert (forall ((x Int)) (= (v0 x) (u0 g0 (h0 x)))))
(assert (forall ((x Int)) (= (small x) (v0 x))))
(assert (forall ((x Int)) (= (fast x) (+ (divf (divf (- (+ 2 (* 2 (* 2 (+ 2 2)))) x) v1) 2) 1))))
(assert (=> (forall ((x Int)) (= (f0 x) (f1 x))) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
