;; small program: ((1 + (2 + 2)) * (((loop 2 (x div 2) x) + x) + x))
;; B C C D D C K C G K J K D K D F
;; fast program: ((((loop 2 (x - 2) x) + x) + x) * (1 + (2 + 2)))
;; C K C E K J K D K D B C C D D F
(set-logic UFNIA)
(declare-fun f0 () Int)
(declare-fun f1 () Int)
(declare-fun fast (Int) Int)
(declare-fun g0 (Int) Int)
(declare-fun g1 (Int) Int)
(declare-fun h0 (Int) Int)
(declare-fun h1 (Int) Int)
(declare-fun small (Int) Int)
(declare-fun u0 (Int Int) Int)
(declare-fun u1 (Int Int) Int)
(declare-fun v0 (Int) Int)
(declare-fun v1 (Int) Int)
(define-fun divf ((a Int) (b Int)) Int (ite (< 0 b) (div a b) (div (- a) (- b))))
(assert (= f0 2))
(assert (= f1 2))
(assert (forall ((x Int)) (= (h0 x) x)))
(assert (forall ((x Int)) (= (h1 x) x)))
(assert (forall ((x Int)) (= (g1 x) (- x 2))))
(assert (forall ((x Int)) (= (g0 x) (divf x 2))))
(assert (forall ((x Int) (y Int)) (= (u0 x y) (ite (<= x 0) y f0))))
(assert (forall ((x Int)) (= (v0 x) (u0 (g0 x) (h0 x)))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (ite (<= x 0) y f1))))
(assert (forall ((x Int)) (= (v1 x) (u1 (g1 x) (h1 x)))))
(assert (forall ((x Int)) (= (fast x) (* (+ (+ (v1 x) x) x) (+ 1 (+ 2 2))))))
(assert (forall ((x Int)) (= (small x) (* (+ 1 (+ 2 2)) (+ (+ (v0 x) x) x)))))
(assert (forall ((x Int) (y Int)) (= (u1 x y) (u0 x y))))
(assert (=> (= f0 f1) (forall ((x Int) (y Int)) (= (u0 x y) (u1 x y)))))
(assert (exists ((c Int)) (and (>= c 0) (not (= (small c) (fast c))))))
(check-sat)
